/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.binding;

import com.iosoft.helpers.BoolConsumer;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.binding.BoolBinding;
import com.iosoft.helpers.binding.BoolObservable;

public class Command {
    public final BoolObservable Available;
    private final Runnable runner;

    public Command(BoolObservable available, Runnable runner) {
        this.Available = Misc.notNull(available);
        this.runner = Misc.notNull(runner);
    }

    public Command(Runnable runner) {
        this.runner = Misc.notNull(runner);
        this.Available = BoolObservable.AlwaysTrue;
    }

    public boolean tryPerform() {
        if (!this.Available.get()) {
            return false;
        }
        this.runner.run();
        return true;
    }

    public void perform() {
        if (!this.Available.get()) {
            throw new IllegalStateException("Not available");
        }
        this.runner.run();
    }

    public BoolBinding bind(BoolConsumer consumer) {
        return this.Available.bind(consumer);
    }
}

