/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.binding;

import com.iosoft.helpers.BiBoolConsumer;
import com.iosoft.helpers.DisposableWrapper;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.TriConsumer;
import com.iosoft.helpers.binding.BoolObservable;
import com.iosoft.helpers.binding.MyBoolObservable;
import com.iosoft.helpers.binding.MyObservable;
import com.iosoft.helpers.binding.Observable;
import com.iosoft.helpers.event.ArgEvent;
import com.iosoft.helpers.event.BoolEvent;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Binding<T>
implements IDisposable {
    private Observable<T> target;
    private Consumer<T> action;

    public Binding(Observable<T> target, Consumer<T> action) {
        this.target = Misc.notNull(target, "target");
        this.action = Misc.notNull(action, "action");
        action.accept(target.get());
        ((ArgEvent)target.Changed).register(action);
    }

    @Override
    public void dispose() {
        if (this.target == null) {
            return;
        }
        Observable<T> originalTarget = this.target;
        this.target = null;
        ((ArgEvent)originalTarget.Changed).unregister(this.action);
        this.action = null;
    }

    public static <A> Pair<BoolObservable, IDisposable> translate(Observable<A> ob1, Predicate<A> evaluate) {
        MyBoolObservable observable = new MyBoolObservable(evaluate.test(ob1.get()));
        DisposableWrapper registerAtObs = new DisposableWrapper(((ArgEvent)ob1.Changed).registerHandler(a -> observable.set(evaluate.test(a))));
        return new Pair<BoolObservable, IDisposable>(observable.Getter, registerAtObs::dispose);
    }

    public static <A, R> Pair<Observable<R>, IDisposable> translate(Observable<A> ob1, Function<A, R> evaluate) {
        MyObservable observable = new MyObservable(evaluate.apply(ob1.get()));
        DisposableWrapper registerAtObs = new DisposableWrapper(((ArgEvent)ob1.Changed).registerHandler(a -> observable.set(evaluate.apply(a))));
        return new Pair<Observable<R>, IDisposable>(observable.Getter, registerAtObs::dispose);
    }

    public static <A, B, R> Pair<Observable<R>, IDisposable> translate(Observable<A> ob1, Observable<B> ob2, BiFunction<A, B, R> evaluate) {
        MyObservable observable = new MyObservable(evaluate.apply(ob1.get(), ob2.get()));
        DisposableWrapper registerAtObs1 = new DisposableWrapper(((ArgEvent)ob1.Changed).registerHandler(a -> observable.set(evaluate.apply(a, ob2.get()))));
        DisposableWrapper registerAtObs2 = new DisposableWrapper(((ArgEvent)ob2.Changed).registerHandler(b -> observable.set(evaluate.apply(ob1.get(), b))));
        return new Pair<Observable<R>, IDisposable>(observable.Getter, () -> {
            if (registerAtObs1.tryDispose()) {
                registerAtObs2.dispose();
            }
        });
    }

    public static <A, B> IDisposable bind(Observable<A> ob1, Observable<B> ob2, BiConsumer<A, B> evaluate) {
        DisposableWrapper registerAtObs1 = new DisposableWrapper(((ArgEvent)ob1.Changed).registerHandler(a -> evaluate.accept(a, ob2.get())));
        DisposableWrapper registerAtObs2 = new DisposableWrapper(ob2.bind(b -> evaluate.accept(ob1.get(), b)));
        evaluate.accept(ob1.get(), ob2.get());
        return () -> {
            if (registerAtObs1.tryDispose()) {
                registerAtObs2.dispose();
            }
        };
    }

    public static <A, B, C> IDisposable bind(Observable<A> ob1, Observable<B> ob2, Observable<C> ob3, TriConsumer<A, B, C> evaluate) {
        DisposableWrapper registerAtObs1 = new DisposableWrapper(((ArgEvent)ob1.Changed).registerHandler(x -> evaluate.accept(x, ob2.get(), ob3.get())));
        DisposableWrapper registerAtObs2 = new DisposableWrapper(ob2.bind(x -> evaluate.accept(ob1.get(), x, ob3.get())));
        DisposableWrapper registerAtObs3 = new DisposableWrapper(ob3.bind(x -> evaluate.accept(ob1.get(), ob2.get(), x)));
        evaluate.accept(ob1.get(), ob2.get(), ob3.get());
        return () -> {
            if (registerAtObs1.tryDispose()) {
                registerAtObs2.dispose();
                registerAtObs3.dispose();
            }
        };
    }

    public static IDisposable bind(BoolObservable ob1, BoolObservable ob2, BiBoolConsumer evaluate) {
        DisposableWrapper registerAtObs1 = new DisposableWrapper(((BoolEvent)ob1.Changed).registerHandler(a -> evaluate.accept(a, ob2.get())));
        DisposableWrapper registerAtObs2 = new DisposableWrapper(ob2.bind(b -> evaluate.accept(ob1.get(), b)));
        evaluate.accept(ob1.get(), ob2.get());
        return () -> {
            if (registerAtObs1.tryDispose()) {
                registerAtObs2.dispose();
            }
        };
    }
}

