/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.awt;

import com.iosoft.helpers.FailableResult;
import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Pair;
import com.iosoft.helpers.async.Async;
import com.iosoft.helpers.async.Task;
import com.iosoft.helpers.datasource.IDataSource;
import com.iosoft.helpers.io.MiscIO;
import com.iosoft.helpers.ui.awt.MiscAWT;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public final class MiscImg {
    public static final int ALPHA_MASK = -16777216;
    public static final int COLOR_MASK = 0xFFFFFF;
    public static final int ALPHA_SHIFT_BITS = 24;
    public static final float COLOR_MAX = 255.0f;
    public static final DateTimeFormatter ScreenshotNameFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");

    private MiscImg() {
        ImageIO.setUseCache(false);
    }

    public static BufferedImage mergeImages(Image base, Image over) {
        BufferedImage img = new BufferedImage(base.getWidth(null), base.getWidth(null), 2);
        Graphics2D g = img.createGraphics();
        g.drawImage(base, 0, 0, null);
        g.drawImage(over, 0, 0, null);
        g.dispose();
        return img;
    }

    public static BufferedImage createColoredCopy(BufferedImage src, Color color) {
        int w = src.getWidth();
        int h = src.getHeight();
        float red = color.getRed();
        float green = color.getGreen();
        float blue = color.getBlue();
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g = img.createGraphics();
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        int[] buffer = new int[4];
        WritableRaster wr = img.getRaster();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                wr.getPixel(x, y, buffer);
                float average = (float)(buffer[0] + buffer[1] + buffer[2]) / 765.0f;
                buffer[0] = (int)(red * average);
                buffer[1] = (int)(green * average);
                buffer[2] = (int)(blue * average);
                wr.setPixel(x, y, buffer);
                ++y;
            }
            ++x;
        }
        return img;
    }

    public static BufferedImage rotateImage(Image src, double rad) {
        return MiscImg.rotateImage(src, new BufferedImage(src.getWidth(null), src.getHeight(null), 2), rad);
    }

    public static BufferedImage rotateImage(Image src, BufferedImage dest, double rad) {
        BufferedImage rotatedImage = dest;
        Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
        MiscAWT.setBestQuality(g);
        g.rotate(-rad, (double)dest.getWidth() * 0.5, (double)dest.getHeight() * 0.5);
        g.translate((double)(dest.getWidth() - src.getWidth(null)) * 0.5, (double)(dest.getHeight() - src.getHeight(null)) * 0.5);
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return rotatedImage;
    }

    public static Image resize4rotate(Image src) {
        double oldwidth = src.getWidth(null);
        double oldheight = src.getHeight(null);
        double width = oldwidth * Math.sqrt(2.0);
        double height = oldheight * Math.sqrt(2.0);
        BufferedImage img = new BufferedImage((int)Math.round(width), (int)Math.round(height), 2);
        Graphics g = img.getGraphics();
        g.drawImage(src, (int)Math.round((width - oldwidth) * 0.5), (int)Math.round((height - oldheight) * 0.5), null);
        g.dispose();
        return img;
    }

    public static BufferedImage getReplacedColorInstance(Image img, Color rgb, Color rgb2) {
        return MiscImg.getReplacedColorInstance(img, MiscAWT.getRGBA(rgb), MiscAWT.getRGBA(rgb2));
    }

    public static BufferedImage getReplacedColorInstance(Image img, int rgb, int rgb2) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage img2 = new BufferedImage(w, h, 2);
        Graphics2D g = img2.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                int i = img2.getRGB(x, y);
                if (i == rgb) {
                    img2.setRGB(x, y, rgb2);
                }
                ++y;
            }
            ++x;
        }
        return img2;
    }

    public static BufferedImage rotate90DegreeSteps(Image src, int step) {
        return MiscImg.rotate90DegreeSteps((w, h) -> new BufferedImage(w, h, 2), src, step);
    }

    public static <T extends BufferedImage> T rotate90DegreeSteps(ImageCreator<T> creator, Image src, int step) {
        int srcW = src.getWidth(null);
        int srcH = src.getHeight(null);
        int destW = Misc.even(step) ? srcW : srcH;
        int destH = Misc.even(step) ? srcH : srcW;
        BufferedImage dest = (BufferedImage)creator.create(destW, destH);
        Graphics2D g = dest.createGraphics();
        g.translate((double)destW * 0.5, (double)destH * 0.5);
        g.rotate((double)step * 1.5707963267948966);
        g.translate((double)srcW * -0.5, (double)srcH * -0.5);
        g.drawImage(src, 0, 0, null);
        g.dispose();
        return (T)dest;
    }

    public static BufferedImage[] rotate90DegreeStepsPrepared(GraphicsConfiguration cfg, int transparency, Image src) {
        BufferedImage[] dest = new BufferedImage[4];
        int i = 0;
        while (i < dest.length) {
            dest[i] = MiscImg.rotate90DegreeSteps((w, h) -> cfg.createCompatibleImage(w, h, transparency), src, i);
            ++i;
        }
        return dest;
    }

    public static BufferedImage[] rotate90DegreeStepsPrepared(GraphicsConfiguration cfg, int transparency, String resPath) throws IOException {
        BufferedImage src = MiscImg.loadImage(resPath);
        BufferedImage[] dst = MiscImg.rotate90DegreeStepsPrepared(cfg, transparency, src);
        src.flush();
        return dst;
    }

    public static BufferedImage[] rotate90DegreeStepsPrepared(GraphicsConfiguration cfg, int transparency, IDataSource dataSource) throws IOException {
        BufferedImage src = MiscImg.loadImage(dataSource);
        BufferedImage[] dst = MiscImg.rotate90DegreeStepsPrepared(cfg, transparency, src);
        src.flush();
        return dst;
    }

    public static BufferedImage[] rotate90DegreeStepsPrepared(GraphicsConfiguration cfg, Image src) {
        return MiscImg.rotate90DegreeStepsPrepared(cfg, 3, src);
    }

    public static BufferedImage loadImage(String path) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream in = MiscIO.getResource(path);){
            return ImageIO.read(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static BufferedImage loadImage(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File '" + file.getPath() + "' does not exist");
        }
        BufferedImage img = ImageIO.read(file);
        if (img == null) {
            throw new IOException("File '" + file.getPath() + "' could not be read");
        }
        return img;
    }

    public static BufferedImage loadImage(IDataSource dataSource) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream bis = dataSource.openBufferedStream();){
            BufferedImage img = ImageIO.read(bis);
            if (img == null) {
                throw new IOException("'" + dataSource + "' could not be read");
            }
            return img;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static BufferedImage tryLoadImage(IDataSource dataSource) throws IOException {
        InputStream in = dataSource.tryOpenBufferedStream();
        if (in == null) {
            return null;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream bis = in;){
            BufferedImage img = ImageIO.read(bis);
            if (img == null) {
                throw new IOException("'" + dataSource + "' could not be read");
            }
            return img;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Task<FailableResult<BufferedImage, IOException>> loadImageAsync(File file) {
        return Async.runAsyncWrap(() -> MiscImg.loadImage(file));
    }

    public static BufferedImage loadImagePrepared(String resourcePath) throws IOException {
        return MiscImg.loadImagePrepared(resourcePath, 3);
    }

    public static BufferedImage loadImagePrepared(String resourcePath, int transparency) throws IOException {
        return MiscImg.prepareImage(MiscImg.loadImage(resourcePath), transparency);
    }

    public static BufferedImage loadImagePrepared(File file) throws IOException {
        return MiscImg.loadImagePrepared(file, 3);
    }

    public static BufferedImage loadImagePrepared(File file, int transparency) throws IOException {
        return MiscImg.prepareImage(MiscImg.loadImage(file), transparency);
    }

    public static BufferedImage loadImagePrepared(IDataSource source) throws IOException {
        return MiscImg.loadImagePrepared(source, 3);
    }

    public static BufferedImage loadImagePrepared(IDataSource source, int transparency) throws IOException {
        return MiscImg.prepareImage(MiscImg.loadImage(source), transparency);
    }

    public static BufferedImage prepareImage(Image source, int transparency) {
        return MiscImg.prepareImage(MiscAWT.getGraphicsConfiguration(), source, transparency);
    }

    public static BufferedImage prepareImage(Image source) {
        return MiscImg.prepareImage(source, 3);
    }

    public static BufferedImage prepareImage(GraphicsConfiguration config, Image source, int transparency) {
        BufferedImage b = config.createCompatibleImage(source.getWidth(null), source.getHeight(null), transparency);
        Graphics2D g = b.createGraphics();
        g.drawImage(source, 0, 0, null);
        g.dispose();
        source.flush();
        return b;
    }

    public static File getScreenshotFile(File directory, String suffix, ScreenshotFormat format, boolean overwriteDuplicates) {
        String filenameBase = String.valueOf(LocalDateTime.now().format(ScreenshotNameFormat)) + suffix;
        File file = new File(directory, String.valueOf(filenameBase) + "." + format.Extension);
        if (!overwriteDuplicates) {
            int counter = 0;
            while (file.exists()) {
                file = new File(directory, String.valueOf(filenameBase) + "_" + counter + "." + format.Extension);
                ++counter;
            }
        }
        return file;
    }

    public static void takeScreenshot(Component c, File directory) {
        MiscImg.takeScreenshot(c, directory, ScreenshotFormat.Png);
    }

    public static void takeScreenshot(Component c, File directory, ScreenshotFormat format) {
        MiscImg.takeScreenshot(c, directory, format, false);
    }

    public static void takeScreenshot(Component c, File directory, ScreenshotFormat format, boolean overwriteDuplicates) {
        MiscImg.takeScreenshotFile(c, MiscImg.getScreenshotFile(directory, "", format, overwriteDuplicates), format);
    }

    public static BufferedImage takeScreenshot(Component c) {
        BufferedImage img = new BufferedImage(c.getWidth(), c.getHeight(), 1);
        Graphics2D g = img.createGraphics();
        c.paint(g);
        g.dispose();
        return img;
    }

    public static void takeScreenshotFile(Component c, File file, ScreenshotFormat format) {
        BufferedImage img = MiscImg.takeScreenshot(c);
        MiscImg.writeScreenshot(img, file, format);
    }

    public static void writeScreenshot(BufferedImage img, File file, ScreenshotFormat format) {
        try {
            try {
                File parent = file.getParentFile();
                MiscIO.mkdirs(parent);
                if (!ImageIO.write((RenderedImage)img, format.Extension, file)) {
                    throw new IOException("No image writer for " + format.Extension + " found");
                }
            }
            catch (IOException ex) {
                Log.Developer.errorFull("Screenshot could not be written", ex);
                img.flush();
            }
        }
        finally {
            img.flush();
        }
    }

    public static BufferedImage createCompatibleImage(int x, int y) {
        return MiscImg.createCompatibleImage(x, y, 3);
    }

    public static BufferedImage createCompatibleImage(int x, int y, int transparency) {
        return MiscAWT.getGraphicsConfiguration().createCompatibleImage(x, y, transparency);
    }

    public static void flush(BufferedImage[] images) {
        int i = 0;
        while (i < images.length) {
            images[i].flush();
            images[i] = null;
            ++i;
        }
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH) {
        return MiscImg.resize(img, newW, newH, 2);
    }

    public static BufferedImage resize(BufferedImage img, int newW, int newH, int colorModel) {
        BufferedImage copy = MiscImg.resizeCopy(img, newW, newH, colorModel);
        img.flush();
        return copy;
    }

    public static BufferedImage resizeKeepRatio(BufferedImage img, int newW, int newH, int colorModel, boolean takeLargerSize) {
        double ratio = (double)img.getWidth() / (double)img.getHeight();
        double widthForMaxHeight = (double)newH * ratio;
        if (ratio != 0.0 && widthForMaxHeight > (double)newW != takeLargerSize) {
            newH = (int)Math.round((double)newW / ratio);
        } else {
            newW = (int)Math.round(widthForMaxHeight);
        }
        BufferedImage copy = MiscImg.resizeCopy(img, newW, newH, colorModel);
        img.flush();
        return copy;
    }

    public static BufferedImage resizePrepared(Image img, int newW, int newH) {
        return MiscImg.resizePrepared(img, newW, newH, 3);
    }

    public static BufferedImage resizePrepared(Image img, int newW, int newH, int transparency) {
        BufferedImage copy = MiscAWT.getGraphicsConfiguration().createCompatibleImage(newW, newH, transparency);
        MiscImg.drawResizedCopy(img, copy, newW, newH);
        return copy;
    }

    public static BufferedImage resizeCopy(Image img, int newW, int newH) {
        return MiscImg.resizeCopy(img, newW, newH, 2);
    }

    public static BufferedImage resizeCopy(Image img, int newW, int newH, int colorModel) {
        BufferedImage copy = new BufferedImage(newW, newH, colorModel);
        MiscImg.drawResizedCopy(img, copy, newW, newH);
        return copy;
    }

    public static void drawResizedCopy(Image imgSource, BufferedImage imgDestination, int newW, int newH) {
        Graphics2D g = imgDestination.createGraphics();
        MiscAWT.setBestQuality(g);
        Image scaledImage = imgSource.getScaledInstance(newW, newH, 4);
        g.drawImage(scaledImage, 0, 0, null);
        scaledImage.flush();
        g.dispose();
    }

    public static BufferedImage getResizedCopy(BufferedImage base, BufferedImage old, GraphicsConfiguration cfg, double scaleX, double scaleY, boolean transparency) {
        if (old != null) {
            old.flush();
        }
        int width = (int)Math.ceil((double)base.getWidth() * scaleX);
        int height = (int)Math.ceil((double)base.getHeight() * scaleY);
        BufferedImage copy = cfg.createCompatibleImage(width, height, transparency ? 3 : 1);
        Graphics2D g = copy.createGraphics();
        MiscAWT.setBestQuality(g);
        Image scaledImage = base.getScaledInstance(width, height, 4);
        g.drawImage(scaledImage, 0, 0, null);
        scaledImage.flush();
        g.dispose();
        return copy;
    }

    public static Image getStaticColorInstance(Image image, Color color) {
        final float alphaMultiplier = (float)color.getAlpha() / 255.0f;
        final int rgbColor = color.getRGB() & 0xFFFFFF;
        RGBImageFilter filter = alphaMultiplier >= 1.0f ? new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                return rgb & 0xFF000000 | rgbColor;
            }
        } : new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                return (int)((float)((rgb & 0xFF000000) >> 24 & 0xFF) * alphaMultiplier) << 24 | rgbColor;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static void writeJPEG(File file, RenderedImage image, float quality) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        if (!iter.hasNext()) {
            throw new IOException("No JPEG writer found");
        }
        ImageWriter writer = iter.next();
        try {
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(quality);
            Throwable throwable = null;
            Object var7_8 = null;
            try (FileOutputStream faos = new FileOutputStream(file);){
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (BufferedOutputStream bos = new BufferedOutputStream(faos);){
                    Throwable throwable3 = null;
                    Object var13_18 = null;
                    try (ImageOutputStream fios = ImageIO.createImageOutputStream(bos);){
                        writer.setOutput(fios);
                        writer.write(null, new IIOImage(image, null, null), iwp);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        finally {
            writer.dispose();
        }
    }

    public static Pair<BufferedImage, String> tryGetFormat(byte[] data) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);){
            return MiscImg.tryGetFormat(bais);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Pair<BufferedImage, String> tryGetFormat(InputStream stream) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ImageInputStream input = ImageIO.createImageInputStream(stream);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
            while (readers.hasNext()) {
                ImageReader reader = readers.next();
                try {
                    reader.setInput(input);
                    BufferedImage image = reader.read(0);
                    Pair<BufferedImage, String> pair = new Pair<BufferedImage, String>(image, reader.getFormatName());
                    reader.dispose();
                    return pair;
                }
                catch (IOException e) {
                    try {
                        Log.Developer.errorShort("TryGetFormat", e);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        reader.dispose();
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return null;
    }

    @FunctionalInterface
    public static interface ImageCreator<T> {
        public T create(int var1, int var2);
    }

    public static enum ScreenshotFormat {
        Png("png"),
        Jpg("jpg");

        public final String Extension;

        private ScreenshotFormat(String extension) {
            this.Extension = extension;
        }
    }
}

