/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.awt;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.awt.MiscImg;
import java.awt.image.BufferedImage;

public class ImageCollection
implements IDisposable {
    public final BufferedImage Source;
    public final BufferedImage[] Images;
    public final int Cols;
    public final int Rows;

    public ImageCollection(BufferedImage source, int cols, int rows) {
        this.Source = source;
        this.Cols = cols;
        this.Rows = rows;
        this.Images = new BufferedImage[cols * rows];
        int sx = this.Source.getWidth() / cols;
        int sy = this.Source.getHeight() / rows;
        int x = 0;
        while (x < cols) {
            int y = 0;
            while (y < rows) {
                BufferedImage subImage;
                int i = this.getIndex(x, y);
                this.Images[i] = subImage = this.Source.getSubimage(sx * x, sy * y, sx, sy);
                ++y;
            }
            ++x;
        }
    }

    public int getIndex(int x, int y) {
        return x + y * this.Cols;
    }

    public BufferedImage get(int x, int y) {
        return this.Images[this.getIndex(x, y)];
    }

    @Override
    public void dispose() {
        this.Source.flush();
        MiscImg.flush(this.Images);
    }

    public static BufferedImage[] splitLeaky(BufferedImage source, int cols, int rows) {
        return new ImageCollection((BufferedImage)source, (int)cols, (int)rows).Images;
    }
}

