/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.audio.wav;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.audio.IAudioSource;
import com.iosoft.helpers.audio.wav.SimpleSound;
import com.iosoft.helpers.datasource.IDataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;

public final class SmallSound
implements IDisposable,
IAudioSource {
    private List<Runnable> closeListeners = new ArrayList<Runnable>();
    private final Object lock = new Object();
    private byte[] data;
    private boolean destroyed = false;

    public static SmallSound load(IDataSource source) throws IOException {
        return new SmallSound(source.load());
    }

    private SmallSound(byte[] data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable r) {
        Object object = this.lock;
        synchronized (object) {
            this.closeListeners.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.lock;
        synchronized (object) {
            return this.destroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            this.destroyed = true;
        }
    }

    public void play() {
        this.play(1.0f, 0.0f);
    }

    @Override
    public void play(float volume) {
        this.play(volume, 0.0f);
    }

    public void play(float volume, float balance) {
        if (volume < 0.0f) {
            volume = 0.0f;
        }
        if (balance < -1.0f) {
            balance = -1.0f;
        } else if (balance > 1.0f) {
            balance = 1.0f;
        }
        if (volume > 0.0f) {
            new PlayerThread(volume, balance);
        }
    }

    private class PlayerThread
    extends Thread {
        private float volume;
        private float balance;

        PlayerThread(float volume, float balance) {
            this.volume = volume;
            this.balance = balance;
            this.setName("PlayerThread");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SmallSound.this.lock;
            synchronized (object) {
                try {
                    Clip clip = SimpleSound.createClip(SmallSound.this.data);
                    clip.addLineListener(e -> {
                        if (e.getType() == LineEvent.Type.STOP) {
                            clip.close();
                            Object object = SmallSound.this.lock;
                            synchronized (object) {
                                int i = 0;
                                while (i < SmallSound.this.closeListeners.size()) {
                                    ((Runnable)SmallSound.this.closeListeners.get(i)).run();
                                    ++i;
                                }
                            }
                        }
                    });
                    if (this.volume != 1.0f || this.balance != 0.0f) {
                        SimpleSound.setVolumeAndBalance(clip, this.volume, this.balance);
                    }
                    clip.start();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

