/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.audio.wav;

import com.iosoft.helpers.DisposableWrapper;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.audio.wav.SimpleSound;
import com.iosoft.helpers.datasource.IDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class SmallLoop
implements IDisposable {
    private static final double KEEP_PLAYING_SILENTLY_SECONDS = 20.0;
    private Clip clip;
    private List<Runnable> closeListeners = new ArrayList<Runnable>();
    private final Object lock = new Object();
    private float _balance;
    private float _volume = 1.0f;
    private boolean _muted;
    private boolean _setMuted;
    private boolean playing;
    private final DisposableWrapper playingKeepAlive = new DisposableWrapper();
    public boolean StopImmediately = false;

    public static SmallLoop load(IDataSource source) throws IOException {
        try {
            Clip clip = AudioSystem.getClip();
            clip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(source.load())));
            return new SmallLoop(clip);
        }
        catch (IllegalArgumentException | LineUnavailableException | UnsupportedAudioFileException e) {
            throw new IOException(e);
        }
    }

    private SmallLoop(Clip clip) {
        this.clip = clip;
        clip.addLineListener(e -> {
            if (e.getType() == LineEvent.Type.STOP) {
                Object object = this.lock;
                synchronized (object) {
                    for (Runnable closeListener : this.closeListeners) {
                        closeListener.run();
                    }
                }
            }
        });
        this.setClipStuff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable r) {
        Object object = this.lock;
        synchronized (object) {
            this.closeListeners.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolume(float volume) {
        Object object = this.lock;
        synchronized (object) {
            this._volume = volume;
            this.setClipStuff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMuted(boolean muted) {
        Object object = this.lock;
        synchronized (object) {
            this._muted = muted;
            this.setClipStuff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBalance(float balance) {
        Object object = this.lock;
        synchronized (object) {
            this._balance = Misc.clamp(balance, -1.0f, 1.0f);
            this.setClipStuff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaying(boolean play, float volume, float balance) {
        Object object = this.lock;
        synchronized (object) {
            this._volume = volume;
            this._balance = Misc.clamp(balance, -1.0f, 1.0f);
            this._muted = !this.StopImmediately && !play;
            this.setClipStuff();
            if (play) {
                if (!this.playing) {
                    this.playingKeepAlive.dispose();
                    this.startInternal();
                }
            } else if (this.playing && this.playingKeepAlive.Object == null) {
                if (this.StopImmediately) {
                    this.stopInternal();
                } else {
                    VTask task = VTask.delay(20.0);
                    this.playingKeepAlive.Object = task::cancel;
                    task.await(() -> {
                        this.playingKeepAlive.Object = null;
                        this.stop();
                    });
                }
            }
        }
    }

    private void setClipStuff() {
        if (this.clip != null) {
            SimpleSound.setVolumeAndBalance(this.clip, this._volume, this._balance);
            if (this._muted != this._setMuted && this.clip.isControlSupported(BooleanControl.Type.MUTE)) {
                this._setMuted = this._muted;
                BooleanControl muteControl = (BooleanControl)this.clip.getControl(BooleanControl.Type.MUTE);
                muteControl.setValue(this._muted);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.playing) {
                return;
            }
            this.startInternal();
        }
    }

    private void startInternal() {
        this.playing = true;
        if (this.clip != null) {
            this.clip.loop(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.playing) {
                return;
            }
            this.stopInternal();
        }
    }

    private void stopInternal() {
        this.playing = false;
        if (this.clip != null) {
            this.clip.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            this.playingKeepAlive.dispose();
            if (this.clip != null) {
                this.clip.stop();
                this.clip.flush();
                this.clip.close();
                this.clip = null;
            }
        }
    }
}

