/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.audio.wav;

import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.audio.IAudioSource;
import com.iosoft.helpers.datasource.IDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class SimpleSound
implements IAudioSource {
    private long microseconds_restartAllowedAt;
    private ClipWrapper[] _clips;
    private int pos;
    private final Object lock = new Object();
    private ReplayFix _replayFix = ReplayFix.DispatcherDelay;
    public static final double LogVolMul = 20.0 / Math.log(10.0);

    public static void playOnce(IDataSource source) throws IOException {
        SimpleSound.playOnce(source, 1.0f);
    }

    public static void playOnce(IDataSource source, float volume) throws IOException {
        SimpleSound.playOnce(source, volume, 0.0f);
    }

    public static void playOnce(IDataSource source, float volume, float balance) throws IOException {
        if (volume > 0.0f) {
            SimpleSound.load(source, 1, 0.0).play(volume, balance, true);
        }
    }

    public static SimpleSound load(IDataSource source, int count) throws IOException {
        return SimpleSound.load(source, count, 0.0);
    }

    public static SimpleSound load(IDataSource source, int count, double restartAllowedAtSeconds) throws IOException {
        SimpleSound sound = new SimpleSound(count);
        sound.microseconds_restartAllowedAt = (long)(restartAllowedAtSeconds * 1000000.0);
        byte[] data = source.load();
        try {
            int i = 0;
            while (i < count) {
                sound._clips[i] = new ClipWrapper(SimpleSound.createClip(data));
                ++i;
            }
        }
        catch (IOException e) {
            sound.destroy();
            throw e;
        }
        return sound;
    }

    public static Clip createClip(byte[] source) throws IOException {
        try {
            AudioInputStream inputStream = AudioSystem.getAudioInputStream(new ByteArrayInputStream(source));
            AudioFormat format = inputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            Clip clip = (Clip)AudioSystem.getLine(info);
            try {
                clip.open(inputStream);
            }
            catch (Exception e) {
                Misc.forceClose(clip);
                throw e;
            }
            return clip;
        }
        catch (IllegalArgumentException | LineUnavailableException | UnsupportedAudioFileException e) {
            throw new IOException("Invalid data", e);
        }
    }

    private SimpleSound(int count) {
        this._clips = new ClipWrapper[count];
    }

    public void setReplayFix(ReplayFix value) {
        this._replayFix = Misc.notNull(value);
    }

    public ReplayFix getReplayFix() {
        return this._replayFix;
    }

    public void play() {
        this.play(1.0f, 0.0f);
    }

    @Override
    public void play(float volume) {
        this.play(volume, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(float volume, float balance) {
        Object object = this.lock;
        synchronized (object) {
            if (balance < -1.0f) {
                balance = -1.0f;
            } else if (balance > 1.0f) {
                balance = 1.0f;
            }
            if (volume > 0.0f && this._clips != null && this._clips.length > 0) {
                this.play(volume, balance, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void play(float volume, float balance, boolean once) {
        Object object = this.lock;
        synchronized (object) {
            ClipWrapper myClipWrapper = this._clips[this.pos];
            final Clip myClip = myClipWrapper.Clip;
            ++this.pos;
            if (this.pos == this._clips.length) {
                this.pos = 0;
            }
            if (this.microseconds_restartAllowedAt > 0L && myClip.isActive() && myClip.getMicrosecondPosition() < this.microseconds_restartAllowedAt) {
                return;
            }
            boolean wasPlaying = myClip.isRunning();
            if (wasPlaying) {
                myClip.stop();
                myClip.flush();
            }
            myClip.setFramePosition(0);
            SimpleSound.setVolumeAndBalance(myClip, volume, balance);
            if (once) {
                myClip.addLineListener(new LineListener(){

                    @Override
                    public void update(LineEvent e) {
                        if (e.getType() == LineEvent.Type.STOP) {
                            myClip.removeLineListener(this);
                            SimpleSound.this.destroy();
                        }
                    }
                });
            }
            if (wasPlaying) {
                if (this._replayFix == ReplayFix.ThreadSleep) {
                    Misc.sleep(1L);
                } else if (this._replayFix == ReplayFix.DispatcherDelay) {
                    if (myClipWrapper.Waiter == null) {
                        myClipWrapper.Waiter = Dispatcher.getForCurrentThread().delay(0.0, () -> {
                            clipWrapper.Waiter = null;
                            myClip.start();
                        });
                    }
                    return;
                }
            }
            myClip.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this._clips == null) {
                return;
            }
            int i = 0;
            while (i < this._clips.length) {
                ClipWrapper clipWrapper = this._clips[i];
                Clip clip = clipWrapper.Clip;
                if (clipWrapper.Waiter != null) {
                    clipWrapper.Waiter.dispose();
                    clipWrapper.Waiter = null;
                }
                if (clip != null) {
                    clip.stop();
                    clip.flush();
                    clip.close();
                }
                this._clips[i] = null;
                ++i;
            }
            this._clips = null;
        }
    }

    public static double volumeToDb(double volume) {
        return Math.log(volume) * LogVolMul;
    }

    public static float volumeToDbCapped(double volume) {
        return Misc.clamp((float)SimpleSound.volumeToDb(volume), -80.0f, 6.0206f);
    }

    public static void setVolume(Line line, float volume) {
        if (line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
            gainControl.setValue(SimpleSound.volumeToDbCapped(volume));
        }
    }

    public static void setBalance(DataLine line, float balance) {
        if (line.getFormat().getChannels() != 1 && line.isControlSupported(FloatControl.Type.BALANCE)) {
            FloatControl balanceControl = (FloatControl)line.getControl(FloatControl.Type.BALANCE);
            balanceControl.setValue(Misc.clamp(balance, -1.0f, 1.0f));
        }
    }

    public static void setVolumeAndBalance(DataLine line, float volume, float balance) {
        SimpleSound.setVolume(line, volume);
        SimpleSound.setBalance(line, balance);
    }

    private static class ClipWrapper {
        public final Clip Clip;
        public IDisposable Waiter;

        ClipWrapper(Clip clip) {
            this.Clip = clip;
        }
    }

    public static enum ReplayFix {
        Off,
        DispatcherDelay,
        ThreadSleep;

    }
}

