/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.audio.wav;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.audio.wav.SimpleSound;
import com.iosoft.helpers.datasource.IDataSource;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sound.sampled.Clip;

@Deprecated
public final class AudioPlayer {
    private static String soundDir = "/";

    private AudioPlayer() {
    }

    public static void setSoundDir(String dir) {
        soundDir = dir;
    }

    public static Clips load(IDataSource source, int count, boolean loopChannel) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DataInputStream dis = new DataInputStream(source.openBufferedStream());){
                byte[] buffer = new byte[1024];
                int read = 0;
                while ((read = dis.read(buffer)) >= 0) {
                    baos.write(buffer, 0, read);
                }
                byte[] data = baos.toByteArray();
                System.out.println("Sound '" + soundDir + source + "' succesfully loaded.");
                return new Clips(data, count, loopChannel);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            System.out.println("Sound '" + soundDir + source + "' could not be loaded.");
            return null;
        }
    }

    public static void init() {
    }

    public static class Clips {
        public Clip[] clips;
        public Clip loopClip;
        private byte[] buffer;
        private int p;
        private int count;

        public Clips(byte[] buffer, int count, boolean loopChannel) throws IOException {
            if (buffer == null) {
                return;
            }
            this.buffer = buffer;
            this.clips = new Clip[count];
            this.count = count;
            int i = 0;
            while (i < count) {
                this.clips[i] = SimpleSound.createClip(buffer);
                ++i;
            }
            if (loopChannel) {
                this.loopClip = SimpleSound.createClip(buffer);
            }
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void play2() {
            if (this.clips == null) {
                return;
            }
            Clip clip = this.clips[this.p];
            synchronized (clip) {
                this.clips[this.p].stop();
                if (this.clips[this.p].isRunning()) {
                    Log.General.error("Clip still running?!");
                }
                this.clips[this.p].setFramePosition(0);
                this.clips[this.p].start();
            }
        }

        private void toNext() {
            ++this.p;
            if (this.p >= this.count) {
                this.p = 0;
            }
        }

        public boolean isLooping() {
            if (this.loopClip != null) {
                return this.loopClip.isActive();
            }
            return false;
        }

        public void stopLoop() {
            this.loopClip.stop();
            this.loopClip.setFramePosition(0);
        }

        public void play() {
            this.play2();
            this.toNext();
        }

        public void playLoop() {
            this.playLoop(-1);
        }

        public void playLoop(int times) {
            if (this.loopClip != null) {
                this.loopClip.loop(times);
            }
        }

        public void stop() {
            this.clips[this.p].stop();
        }
    }

    @Deprecated
    public static class Playlist {
        private final List<Clip> clips = new ArrayList<Clip>();
        private final List<Clip> playlist = new ArrayList<Clip>();
        private VTask switchTask;
        private Order order = Order.DEFAULT;
        private boolean played;
        private boolean repeat;
        private boolean running;
        private final Object lockList = new Object();
        private final Object lockType = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOrder(Order order) {
            Object object = this.lockType;
            synchronized (object) {
                this.order = order;
            }
        }

        public void setRepeat(boolean repeat) {
            this.repeat = repeat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addClip(Clips newclip) {
            if (newclip != null) {
                Object object = this.lockList;
                synchronized (object) {
                    try {
                        Clip clip = SimpleSound.createClip(newclip.getBuffer());
                        this.clips.add(clip);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public void play() {
            if (this.running) {
                return;
            }
            this.running = true;
            this.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restart() {
            Object object = this.lockList;
            synchronized (object) {
                this.stop();
                this.playlist.clear();
                this.play();
            }
        }

        public void stop() {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.stopClip();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopClip() {
            Object object = this.lockList;
            synchronized (object) {
                if (!this.playlist.isEmpty()) {
                    this.playlist.get(0).stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void next() {
            Object object = this.lockList;
            synchronized (object) {
                if (!this.played || this.repeat && this.running) {
                    if (!this.playlist.isEmpty()) {
                        this.playlist.get(0).stop();
                        this.playlist.get(0).setFramePosition(0);
                        this.playlist.remove(0);
                    }
                    if (this.playlist.isEmpty()) {
                        if (!this.clips.isEmpty()) {
                            this.played = true;
                            int iC = this.clips.size();
                            int i = 0;
                            while (i < iC) {
                                this.playlist.add(this.clips.get(i));
                                ++i;
                            }
                            Object object2 = this.lockType;
                            synchronized (object2) {
                                if (this.order == Order.RANDOM) {
                                    Collections.shuffle(this.playlist);
                                }
                            }
                        } else {
                            this.running = false;
                        }
                    }
                    if (!this.playlist.isEmpty()) {
                        Clip clip = this.playlist.get(0);
                        clip.start();
                        if (this.switchTask != null) {
                            this.switchTask.cancel();
                        }
                        this.switchTask = VTask.delay((double)clip.getMicrosecondLength() / 1000000.0);
                        this.switchTask.await(() -> {
                            this.switchTask = null;
                            if (this.running) {
                                this.next();
                            }
                        });
                    }
                }
            }
        }

        public static enum Order {
            DEFAULT,
            RANDOM;

        }
    }
}

