/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async.dispatcher;

import com.iosoft.helpers.Blocker;
import com.iosoft.helpers.IDisposable;
import com.iosoft.helpers.MutableBool;
import com.iosoft.helpers.VWaiter;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.DispatcherKeepAliveToken;
import java.util.Timer;
import java.util.TimerTask;

public abstract class SimpleDispatcher
extends Dispatcher
implements IDisposable {
    protected final Object _lock;
    private final Blocker _blockerEnded;
    private Timer _timer = new Timer();
    private boolean _ending = false;
    private boolean _ended = false;

    protected SimpleDispatcher(Object lock) {
        this._lock = lock;
        this._blockerEnded = new Blocker(this._lock);
    }

    @Override
    public IDisposable delay(double timeInSeconds, final Runnable onDone) {
        if (this._timer == null) {
            throw new IllegalStateException("already disposed");
        }
        final DispatcherKeepAliveToken keepAliveToken = this.createKeepAliveToken();
        final MutableBool active = new MutableBool(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                SimpleDispatcher.this.dispatch(() -> {
                    if (mutableBool.Value) {
                        try {
                            onDone.run();
                        }
                        finally {
                            keepAliveToken.dispose();
                        }
                    }
                });
            }
        };
        this._timer.schedule(task, (long)(timeInSeconds * 1000.0));
        return () -> {
            mutableBool.Value = false;
            task.cancel();
            keepAliveToken.dispose();
        };
    }

    public boolean hasEnded() {
        return this._ended;
    }

    public boolean isEnding() {
        return this._ending;
    }

    @Override
    public void dispose() {
        if (this._ending) {
            throw new IllegalStateException("Already ending");
        }
        this._ending = true;
        this.checkDestroy();
    }

    @Override
    public DispatcherKeepAliveToken createKeepAliveToken() {
        if (this.hasEnded()) {
            throw new IllegalStateException("Cannot create a keep alive token for a dispatcher that has already ended.");
        }
        return super.createKeepAliveToken();
    }

    @Override
    protected void unregisterKeepaliveToken() {
        super.unregisterKeepaliveToken();
        this.checkDestroy();
    }

    private void checkDestroy() {
        if (!this._ended && this._ending && this._numKeepAliveTokens == 0) {
            this.onEnding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onEnding() {
        this._ended = true;
        Object object = this._lock;
        synchronized (object) {
            if (this._timer != null) {
                this._timer.cancel();
                this._timer = null;
            }
            this._blockerEnded.fulfill();
        }
    }

    public VWaiter waitForEnded() {
        return this._blockerEnded;
    }
}

