/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async.dispatcher;

import com.iosoft.helpers.Log;
import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Mutable;
import com.iosoft.helpers.MutableBool;
import com.iosoft.helpers.Stopwatch;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.DispatcherKeepAliveToken;
import com.iosoft.helpers.async.dispatcher.WorkDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class DaemonThreadWorkDistributor
implements WorkDistributor {
    private final Dispatcher dispatcher;

    DaemonThreadWorkDistributor(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Runnable runWorker(Supplier<T> work, Consumer<T> onDone, Consumer<T> handleCancelled, String activity, float secondsUntilAsync) {
        DispatcherKeepAliveToken keepAliveToken = this.dispatcher.createKeepAliveToken();
        boolean tryEarlyResult = secondsUntilAsync > 0.0f;
        Mutable earlyResult = new Mutable();
        MutableBool earlyResultRelevant = new MutableBool(tryEarlyResult);
        MutableBool cancelled = new MutableBool(false);
        long sw_work = Stopwatch.start();
        Thread thread = Misc.startDaemonThread(activity == null ? "Async Worker" : activity, () -> {
            Object result;
            try {
                result = work.get();
            }
            catch (Exception e) {
                this.dispatcher.dispatch(() -> {
                    try {
                        this.dispatcher.handleUnhandledException(e);
                    }
                    finally {
                        keepAliveToken.dispose();
                    }
                });
                return;
            }
            if (tryEarlyResult) {
                Mutable mutable2 = earlyResult;
                synchronized (mutable2) {
                    if (mutableBool.Value) {
                        mutable.Value = result;
                        mutableBool.Value = false;
                        earlyResult.notifyAll();
                        Log.Developer.spam(String.valueOf(activity == null ? "Async work" : activity) + " finished EARLY in " + Stopwatch.getMillis(sw_work) + " ms");
                        return;
                    }
                }
            }
            this.dispatcher.dispatch(() -> {
                try {
                    if (!mutableBool.Value) {
                        Log.Developer.spam(String.valueOf(activity == null ? "Async work" : activity) + " finished in " + Stopwatch.getMillis(sw_work) + " ms");
                        onDone.accept(result);
                    } else if (handleCancelled != null) {
                        handleCancelled.accept(result);
                    }
                }
                finally {
                    keepAliveToken.dispose();
                }
            });
        });
        if (tryEarlyResult) {
            Mutable mutable = earlyResult;
            synchronized (mutable) {
                try {
                    if (earlyResultRelevant.Value) {
                        earlyResult.wait((long)(secondsUntilAsync * 1000.0f));
                    }
                    if (!earlyResultRelevant.Value) {
                        try {
                            onDone.accept(earlyResult.Value);
                        }
                        finally {
                            keepAliveToken.dispose();
                        }
                        return () -> {
                            throw new IllegalStateException("already completed");
                        };
                    }
                    earlyResultRelevant.Value = false;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return () -> {
            if (mutableBool.Value) {
                throw new IllegalStateException("already cancelled");
            }
            mutableBool.Value = true;
            thread.interrupt();
        };
    }

    @Override
    public <T, V> Runnable runWorkerWithInterimResults(Function<Consumer<V>, T> work, final Consumer<List<V>> onInterimResult, Consumer<T> onDone, String activity, float secondsUntilAsync) {
        Consumer publisher = new Consumer<V>(){
            final Object lock = new Object();
            List<V> asyncList = new ArrayList();
            boolean pushed = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(V elem) {
                Object object = this.lock;
                synchronized (object) {
                    this.asyncList.add(elem);
                    if (this.pushed) {
                        return;
                    }
                    this.pushed = true;
                }
                DaemonThreadWorkDistributor.this.dispatcher.dispatch(() -> {
                    List workingList;
                    Object object = this.lock;
                    synchronized (object) {
                        workingList = this.asyncList;
                        this.asyncList = new ArrayList();
                        this.pushed = false;
                    }
                    onInterimResult.accept(workingList);
                });
            }
        };
        return this.dispatcher.runWorker(() -> work.apply(publisher), onDone, activity, secondsUntilAsync);
    }
}

