/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public abstract class TaskBase<T> {
    protected State state;
    protected List<T> handlers;
    private final Runnable cancelHandler;

    public TaskBase(Runnable cancelHandler, Consumer<T> resultSetter) {
        this.state = State.RUNNING;
        this.handlers = new ArrayList<T>();
        this.cancelHandler = cancelHandler;
        resultSetter.accept(this.getCompleter(this::complete));
    }

    public TaskBase() {
        this.cancelHandler = null;
        this.state = State.COMPLETED;
    }

    public void await(T runWhenDone) {
        switch (this.state) {
            case COMPLETED: {
                this.call(runWhenDone);
                break;
            }
            case RUNNING: {
                this.handlers.add(runWhenDone);
            }
        }
    }

    protected abstract void call(T var1);

    public void cancel() {
        switch (this.state) {
            case COMPLETED: {
                throw new IllegalStateException("Already done");
            }
            case CANCELLED: {
                return;
            }
        }
        this.state = State.CANCELLED;
        this.handlers = null;
        if (this.cancelHandler != null) {
            this.cancelHandler.run();
        }
    }

    public void cancelIfRunning() {
        if (this.state == State.RUNNING) {
            this.cancel();
        }
    }

    public State getState() {
        return this.state;
    }

    public boolean isCompleted() {
        return this.state == State.COMPLETED;
    }

    public boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public boolean isCancelled() {
        return this.state == State.CANCELLED;
    }

    protected abstract T getCompleter(Runnable var1);

    private void complete() {
        switch (this.state) {
            case COMPLETED: {
                throw new IllegalStateException("Already done");
            }
            case RUNNING: {
                this.state = State.COMPLETED;
                for (T handler : this.handlers) {
                    this.call(handler);
                }
                this.handlers = null;
                break;
            }
            default: {
                throw new IllegalStateException("Already cancelled");
            }
        }
    }

    public static enum State {
        RUNNING,
        CANCELLED,
        COMPLETED;

    }
}

