/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.WrapException;
import com.iosoft.helpers.async.TaskBase;
import com.iosoft.helpers.async.TaskSource;
import com.iosoft.helpers.async.VTask;
import com.iosoft.helpers.async.VTaskSource;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Task<T>
extends TaskBase<Consumer<T>> {
    protected T _result;

    public Task(Runnable cancelHandler, Consumer<Consumer<T>> resultSetter) {
        super(cancelHandler, resultSetter);
    }

    public Task(T result) {
        this._result = result;
    }

    @Override
    protected Consumer<T> getCompleter(Runnable complete) {
        return x -> {
            if (this.isRunning()) {
                this._result = x;
            }
            complete.run();
        };
    }

    @Override
    protected void call(Consumer<T> runner) {
        try {
            runner.accept(this._result);
        }
        catch (ClassCastException e) {
            String objString = this._result == null ? "(null)" : (this._result instanceof Throwable ? Misc.printException((Throwable)this._result) : this._result.toString());
            throw new WrapException("Casting problem for object: " + objString, e);
        }
    }

    public T get() {
        if (!this.isCompleted()) {
            throw new IllegalStateException("Cannot get the result of a task that has not completed");
        }
        return this._result;
    }

    public static <T> Task<T> runAsync(Supplier<T> runner) {
        return Task.runHybridAsync(runner, 0.0f);
    }

    public static <T> Task<T> runHybridAsync(Supplier<T> runner, float secondsBeforeAsync) {
        TaskSource taskSource = new TaskSource();
        taskSource.CancelHandler = Dispatcher.getForCurrentThread().runWorker(runner, taskSource::setResult, null, secondsBeforeAsync);
        return (Task)taskSource.getTask();
    }

    public static <T> Task<T> delay(double seconds, T result) {
        TaskSource taskSource = new TaskSource();
        Task task = (Task)taskSource.getTask();
        taskSource.CancelHandler = Dispatcher.getForCurrentThread().delay(seconds, () -> taskSource.setResult(result))::dispose;
        return task;
    }

    public static <T> Task<T> delay(Duration duration, T result) {
        return Task.delay((float)duration.toMillis() / 1000.0f, result);
    }

    public <S> Task<S> awaitAndTranslate(Function<T, S> handler) {
        TaskSource taskSource = new TaskSource(this::cancelIfRunning);
        this.await(result -> {
            try {
                taskSource.setResult(handler.apply(result));
            }
            catch (ClassCastException e) {
                if (result instanceof Throwable) {
                    throw new WrapException((Throwable)result);
                }
                throw e;
            }
        });
        return (Task)taskSource.getTask();
    }

    public VTask awaitAndContinue(Consumer<T> handler) {
        VTaskSource taskSource = new VTaskSource(this::cancelIfRunning);
        this.await(result -> {
            vTaskSource.CancelHandler = null;
            handler.accept(result);
            taskSource.setFulfilled();
        });
        return (VTask)taskSource.getTask();
    }

    public <S> Task<S> awaitAndContinueTask(Function<T, Task<S>> handler) {
        TaskSource taskSource = new TaskSource(this::cancelIfRunning);
        this.await(result -> {
            Task task = (Task)handler.apply(result);
            taskSource.CancelHandler = task::cancelIfRunning;
            task.await(taskSource::setResult);
        });
        return (Task)taskSource.getTask();
    }

    public VTask awaitAndContinueVTask(Function<T, VTask> handler) {
        VTaskSource taskSource = new VTaskSource(this::cancelIfRunning);
        this.await(x -> {
            VTask task = (VTask)handler.apply(x);
            vTaskSource.CancelHandler = task::cancelIfRunning;
            task.await(taskSource::setFulfilled);
        });
        return (VTask)taskSource.getTask();
    }
}

