/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers.async;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.async.dispatcher.Dispatcher;
import com.iosoft.helpers.async.dispatcher.DispatcherKeepAliveToken;

public abstract class SubProcess {
    protected final Dispatcher _dispatcher = Dispatcher.getForCurrentThread();
    protected Thread _thread;
    private DispatcherKeepAliveToken _keepAliveToken;

    protected void start(Thread thread) {
        Misc.notNull(thread);
        if (this._thread != null) {
            throw new IllegalStateException("Already started");
        }
        this._keepAliveToken = this._dispatcher.createKeepAliveToken();
        this._thread = thread;
    }

    protected void start(String name, Runnable runner, boolean daemon) {
        Thread thread = new Thread(() -> {
            try {
                runner.run();
            }
            finally {
                this.onThreadEnds();
            }
        }, name);
        thread.setDaemon(daemon);
        thread.start();
        this.start(thread);
    }

    protected void start(String name, Runnable runner) {
        this.start(name, runner, true);
    }

    protected void onThreadEnds() {
        this._dispatcher.dispatch(() -> this._keepAliveToken.dispose());
    }

    public boolean ensureHasEnded() {
        if (this.isRunning()) {
            this.end();
            return true;
        }
        return false;
    }

    public void end() {
        if (this._thread == null) {
            throw new IllegalStateException("Already ended");
        }
        this._thread.interrupt();
        this.onEnd();
    }

    protected void onEnd() {
        this._thread = null;
    }

    protected void post(Runnable runner) {
        this._dispatcher.dispatch(this.wrap(runner));
    }

    protected boolean isRunning() {
        return this._thread != null;
    }

    protected Runnable wrap(Runnable runner) {
        return () -> {
            if (this.isRunning()) {
                runner.run();
            }
        };
    }
}

