/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.ThrowingRunnable;
import com.iosoft.helpers.ThrowingSupplier;

public class WrapException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public WrapException(String message, Throwable e) {
        super(Misc.notNull(message, "message"), Misc.notNull(e, "cause"));
    }

    public WrapException(Throwable e) {
        super(Misc.notNull(e, "cause"));
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public static void throwIfNotNull(Throwable exception, String message) {
        if (exception != null) {
            throw new WrapException(message, exception);
        }
    }

    public static void throwIfNotNull(Throwable exception) {
        if (exception != null) {
            throw new WrapException(exception);
        }
    }

    public static <E extends Exception, R> R enforce(ThrowingSupplier<R, E> runner) {
        try {
            return runner.get();
        }
        catch (Exception ex) {
            throw new WrapException(ex);
        }
    }

    public static <E extends Throwable> void enforce(ThrowingRunnable<E> runner) {
        try {
            runner.run();
        }
        catch (Throwable ex) {
            throw new WrapException(ex);
        }
    }

    public <A extends Throwable> A unwrap(Class<A> a) throws A {
        Throwable cause = this.getCause();
        if (a.isInstance(cause)) {
            throw cause;
        }
        throw this;
    }

    public <A extends Throwable> void tryUnwrap(Class<A> a) throws A {
        Throwable cause = this.getCause();
        if (a.isInstance(cause)) {
            throw cause;
        }
    }
}

