/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers;

import com.iosoft.helpers.Waiter;
import com.iosoft.helpers.WrapException;
import java.util.function.Supplier;

public interface VWaiter {
    public void waitBlockingInterruptible() throws InterruptedException;

    default public void waitBlocking() {
        if (this.waitBlockingWasInterrupted()) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean waitBlockingWasInterrupted();

    default public void waitBlockingCrashOnInterrupt() {
        try {
            this.waitBlockingInterruptible();
        }
        catch (InterruptedException e) {
            throw new WrapException("Thread was illegally interrupted", e);
        }
    }

    default public boolean waitBlockingReturnOnInterrupt() {
        try {
            this.waitBlockingInterruptible();
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    default public <T> Waiter<T> withResult(final Supplier<T> resultGetter) {
        return new Waiter<T>(){

            @Override
            public T waitBlockingInterruptible() throws InterruptedException {
                VWaiter.this.waitBlockingInterruptible();
                return resultGetter.get();
            }

            @Override
            public T waitBlocking() {
                VWaiter.this.waitBlocking();
                return resultGetter.get();
            }
        };
    }
}

