/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.ThrowingSupplier;
import com.iosoft.helpers.iter.SkippingListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class MiscLINQ {
    private MiscLINQ() {
    }

    public static <T> T firstOrDefault(Iterable<T> collection) {
        return (T)MiscLINQ.firstOrDefault(collection, (T x) -> true);
    }

    public static <T> T firstOrDefault(Iterable<T> collection, Predicate<T> predicate) {
        for (T item : collection) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> T firstOrDefault(Iterator<T> collection, Predicate<T> predicate) {
        while (collection.hasNext()) {
            T item = collection.next();
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> T firstOrDefault(T[] collection, Predicate<T> predicate) {
        T[] TArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (predicate.test(item)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static <T> T firstOrDefault(Enumeration<T> collection, Predicate<T> predicate) {
        while (collection.hasMoreElements()) {
            T item = collection.nextElement();
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> T firstOrDefault(IntSupplier getSize, Function<Integer, T> getElement, Predicate<T> predicate) {
        int size = getSize.getAsInt();
        int i = 0;
        while (i < size) {
            T item = getElement.apply(i);
            if (predicate.test(item)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public static <T> T first(Iterable<T> collection, Predicate<T> predicate) {
        for (T item : collection) {
            if (!predicate.test(item)) continue;
            return item;
        }
        throw new NoSuchElementException();
    }

    public static <T> T first(Iterable<T> collection) {
        Iterator<T> iterator = collection.iterator();
        if (iterator.hasNext()) {
            T item = iterator.next();
            return item;
        }
        throw new NoSuchElementException();
    }

    public static <T> T first(T[] array, Predicate<T> predicate) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (predicate.test(item)) {
                return item;
            }
            ++n2;
        }
        throw new NoSuchElementException();
    }

    public static <T> T removeFirst(Iterable<T> collection) {
        Iterator<T> iter = collection.iterator();
        if (!iter.hasNext()) {
            throw new NoSuchElementException();
        }
        T item = iter.next();
        iter.remove();
        return item;
    }

    public static <T> T last(Iterable<T> collection) {
        T item;
        Iterator<T> iter = collection.iterator();
        if (!iter.hasNext()) {
            throw new NoSuchElementException();
        }
        do {
            item = iter.next();
        } while (iter.hasNext());
        return item;
    }

    public static <T> T lastOrDefault(Iterable<T> collection) {
        T previousItem = null;
        for (T item : collection) {
            previousItem = item;
        }
        return previousItem;
    }

    public static <T> boolean any(Iterable<T> collection, Predicate<T> predicate) {
        for (T item : collection) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean any(Iterable<T> collection) {
        return collection.iterator().hasNext();
    }

    public static <T> boolean any(T[] collection, Predicate<T> predicate) {
        T[] TArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (predicate.test(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean all(Iterable<T> collection, Predicate<T> predicate) {
        return !MiscLINQ.any(collection, predicate.negate());
    }

    public static <T> T tryGetAndRemove(Iterable<T> collection, Predicate<T> predicate) {
        Iterator<T> iter = collection.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!predicate.test(item)) continue;
            iter.remove();
            return item;
        }
        return null;
    }

    public static <T> ArrayList<T> toList(Iterator<T> iterator) {
        ArrayList target = new ArrayList();
        iterator.forEachRemaining(target::add);
        return target;
    }

    public static <T> ArrayList<T> toList(Iterable<T> iterable) {
        ArrayList target = new ArrayList();
        iterable.forEach(target::add);
        return target;
    }

    public static <T> HashSet<T> toSet(T[] array) {
        return new HashSet<T>(Arrays.asList(array));
    }

    public static <K, V> Map<K, V> toMap(Collection<V> streamable, Function<V, K> mapper) {
        return MiscLINQ.toMap(streamable.stream(), mapper);
    }

    public static <K, V> Map<K, V> toMap(Stream<V> stream, Function<V, K> mapper) {
        return stream.collect(Collectors.toMap(mapper, Function.identity()));
    }

    public static <T> Iterable<T> iter(Stream<T> stream) {
        return () -> stream.iterator();
    }

    public static <T> Iterable<T> toIterable(T[] array) {
        return SkippingListIterator.createIterable(array, x -> true);
    }

    public static <T> Iterable<T> toIterable(Supplier<Enumeration<T>> enumeration) {
        return () -> MiscLINQ.toIterator((Enumeration)enumeration.get());
    }

    public static <T> Iterable<T> toIterable(Enumeration<T> enumeration) {
        return () -> MiscLINQ.toIterator(enumeration);
    }

    public static <T> Iterable<T> toIterable(IntSupplier getSize, final Function<Integer, T> getElement) {
        return () -> new Iterator<T>(getSize){
            int size;
            int i;
            {
                this.size = intSupplier.getAsInt();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.size;
            }

            @Override
            public T next() {
                return getElement.apply(this.i++);
            }
        };
    }

    public static <T> Iterator<T> toIterator(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> Iterator<T> toIterator(final T[] enumeration) {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return enumeration.length > this.i;
            }

            @Override
            public T next() {
                return enumeration[this.i++];
            }
        };
    }

    public static <T> Stream<T> stream(Iterable<T> iter) {
        return StreamSupport.stream(iter.spliterator(), false);
    }

    public static <T> Stream<T> stream(Enumeration<T> enumeration) {
        return MiscLINQ.stream(MiscLINQ.toIterable(enumeration));
    }

    public static <T> Iterable<T> filter(T[] array, Predicate<T> predicate) {
        return SkippingListIterator.createIterable(array, predicate);
    }

    public static <T> void removeAll(Iterable<T> iterable) {
        MiscLINQ.removeAll(iterable.iterator());
    }

    public static <T> void removeAll(Iterator<T> iterator) {
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public static <T> int indexOf(ArrayList<T> items, Predicate<T> predicate) {
        int iC = items.size();
        int i = 0;
        while (i < iC) {
            if (predicate.test(items.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] items, T searchedItem) {
        int iC = items.length;
        int i = 0;
        while (i < iC) {
            if (Objects.equals(items[i], searchedItem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] items, Predicate<T> predicate) {
        int iC = items.length;
        int i = 0;
        while (i < iC) {
            if (predicate.test(items[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int indexOfRef(T[] items, T searchedItem) {
        int iC = items.length;
        int i = 0;
        while (i < iC) {
            if (items[i] == searchedItem) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int count(Iterable<?> items) {
        int i = 0;
        Iterator<?> iter = items.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++i;
        }
        return i;
    }

    public static boolean isEmpty(Iterable<?> items) {
        return !items.iterator().hasNext();
    }

    public static boolean isEmpty(Stream<?> items) {
        return !items.iterator().hasNext();
    }

    public static <T> T getNext(Iterable<T> items, T current) {
        T firstItem = null;
        for (T item : items) {
            if (current == null) {
                return item;
            }
            if (firstItem == null) {
                firstItem = item;
            }
            if (current != item) continue;
            current = null;
        }
        return firstItem;
    }

    public static <T> T getNext(T[] items, T current) {
        T firstItem = null;
        T[] TArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (current == null) {
                return item;
            }
            if (firstItem == null) {
                firstItem = item;
            }
            if (current == item) {
                current = null;
            }
            ++n2;
        }
        return firstItem;
    }

    public static <T> T getPrevious(Iterable<T> items, T current) {
        T lastItem = null;
        for (T item : items) {
            if (current == item && lastItem != null) {
                return lastItem;
            }
            lastItem = item;
        }
        return lastItem;
    }

    public static <T> T getPrevious(T[] items, T current) {
        T lastItem = null;
        T[] TArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            T item = TArray[n2];
            if (current == item && lastItem != null) {
                return lastItem;
            }
            lastItem = item;
            ++n2;
        }
        return lastItem;
    }

    public static <T> void create(T[] array, Supplier<T> creator) {
        int i = 0;
        while (i < array.length) {
            array[i] = creator.get();
            ++i;
        }
    }

    public static <T, E extends Throwable> List<T> create(int num, ThrowingSupplier<T, E> creator) throws E {
        ArrayList<T> list = new ArrayList<T>(num);
        int i = 0;
        while (i < num) {
            list.add(creator.get());
            ++i;
        }
        return list;
    }

    public static <T, E extends Throwable> T[] create(Class<T> clazz, int num, ThrowingSupplier<T, E> creator) throws E {
        List<T> list = MiscLINQ.create(num, creator);
        return list.toArray(Misc.createArray(clazz, num));
    }

    public static <T, S> T[] convert(Class<T> clazz, S[] data, Function<S, T> mapper) {
        return MiscLINQ.convert(data, Misc.createArray(clazz, data.length), mapper);
    }

    public static <T, S> T[] convert(S[] data, T[] result, Function<S, T> mapper) {
        int i = 0;
        while (i < data.length) {
            result[i] = mapper.apply(data[i]);
            ++i;
        }
        return result;
    }

    public static <T> Collector<T, ?, Integer> counting() {
        return Collectors.reducing(0, e -> 1, Integer::sum);
    }

    public static <T> Map<T, Integer> bucket(Stream<T> stream) {
        return stream.collect(Collectors.groupingBy(Function.identity(), MiscLINQ.counting()));
    }
}

