/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.Queuer;
import com.iosoft.helpers.Stopwatch;
import java.util.function.Consumer;

public final class Log {
    public static final long SwStart = Stopwatch.start();
    public static final Category App = new Category("App");
    public static final Category General = new Category("General");
    public static final Category Client = new Category("Client");
    public static final Category Server = new Category("Server");
    public static final Category UI = new Category("UI");
    public static final Category Developer = new Category("Developer");
    public static final int FLAG_SPAM = 1;
    public static final int FLAG_USELESSINFO = 2;
    public static volatile Consumer<Message> Handler = Log::consoleLog;

    private Log() {
    }

    public static void print(String message, Category category, Severity severity) {
        Log.print(new Message(Stopwatch.start(), message, category, severity, 0, Misc.EMPTYOBJS));
    }

    public static void print(String message, Category category, Severity severity, int flags) {
        Log.print(new Message(Stopwatch.start(), message, category, severity, flags, Misc.EMPTYOBJS));
    }

    public static void print(String message, Category category, Severity severity, int flags, Object ... data) {
        Log.print(new Message(Stopwatch.start(), message, category, severity, flags, data));
    }

    public static void print(Message message) {
        Misc.notNull(message);
        Consumer<Message> listener = Handler;
        if (listener != null) {
            listener.accept(message);
        }
    }

    public static void consoleLog(Message message) {
        System.out.println(String.valueOf(Stopwatch.getSeconds(SwStart, message.SwTimestamp)) + "\t" + (Object)((Object)message.Severity) + "\t" + message.Category.Name + "\t" + message.Text);
    }

    public static LogQueuer createAndSetQueuer(Consumer<Message> meanwhileHandler) {
        return new LogQueuer((Consumer)meanwhileHandler);
    }

    public static class Category {
        public final String Name;

        public Category(String name) {
            this.Name = name;
        }

        public void print(String text, Severity severity) {
            Log.print(text, this, severity);
        }

        public void error(String text) {
            this.print(text, Severity.Error);
        }

        public void errorShort(Throwable ex) {
            this.error(Misc.printExceptionShort(ex));
        }

        public void errorShort(String prefix, Throwable ex) {
            this.error(String.valueOf(prefix) + ": " + Misc.printExceptionShort(ex));
        }

        public void errorFull(Throwable ex) {
            this.error(Misc.printException(ex));
        }

        public void errorFull(String prefix, Throwable ex) {
            this.error(String.valueOf(prefix) + ": " + Misc.printException(ex));
        }

        public void fatal(String text) {
            this.print(text, Severity.Fatal);
        }

        public void fatalFull(String prefix, Throwable ex) {
            this.print(String.valueOf(prefix) + ": " + Misc.printException(ex), Severity.Fatal);
        }

        public void warning(String text) {
            this.print(text, Severity.Warning);
        }

        public void info(String text) {
            this.print(text, Severity.Info);
        }

        public void spam(String text) {
            this.print(text, Severity.Spam);
        }
    }

    public static final class LogQueuer
    extends Queuer<Message> {
        private LogQueuer(Consumer<Message> actualHandler) {
            super(actualHandler, (Consumer<T> x) -> {
                Consumer consumer = Handler = x;
            });
        }
    }

    public static class Message {
        public final long SwTimestamp;
        public final String Text;
        public final Category Category;
        public final Severity Severity;
        public final int Flags;
        public final Object[] Data;

        public Message(long swTimestamp, String text, Category category, Severity severity, int flags, Object[] data) {
            this.SwTimestamp = swTimestamp;
            this.Text = text;
            this.Category = category;
            this.Severity = severity;
            this.Flags = flags;
            this.Data = data;
        }
    }

    public static enum Severity {
        Spam(false, false),
        Info(true, false),
        Warning(true, false),
        Error(true, true),
        Fatal(true, true);

        public final boolean IsImportant;
        public final boolean IsError;

        private Severity(boolean isImportant, boolean isError) {
            this.IsImportant = isImportant;
            this.IsError = isError;
        }
    }
}

