/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers;

import com.iosoft.helpers.Misc;

public final class HtmlEscape {
    private HtmlEscape() {
    }

    public static String stripAllTagsAndResolveEntities(String input) {
        return input.replaceAll("\\<.*?>", "").replace("&lt;", "<").replace("&gt;", ">").replace("&#39;", "'").replace("&#44;", ",").replace("&quot;", "\"");
    }

    public static String sanitizeForLabel(String input) {
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("/", "&#x2F;");
    }

    public static String escapeEverything(String input) {
        StringBuilder sb = new StringBuilder();
        HtmlEscape.escapeEverything(sb, input);
        return sb.toString();
    }

    public static void escapeEverything(StringBuilder sb, String input) {
        for (int c : Misc.iterCodePoints(input)) {
            if (c == 10) {
                sb.append("<br>");
                continue;
            }
            sb.append("&#");
            sb.append(c);
            sb.append(';');
        }
    }
}

