/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.helpers;

import com.iosoft.helpers.Misc;
import com.iosoft.helpers.ThrowingConsumer;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DebugInputStream
extends FilterInputStream {
    private ThrowingConsumer<byte[], IOException> consumer;
    private Thread myThread = Thread.currentThread();

    public DebugInputStream(InputStream in, ThrowingConsumer<byte[], IOException> consumer) {
        super(in);
        this.consumer = Misc.notNull(consumer);
    }

    @Override
    public int read() throws IOException {
        if (Thread.currentThread() != this.myThread) {
            throw new IllegalStateException("Called from the wrong thread");
        }
        int val = this.in.read();
        if (val != -1) {
            this.consumer.accept(new byte[]{(byte)val});
        }
        return val;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (Thread.currentThread() != this.myThread) {
            throw new IllegalStateException("Called from the wrong thread");
        }
        int val = super.read(b, off, len);
        if (val > 0) {
            byte[] buffer = new byte[val];
            System.arraycopy(b, off, buffer, 0, val);
            this.consumer.accept(buffer);
        }
        return val;
    }
}

