/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.ui;

import com.iosoftware.helpers.Misc;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class Picture
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Image img;
    private boolean ownImage;
    private boolean scaled;
    private int width;
    private int height;
    private ActionListener al;

    private final Picture getPicture() {
        return this;
    }

    private Picture() {
        this.setOpaque(false);
        this.ownImage = false;
        this.scaled = true;
        MouseListener ml = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Picture.this.al != null && e.getButton() == 1) {
                    Picture.this.al.actionPerformed(new ActionEvent(Picture.this.getPicture(), 1001, "clicked"));
                }
            }
        };
        this.addMouseListener(ml);
        this.setLayout(null);
    }

    public Picture(int x, int y, int width, int height) {
        this(x, y, width, height, (Image)null);
    }

    public Picture(int x, int y, int width, int height, Image img) {
        this();
        this.img = img;
        this.width = width;
        this.height = height;
        this.setBounds(x, y, width, height);
        this.repaint();
    }

    public Picture(int x, int y, int scale, Image img) {
        this();
        if (img != null) {
            this.width = img.getWidth(null) * scale;
            this.height = img.getHeight(null) * scale;
            this.img = img;
            this.setBounds(x, y, this.width, this.height);
            this.repaint();
        }
    }

    public Picture(int x, int y, Image img) {
        this();
        if (img != null) {
            this.width = img.getWidth(null);
            this.height = img.getHeight(null);
            this.scaled = false;
            this.img = img;
            this.setBounds(x, y, this.width, this.height);
            this.repaint();
        }
    }

    public Picture(int x, int y, int width, int height, String path) {
        this();
        this.ownImage = true;
        BufferedImage img = Misc.loadImage(path);
        if (img != null) {
            this.img = img;
            this.width = width;
            this.height = height;
            this.setBounds(x, y, width, height);
            this.repaint();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.ownImage) {
            this.img.flush();
        }
    }

    public void setImage(Image img) {
        this.img = img;
    }

    public void setActionListener(ActionListener al) {
        this.al = al;
        this.setCursor(new Cursor(12));
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.img != null) {
            if (this.scaled) {
                g.drawImage(this.img, 0, 0, this.width, this.height, null);
            } else {
                g.drawImage(this.img, 0, 0, null);
            }
        }
    }
}

