/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.ui;

import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.ui.GameButton;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GameSpinner
extends JPanel {
    private GameSpinner spinner;
    private static final long serialVersionUID = 1L;
    private GameButton buttonLeft;
    private GameButton buttonRight;
    private JLabel label;
    private String name;
    private int choice;
    private String[] choices;
    private boolean enabled = true;
    private boolean inited = true;
    private java.awt.event.ActionListener[] als;

    public GameSpinner(int x, int y, int width, int height, String[] choices, String name) {
        this(x, y, width, height, choices, name, null, 0);
    }

    public GameSpinner(int x, int y, int width, int height, String[] choices, String name, Font font, int choice) {
        this.setLayout(null);
        this.als = new java.awt.event.ActionListener[0];
        this.setIDName(name);
        this.spinner = this;
        this.choices = choices;
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setBounds(x, y, width, height);
        if (width > height * 2 && choices.length > 0) {
            ActionListener al = new ActionListener();
            this.setBackground(Color.WHITE);
            this.buttonLeft = new GameButton(0, 0, height, height, "<", "");
            this.buttonLeft.addActionListener(al);
            this.add(this.buttonLeft);
            this.buttonRight = new GameButton(width - height, 0, height, height, ">", "");
            this.buttonRight.addActionListener(al);
            this.add(this.buttonRight);
            this.label = new JLabel(choices[0]){
                private static final long serialVersionUID = 1L;

                @Override
                public void paintComponent(Graphics gFake) {
                    Graphics2D g = (Graphics2D)gFake;
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    super.paintComponent(g);
                }
            };
            this.label.setHorizontalAlignment(0);
            this.label.setBounds(height, 0, width - height * 2, height);
            this.add(this.label);
            if (font != null) {
                this.setFont(font);
            }
        } else {
            this.setBackground(new Color(0, 255, 255));
        }
        this.setChoice(choice);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.inited) {
            this.checkButtons();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public int getChoice() {
        return this.choice;
    }

    public void alterChoices(String[] newChoices, int newChoice) {
        if (newChoices == null || newChoices.length == 0) {
            newChoices = new String[]{"undefined"};
        }
        if (newChoice < 0) {
            newChoice = 0;
        } else if (newChoice >= newChoices.length) {
            newChoice = newChoices.length - 1;
        }
        this.choices = newChoices;
        this.choice = newChoice;
        this.checkButtons();
    }

    public void setChoice(int choice) {
        if (choice < 0) {
            choice = 0;
        }
        if (choice >= this.choices.length) {
            choice = this.choices.length - 1;
        }
        this.choice = choice;
        this.checkButtons();
    }

    public void setIDName(String name) {
        this.name = name;
    }

    public String getIDName() {
        return this.name;
    }

    public void doClick(boolean button) {
        int iC = this.als.length;
        int i = 0;
        while (i < iC) {
            this.als[i].actionPerformed(new ActionEvent(this, 1001, button ? "buttonLeft" : "buttonRight"));
            ++i;
        }
    }

    public void addActionListener(java.awt.event.ActionListener al) {
        int iC = this.als.length;
        java.awt.event.ActionListener[] temp = new java.awt.event.ActionListener[iC + 1];
        int i = 0;
        while (i < iC) {
            temp[i] = this.als[i];
            ++i;
        }
        temp[iC] = al;
        this.als = temp;
    }

    private void checkButtons() {
        this.buttonLeft.setEnabled(this.enabled);
        this.buttonRight.setEnabled(this.enabled);
        this.label.setEnabled(this.enabled);
        if (this.enabled) {
            if (this.choice == 0) {
                this.buttonLeft.setEnabled(false);
            } else {
                this.buttonLeft.setEnabled(true);
            }
            if (this.choice == this.choices.length - 1) {
                this.buttonRight.setEnabled(false);
            } else {
                this.buttonRight.setEnabled(true);
            }
        }
        this.label.setText(this.choices[this.choice]);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.inited) {
            this.buttonLeft.setFont(font);
            this.buttonRight.setFont(font);
            this.label.setFont(font);
        }
    }

    private class ActionListener
    implements java.awt.event.ActionListener {
        private ActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GameButton source = (GameButton)e.getSource();
            if (source == GameSpinner.this.buttonLeft) {
                if (GameSpinner.this.choice > 0) {
                    GameSpinner gameSpinner = GameSpinner.this;
                    gameSpinner.choice = gameSpinner.choice - 1;
                }
                GameSpinner.this.doClick(false);
            } else if (source == GameSpinner.this.buttonRight) {
                if (GameSpinner.this.choice < GameSpinner.this.choices.length - 1) {
                    GameSpinner gameSpinner = GameSpinner.this;
                    gameSpinner.choice = gameSpinner.choice + 1;
                }
                GameSpinner.this.doClick(true);
            }
            GameSpinner.this.checkButtons();
            java.awt.event.ActionListener actionListener = Misc.getActionListener();
            if (actionListener != null) {
                actionListener.actionPerformed(new ActionEvent(GameSpinner.this.spinner, 1001, "click4"));
            }
        }
    }
}

