/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.ui;

import com.iosoftware.helpers.Misc;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GameButton
extends JPanel {
    private static final long serialVersionUID = 1L;
    private boolean isInButton;
    private boolean isClicked;
    private boolean enabled;
    private String name;
    private JLabel label;
    private ActionListener[] als;
    protected Image img;
    private int imgX;
    private int imgY;
    private int imgW;
    private int imgH;
    private static final Font fontButton = new Font("Verdana", 0, 20);
    private static final Color DISABLEDBACKGROUND = new Color(70, 70, 70);
    private static final Color NEWBACKGROUND = new Color(100, 100, 100);
    private static final Color DISABLED = new Color(100, 100, 100);
    protected Color colorBG;
    protected Color colorBGDisabled;
    protected Color colorBGDown;
    protected Color colorText;
    protected Color colorTextDisabled;
    protected Color colorTextDown;
    protected Color colorImageDisabled;
    protected Border borderUp;
    protected Border borderDown;

    public GameButton(int x, int y, int width, int height, String text, String name) {
        this(x, y, width, height, text, null, name, fontButton, null);
    }

    public GameButton(int x, int y, int width, int height, String text, String name, Font font) {
        this(x, y, width, height, text, null, name, font, null);
    }

    public GameButton(int x, int y, int width, int height, Image img, String name, Font font, ActionListener al) {
        this(x, y, width, height, "", img, name, font, al);
    }

    public GameButton(int x, int y, int width, int height, String text, String name, Font font, ActionListener al) {
        this(x, y, width, height, text, null, name, font, al);
    }

    public GameButton(int x, int y, int width, int height, String text, Image img, String name, Font font, ActionListener al) {
        this.img = img;
        this.borderUp = BorderFactory.createRaisedBevelBorder();
        this.borderDown = BorderFactory.createLoweredBevelBorder();
        this.colorBG = Color.LIGHT_GRAY;
        this.colorBGDisabled = DISABLEDBACKGROUND;
        this.colorBGDown = NEWBACKGROUND;
        this.colorText = Color.BLACK;
        this.colorTextDisabled = DISABLED;
        this.colorTextDown = Color.BLACK;
        this.makeImageBG();
        this.setFont(font);
        this.setIDName(name);
        this.enabled = true;
        this.setBounds(x, y, width, height);
        this.setLayout(null);
        this.als = new ActionListener[0];
        this.label = new JLabel(text){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics gFake) {
                Graphics2D g = (Graphics2D)gFake;
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(g);
            }
        };
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        this.label.setFont(font);
        this.label.setForeground(Color.BLACK);
        this.label.setBounds(0, 0, width, height);
        if (img != null) {
            this.label.setVisible(false);
            this.imgW = img.getWidth(null);
            this.imgH = img.getHeight(null);
            this.imgX = (width - this.imgW) / 2;
            this.imgY = (height - this.imgH) / 2;
        }
        this.add(this.label);
        MouseListener ml = new MouseListener();
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        ActionListener actionListener = Misc.getActionListener();
        if (actionListener != null) {
            this.addActionListener(actionListener);
        }
        this.setState();
        if (al != null) {
            this.addActionListener(al);
        }
    }

    @Override
    protected void paintComponent(Graphics gFake) {
        Graphics2D g = (Graphics2D)gFake;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
        if (this.img != null) {
            g.drawImage(this.img, this.imgX, this.imgY, null);
            if (!this.enabled) {
                g.setColor(this.colorImageDisabled);
                g.fillRect(this.imgX, this.imgY, this.imgW, this.imgH);
            }
        }
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setState();
    }

    public void setIDName(String name) {
        this.name = name;
    }

    public String getIDName() {
        return this.name;
    }

    public void addActionListener(ActionListener al) {
        int iC = this.als.length;
        ActionListener[] temp = new ActionListener[iC + 1];
        int i = 0;
        while (i < iC) {
            temp[i] = this.als[i];
            ++i;
        }
        temp[iC] = al;
        this.als = temp;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.isInButton = false;
        this.isClicked = false;
        this.setState();
    }

    public void removeActionListener(ActionListener al) {
        ActionListener[] temp = this.als;
        this.als = new ActionListener[0];
        int iC = temp.length;
        int i = 0;
        while (i < iC) {
            if (temp[i] != al) {
                this.addActionListener(temp[i]);
            }
            ++i;
        }
    }

    public void setState() {
        if (this.enabled) {
            if (this.isClicked && this.isInButton) {
                this.label.setForeground(this.colorTextDown);
                this.setBorder(this.borderDown);
                this.setBackground(this.colorBGDown);
            } else {
                this.label.setForeground(this.colorText);
                this.setBorder(this.borderUp);
                this.setBackground(this.colorBG);
            }
        } else {
            this.label.setForeground(this.colorTextDisabled);
            this.setBorder(this.borderUp);
            this.setBackground(this.colorBGDisabled);
        }
    }

    protected void makeImageBG() {
        this.colorImageDisabled = new Color(this.colorTextDisabled.getRed(), this.colorTextDisabled.getGreen(), this.colorTextDisabled.getBlue(), 100);
    }

    public void doClick() {
        int iC = this.als.length;
        int i = 0;
        while (i < iC) {
            this.als[i].actionPerformed(new ActionEvent(this, 1001, "click2"));
            ++i;
        }
    }

    protected void doTLA() {
        Container tla = this.getTopLevelAncestor();
        if (tla != null) {
            tla.repaint();
        }
    }

    private boolean isInside(Point p) {
        return p.x >= 0 && p.y >= 0 && p.x < this.getWidth() && p.y < this.getHeight();
    }

    private class MouseListener
    implements java.awt.event.MouseListener,
    MouseMotionListener {
        @Override
        public void mousePressed(MouseEvent e) {
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            if (e.getButton() == 1) {
                GameButton.this.isClicked = true;
            }
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            if (e.getButton() == 1) {
                if (GameButton.this.isClicked && GameButton.this.isInButton && GameButton.this.enabled) {
                    GameButton.this.doClick();
                }
                GameButton.this.isClicked = false;
            }
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            GameButton.this.isClicked = true;
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            GameButton.this.setState();
            GameButton.this.doTLA();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            GameButton.this.isClicked = false;
            GameButton.this.isInButton = GameButton.this.isInside(e.getPoint());
            GameButton.this.setState();
            GameButton.this.doTLA();
        }
    }
}

