/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.network;

import com.iosoftware.helpers.network.LocalConnection;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class Connection {
    private static int counter = 0;
    private int number;
    private Socket socket;
    private LocalConnection local;
    private OutputStream out;
    private InputStream in;
    private boolean connected;
    private boolean onDisconnectCalled;
    private boolean started;
    private boolean buffered;
    private List<byte[]> buffer;
    private String prefix;
    private Object lock = new Object();

    public Connection() {
        if (counter == Integer.MAX_VALUE) {
            counter = Integer.MIN_VALUE;
        }
        this.number = counter++;
        this.buffered = false;
        this.connected = true;
        this.buffer = new ArrayList<byte[]>();
        this.onDisconnectCalled = false;
        this.started = false;
        this.prefix = "";
        this.local = null;
        this.socket = null;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setBuffered(boolean buffered) {
        this.buffered = buffered;
    }

    public boolean getBuffered() {
        return this.buffered;
    }

    public void bind(Socket socket) {
        if (this.started) {
            return;
        }
        this.socket = socket;
        this.init();
    }

    public void bind(LocalConnection local) {
        if (this.started) {
            return;
        }
        this.local = local;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            this.started = true;
            this.buffer.clear();
            if (this.local != null) {
                this.out = this.local.getOutputStream();
                this.in = this.local.getInputStream();
            } else {
                try {
                    this.out = this.socket.getOutputStream();
                    this.in = this.socket.getInputStream();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.buffered) {
                this.in = new BufferedInputStream(this.in);
                this.out = new BufferedOutputStream(this.out);
            }
            new Sender();
            new Receiver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.lock;
        synchronized (object) {
            return this.connected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] data) {
        Object object = this.lock;
        synchronized (object) {
            this.buffer.add(data);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal() {
        Object object = this.lock;
        synchronized (object) {
            return this.local != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.disconnecting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnecting() {
        Object object = this.lock;
        synchronized (object) {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lock.notifyAll();
            this.connected = false;
            if (!this.onDisconnectCalled) {
                this.onDisconnectCalled = true;
                this.onDisconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.lock;
        synchronized (object) {
            return this.isLocal() || !this.started ? -1 : this.socket.getPort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getInetAddress() {
        Object object = this.lock;
        synchronized (object) {
            return this.isLocal() || !this.started ? null : this.socket.getInetAddress();
        }
    }

    protected void onDisconnected() {
    }

    protected void receiving(InputStream in) throws Exception {
        this.loopAndDispose(in);
    }

    protected void loopAndDispose(InputStream in) throws Exception {
        while (in.read() != -1) {
        }
    }

    private class Receiver
    extends Thread {
        private Receiver() {
            this.setName(String.valueOf(Connection.this.prefix) + "Receiver (#" + Connection.this.number + ")");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Connection.this.receiving(Connection.this.in);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = Connection.this.lock;
            synchronized (object) {
                Connection.this.disconnecting();
            }
        }
    }

    private class Sender
    extends Thread {
        private List<byte[]> bufferI;

        private Sender() {
            this.setName(String.valueOf(Connection.this.prefix) + "Sender (#" + Connection.this.number + ")");
            this.bufferI = new ArrayList<byte[]>();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            try {
                while (true) {
                    object = Connection.this.lock;
                    synchronized (object) {
                        if (!Connection.this.isConnected()) {
                            break;
                        }
                        if (Connection.this.buffer.size() == 0) {
                            Connection.this.lock.wait();
                        }
                        if (!Connection.this.isConnected()) {
                            break;
                        }
                        this.bufferI.addAll(Connection.this.buffer);
                        Connection.this.buffer.clear();
                    }
                    int iC = this.bufferI.size();
                    int i = 0;
                    while (i < iC) {
                        Connection.this.out.write(this.bufferI.get(i));
                        ++i;
                    }
                    Connection.this.out.flush();
                    this.bufferI.clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = Connection.this.lock;
            synchronized (object) {
                Connection.this.disconnecting();
            }
        }
    }
}

