/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.network;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

public class Connecter {
    public static final int STATE_NOT_CONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_ERROR = 3;
    public static final int STATE_FAILED = 4;
    public static final int STATE_CANCELED = 5;
    private String ip;
    private int port;
    private Runnable runner;
    private int state;
    private Socket socket;
    private boolean abandon;
    private boolean done;
    private Object lock = new Object();

    public Connecter(String ip, int port, boolean nodelay, Runnable runner) {
        this.ip = ip;
        this.port = port;
        this.runner = runner;
        this.abandon = false;
        this.done = false;
        this.state = 0;
        this.socket = new Socket();
        try {
            this.socket.setTcpNoDelay(nodelay);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.lock;
        synchronized (object) {
            new ConnectingThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.lock;
        synchronized (object) {
            this.abandon = true;
            if (!this.done) {
                this.state = 5;
                this.done = true;
                if (this.runner != null) {
                    this.runner.run();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.lock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket() {
        Object object = this.lock;
        synchronized (object) {
            return this.socket;
        }
    }

    private class ConnectingThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConnectingThread() {
            Object object = Connecter.this.lock;
            synchronized (object) {
                this.setName("Connecter");
                this.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = Connecter.this.lock;
            synchronized (object) {
                Connecter.this.state = 1;
            }
            int next = 1;
            try {
                Connecter.this.socket = new Socket(Connecter.this.ip, Connecter.this.port);
                next = 2;
            }
            catch (IllegalArgumentException ex) {
                next = 3;
            }
            catch (IOException ex) {
                next = 4;
            }
            Object object2 = Connecter.this.lock;
            synchronized (object2) {
                if (Connecter.this.abandon) {
                    try {
                        Connecter.this.socket.close();
                    }
                    catch (Exception exception) {}
                } else {
                    Connecter.this.state = next;
                    Connecter.this.done = true;
                    if (Connecter.this.runner != null) {
                        Connecter.this.runner.run();
                    }
                }
            }
        }
    }
}

