/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.audio;

import com.iosoftware.helpers.Misc;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;

public class SoundManager {
    private static SoundManager inst;
    private Sound[] sounds;

    private SoundManager() {
        inst = this;
        this.sounds = new Sound[0];
        new Closer();
    }

    private static SoundManager get() {
        if (inst == null) {
            inst = new SoundManager();
        }
        return inst;
    }

    public static Sound load(String path) {
        return SoundManager.load(Misc.getFileAsInputStream(path));
    }

    public static Sound load(InputStream in) {
        return SoundManager.get().loadIntern(in);
    }

    public static Loop createLoop(Sound sound) {
        return new Loop(sound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sound loadIntern(InputStream in) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataInputStream dis = new DataInputStream(in);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = dis.read(buffer)) >= 0) {
                baos.write(buffer, 0, read);
            }
            dis.close();
            byte[] audio = baos.toByteArray();
            Sound sound = new Sound();
            sound.audio = audio;
            SoundManager soundManager = this;
            synchronized (soundManager) {
                int iC = this.sounds.length;
                Sound[] soundsNew = new Sound[iC + 1];
                int i = 0;
                while (i < iC) {
                    soundsNew[i] = this.sounds[i];
                    ++i;
                }
                soundsNew[iC] = sound;
                this.sounds = soundsNew;
            }
            return sound;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void playOnce(String path) {
        Sound sound = SoundManager.load(path);
        if (sound != null) {
            Sound sound2 = sound;
            synchronized (sound2) {
                sound.once = true;
                sound.play();
            }
        }
    }

    private class Closer
    extends Thread {
        private Closer() {
            this.setDaemon(true);
            this.setName("SoundManager");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                SoundManager soundManager = inst;
                synchronized (soundManager) {
                    int iC = SoundManager.this.sounds.length;
                    int i = 0;
                    while (i < iC) {
                        Sound sound;
                        Sound sound2 = sound = SoundManager.this.sounds[i];
                        synchronized (sound2) {
                            sound.tick();
                            if (sound.canBeDeleted()) {
                                Sound[] soundsNew = new Sound[iC - 1];
                                int c = 0;
                                int i2 = 0;
                                while (i2 < iC) {
                                    if (SoundManager.this.sounds[i2] != sound) {
                                        soundsNew[c] = SoundManager.this.sounds[i2];
                                        ++c;
                                    }
                                    ++i2;
                                }
                                SoundManager.this.sounds = soundsNew;
                                --i;
                                --iC;
                            } else if (!sound.once && sound.nextClip == null) {
                                sound.loadNext();
                            }
                        }
                        ++i;
                    }
                }
                Misc.sleep(10L);
            }
        }
    }

    public static class Loop {
        private Clip myClip;
        private boolean exists = true;

        private Loop(Sound source) {
            try {
                Clip clip = AudioSystem.getClip();
                clip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(source.audio)));
                this.myClip = clip;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.exists = false;
            }
        }

        public void stopLoop() {
            this.myClip.stop();
        }

        public void startLoop() {
            this.myClip.loop(-1);
        }

        public void endLoop() {
            this.myClip.stop();
            this.myClip.flush();
            this.myClip.close();
            this.exists = false;
        }

        public void setVolume(double volume) {
            FloatControl gainControl = (FloatControl)this.myClip.getControl(FloatControl.Type.MASTER_GAIN);
            float dB = (float)(Math.log(volume) / Math.log(10.0) * 20.0);
            gainControl.setValue(dB);
            BooleanControl muteControl = (BooleanControl)this.myClip.getControl(BooleanControl.Type.MUTE);
            muteControl.setValue(true);
            muteControl.setValue(false);
        }

        public void setBalance() {
        }
    }

    public static class Sound {
        private boolean once = false;
        private List<ClipWrapper> clips = new ArrayList<ClipWrapper>();
        private Clip nextClip = null;
        private byte[] audio = new byte[0];
        private boolean exists = true;

        private Sound() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void play() {
            Sound sound = this;
            synchronized (sound) {
                if (this.nextClip == null) {
                    this.loadNext();
                }
                if (this.nextClip != null) {
                    Clip clip = this.nextClip;
                    clip.start();
                    this.clips.add(new ClipWrapper(clip, 100));
                    this.nextClip = null;
                }
            }
        }

        public void loop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadNext() {
            Sound sound = this;
            synchronized (sound) {
                if (this.nextClip == null) {
                    try {
                        Clip clip = AudioSystem.getClip();
                        clip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(this.audio)));
                        this.nextClip = clip;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void remove() {
            this.exists = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tick() {
            Sound sound = this;
            synchronized (sound) {
                int iC = this.clips.size();
                int i = 0;
                while (i < iC) {
                    ClipWrapper wrap = this.clips.get(i);
                    Clip clip = wrap.getClip();
                    wrap.tick();
                    if (wrap.canBeDeleted()) {
                        clip.stop();
                        clip.flush();
                        clip.close();
                        this.clips.remove(i);
                        --i;
                        --iC;
                    }
                    ++i;
                }
                if (this.once && this.clips.size() == 0) {
                    this.exists = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canBeDeleted() {
            Sound sound = this;
            synchronized (sound) {
                return !this.exists;
            }
        }

        private class ClipWrapper {
            private Clip clip;
            private int counter;

            private ClipWrapper(Clip clip, int counter) {
                this.clip = clip;
                this.counter = counter;
            }

            private Clip getClip() {
                return this.clip;
            }

            private void tick() {
                --this.counter;
                if (this.counter < 90 && !this.clip.isRunning()) {
                    this.counter = 0;
                }
            }

            private boolean canBeDeleted() {
                return this.counter <= 0 && !this.clip.isRunning();
            }
        }
    }
}

