/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.audio;

import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.PropDB;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class MidiPlayer {
    private Sequencer sequencer;
    private List<MidiSong> songs;
    private List<MidiSong> playlist;
    private List<MidiSong> playlistNext;
    private int id = 0;
    private int pos;
    private static MidiPlayer inst;
    private static boolean loaded;
    private static Object lockLoaded;

    static {
        loaded = false;
        lockLoaded = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String path) {
        Object object = lockLoaded;
        synchronized (object) {
            this.songs = new ArrayList<MidiSong>();
            this.playlist = new ArrayList<MidiSong>();
            PropDB db = new PropDB();
            if (db.load(String.valueOf(path) + "list.txt")) {
                PropDB.Node root = db.getRoot();
                int iC = root.nodes.size();
                int i = 0;
                while (i < iC) {
                    PropDB.Node node = root.nodes.get(i);
                    int iC2 = node.nodes.size();
                    int i2 = 0;
                    while (i2 < iC2) {
                        this.songs.add(new MidiSong(Misc.getFileAsInputStream(String.valueOf(path) + node.nodes.get(i2).getAsString()), node.getName()));
                        ++i2;
                    }
                    ++i;
                }
            } else {
                System.out.println("MidiPlayer: '" + path + "list.txt' could not be loaded");
            }
            loaded = true;
        }
        System.out.println("MidiPlayer: songs loaded: " + this.songs.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLoaded() {
        Object object = lockLoaded;
        synchronized (object) {
            return loaded;
        }
    }

    private MidiPlayer() {
    }

    public static MidiPlayer get() {
        if (inst == null) {
            inst = new MidiPlayer();
        }
        return inst;
    }

    public static void randomizeSongs(List<MidiSong> songs) {
        ArrayList<MidiSong> temp = new ArrayList<MidiSong>();
        int iC = songs.size();
        int i = 0;
        while (i < iC) {
            temp.add((int)Math.floor(Math.random() * (double)(temp.size() + 1)), songs.remove(0));
            ++i;
        }
        i = 0;
        while (i < iC) {
            songs.add((MidiSong)temp.remove(0));
            ++i;
        }
    }

    public void setPlaylist(String name) {
        this.playlistNext = new ArrayList<MidiSong>();
        int iC = this.songs.size();
        int i = 0;
        while (i < iC) {
            MidiSong song = this.songs.get(i);
            if (song.playlist.equals(name)) {
                this.playlistNext.add(song);
            }
            ++i;
        }
    }

    public void restartMusic() {
        this.stopMusic();
        this.playlist = this.playlistNext;
        this.pos = this.playlist.size();
        this.startMusic();
    }

    public void stopMusic() {
        if (this.sequencer != null) {
            this.sequencer.stop();
            this.sequencer.close();
            this.sequencer = null;
        } else {
            System.out.println("MidiPlayer: music already stopped!");
        }
    }

    public void startMusic() {
        if (this.playlist.size() == 0) {
            System.out.println("MidiPlayer: no songs available");
            return;
        }
        if (this.pos >= this.playlist.size()) {
            this.pos = 0;
            if (this.playlist.size() > 2) {
                MidiPlayer.randomizeSongs(this.playlist);
            }
        }
        if (this.sequencer == null) {
            try {
                MidiSong song = this.playlist.get(this.pos);
                this.sequencer = MidiSystem.getSequencer();
                this.sequencer.open();
                this.sequencer.setSequence(song.song);
                this.sequencer.start();
                ++this.pos;
                SwitchThread switchthread = new SwitchThread(song.length);
                switchthread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("MidiPlayer: music already started!");
        }
    }

    protected void finalize() throws Throwable {
        this.stopMusic();
        super.finalize();
    }

    public static class MidiSong {
        public Sequence song;
        public int length;
        public String playlist;

        private MidiSong(InputStream in, String playlist) {
            try {
                this.song = MidiSystem.getSequence(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.length = (int)Math.floor((float)this.song.getMicrosecondLength() / 1000.0f);
            this.playlist = playlist;
        }
    }

    public class SwitchThread
    extends Thread {
        private int verify;
        private int length;

        public SwitchThread(int length) {
            this.setName("MidiPlayer Thread");
            this.length = length;
            MidiPlayer midiPlayer2 = MidiPlayer.this;
            midiPlayer2.id = midiPlayer2.id + 1;
            this.verify = MidiPlayer.this.id;
        }

        @Override
        public void run() {
            Misc.sleep(this.length);
            if (MidiPlayer.this.id == this.verify && MidiPlayer.this.sequencer != null) {
                MidiPlayer.this.stopMusic();
                MidiPlayer.this.startMusic();
            }
        }
    }
}

