/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers;

import com.iosoftware.helpers.Misc;

public class Vector2D {
    public double x;
    public double y;
    public static final Vector2D zero = new Vector2D(0.0, 0.0);
    public static final Vector2D eX = new Vector2D(1.0, 0.0);
    public static final Vector2D eY = new Vector2D(0.0, 1.0);

    public Vector2D() {
        this.y = 0.0;
        this.x = 0.0;
    }

    public Vector2D(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public Vector2D(Vector2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void put(Vector2D v) {
        this.x = v.x;
        this.y = v.y;
    }

    public void fromRot(double r) {
        this.x = Math.cos(r);
        this.y = Math.sin(r);
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double getSqLength() {
        return this.x * this.x + this.y * this.y;
    }

    public double getDist(Vector2D v) {
        double dx = v.x - this.x;
        double dy = v.y - this.y;
        return Math.sqrt(dx * dx + dy * dy);
    }

    public Vector2D add(Vector2D v) {
        return new Vector2D(this.x + v.x, this.y + v.y);
    }

    public void addSelf(Vector2D v) {
        this.x += v.x;
        this.y += v.y;
    }

    public void addSelf(double _x, double _y) {
        this.x += _x;
        this.y += _y;
    }

    public Vector2D sub(Vector2D v) {
        return new Vector2D(this.x - v.x, this.y - v.y);
    }

    public void subSelf(Vector2D v) {
        this.x -= v.x;
        this.y -= v.y;
    }

    public Vector2D mul(double d) {
        return new Vector2D(this.x * d, this.y * d);
    }

    public void mulSelf(double d) {
        this.x *= d;
        this.y *= d;
    }

    public Vector2D div(double d) {
        return new Vector2D(this.x / d, this.y / d);
    }

    public double dot(Vector2D v) {
        return this.x * v.x + this.y * v.y;
    }

    public double cross(Vector2D v) {
        return this.x * v.y - this.y * v.x;
    }

    public Vector2D getOrtho() {
        return new Vector2D(-this.y, this.x);
    }

    public Vector2D normalize() {
        return this.div(this.getLength());
    }

    public void normalizeSelf() {
        double l = this.getLength();
        if (l != 0.0) {
            this.x /= l;
            this.y /= l;
        }
    }

    public double getCos(Vector2D v) {
        return this.dot(v) / Math.sqrt(this.getSqLength() * v.getSqLength());
    }

    public double getSin(Vector2D v) {
        return Math.sqrt(this.cross(v) / (this.getSqLength() * v.getSqLength()));
    }

    public double getAngle(Vector2D v) {
        return Math.acos(this.getCos(v));
    }

    public double getAngle() {
        return Misc.positionsToRotation(0.0, 0.0, this.x, this.y);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }

    public boolean equals(Object other) {
        return other != null && other instanceof Vector2D && this.x == ((Vector2D)other).x && this.y == ((Vector2D)other).y;
    }
}

