/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers;

import com.iosoftware.helpers.Misc;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PropDB
implements Cloneable {
    private Node root;
    private String path;
    private boolean echo;

    public PropDB() {
        this.echo = false;
        this.root = new Node("Root");
        this.path = "";
    }

    public PropDB(String filename) {
        this.load(filename);
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public PropDB clone() {
        PropDB clone = new PropDB();
        clone.setEcho(this.echo);
        clone.path = this.path;
        clone.root = this.root == null ? null : this.root.clone();
        return clone;
    }

    public boolean load(String filename) {
        return this.load(filename, false);
    }

    public boolean load(String filename, boolean tolerant) {
        this.path = filename;
        InputStream source = Misc.getFileAsInputStream(filename);
        if (source == null) {
            if (this.echo) {
                System.out.println("PropDB error: '" + filename + "' could not be loaded!");
            }
            return false;
        }
        if (this.echo) {
            System.out.println("PropDB: Parsing file as PropDB '" + filename + "'...");
        }
        this.root = null;
        Mode mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
        Node node = null;
        StringBuilder buffer = new StringBuilder();
        boolean lastWasSlash = false;
        boolean canOpen = false;
        try {
            while (true) {
                int i;
                if ((i = source.read()) == -1) {
                    throw new Exception("source empty");
                }
                char c = (char)i;
                switch (mode) {
                    case FIND_NODE_OR_OPEN_OR_CLOSE: {
                        if (PropDB.isValidNameChar(c)) {
                            if (canOpen) {
                                canOpen = false;
                                node = node.getParentNode();
                            }
                            buffer.append(c);
                            mode = Mode.FIND_OPEN_OR_EQUALS_OR_CLOSE;
                            break;
                        }
                        if (c == '{') {
                            if (!canOpen) break;
                            canOpen = false;
                            mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                            break;
                        }
                        if (c != '}') break;
                        if (canOpen) {
                            canOpen = false;
                            node = node.getParentNode();
                        }
                        if (node == null) {
                            throw new Exception("closing node although node == null");
                        }
                        Node temp = node;
                        node = node.getParentNode();
                        mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                        if (node != null) break;
                        if (temp.getName().equals("Root") || tolerant) {
                            this.root = temp;
                        }
                        throw new Exception("root closed. must be end now >:C");
                    }
                    case FIND_OPEN_OR_EQUALS_OR_CLOSE: {
                        if (PropDB.isValidNameChar(c)) {
                            if (buffer.length() == 0) {
                                if (this.echo) {
                                    System.out.println("Back from " + node.nodeName + "...");
                                }
                                node = node.getParentNode();
                            }
                            buffer.append(c);
                            break;
                        }
                        if (buffer.length() > 0) {
                            if (node == null) {
                                if (this.echo) {
                                    System.out.println("add2null " + buffer.toString() + "...");
                                }
                                node = new Node(buffer.toString());
                            } else {
                                if (this.echo) {
                                    System.out.println("add2" + node.nodeName + " " + buffer.toString() + "...");
                                }
                                node = node.add(buffer.toString());
                            }
                            buffer.setLength(0);
                        }
                        if (c == '=') {
                            mode = Mode.FIND_QUOTES_OPEN;
                            break;
                        }
                        if (c == '{') {
                            mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                            break;
                        }
                        if (c != '}') break;
                        if ((node = node.getParentNode()) == null) {
                            throw new Exception("closing node although node == null");
                        }
                        Node temp = node;
                        node = node.getParentNode();
                        mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                        if (node != null) break;
                        if (temp.getName().equals("Root") || tolerant) {
                            this.root = temp;
                        }
                        throw new Exception("root closed. must be end now >:C");
                    }
                    case FIND_QUOTES_OPEN: {
                        if (c != '\'') break;
                        mode = Mode.FIND_QUOTES_CLOSE;
                        break;
                    }
                    case FIND_QUOTES_CLOSE: {
                        if (c == '\\') {
                            if (lastWasSlash) {
                                lastWasSlash = false;
                                buffer.append('\\');
                                break;
                            }
                            lastWasSlash = true;
                            break;
                        }
                        if (c == '\'') {
                            if (lastWasSlash) {
                                lastWasSlash = false;
                                buffer.append('\'');
                                break;
                            }
                            node.setValue(buffer.toString());
                            buffer.setLength(0);
                            mode = Mode.FIND_NODE_OR_OPEN_OR_CLOSE;
                            canOpen = true;
                            break;
                        }
                        buffer.append(c);
                        lastWasSlash = false;
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.echo) {
                e.printStackTrace();
            }
            try {
                source.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return node == null && this.root != null;
        }
    }

    public void clear() {
        this.root = new Node("Root");
    }

    public void listFromRoot() {
        if (this.root != null) {
            this.root.listTree("");
        } else if (this.echo) {
            System.out.println("PropDB error: PropDB not loaded! -> No listing available");
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public void save() {
        this.save(this.path);
    }

    public void save(String path) {
        block4: {
            if (path.length() > 0 && path.substring(0, 1).equals("/")) {
                path = path.substring(1);
            }
            try {
                File file = new File(path);
                Misc.createDirs(file.getParent());
                FileWriter fw = new FileWriter(file);
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(this.root.save(0));
                bw.close();
                fw.close();
                if (this.echo) {
                    System.out.println("PropDB: '" + path + "' saved!");
                }
            }
            catch (IOException e) {
                if (!this.echo) break block4;
                System.out.println("PropDB error: Can't save '" + path + "'");
                e.printStackTrace();
            }
        }
    }

    public byte[] pack() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.packStream(out);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return out.toByteArray();
    }

    public void packStream(OutputStream out) throws Exception {
        if (this.root != null) {
            this.root.pack(out);
        } else {
            new Node("Root").pack(out);
        }
    }

    public boolean pack(String path) {
        return this.pack(path, "");
    }

    public boolean pack(String path, String sig) {
        if (path.length() > 0 && path.substring(0, 1).equals("/")) {
            path = path.substring(1);
        }
        try {
            File file = new File(path);
            FileOutputStream out = new FileOutputStream(file);
            out.write(Misc.stringToBytes(sig));
            this.packStream(out);
            out.close();
            if (this.echo) {
                System.out.println("PropDB packed: '" + path + "' saved!");
            }
            return true;
        }
        catch (Exception e) {
            if (this.echo) {
                System.out.println("PropDB error: Can't save packed to '" + path + "'");
            }
            return false;
        }
    }

    public boolean unpack(byte[] data) {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            this.unpackStream(in);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void unpackStream(InputStream in) throws Exception {
        if (this.root == null) {
            this.clear();
        }
        this.root = Node.unpack(in);
    }

    public boolean unpack(String name) {
        return this.unpack(name, "");
    }

    public boolean unpack(String path, String sig) {
        try {
            File file = new File(path);
            FileInputStream in = new FileInputStream(file);
            String s = Misc.getString(in, sig.length());
            if (!s.equals(sig)) {
                throw new Exception("Wrong sig! Should be: " + sig + " Is: " + s);
            }
            this.unpackStream(in);
            in.close();
            if (this.echo) {
                System.out.println("PropDB unpacked: '" + path + "' loaded!");
            }
            return true;
        }
        catch (Exception ex) {
            if (this.echo) {
                System.out.println("PropDB error: Can't load packed from '" + path + "'");
            }
            return false;
        }
    }

    public static boolean isValidNameChar(char c) {
        return Character.isUpperCase(c) || Character.isLowerCase(c) || Misc.charIsDigit(c) || c == '_' || c == '-';
    }

    private static enum Mode {
        FIND_NODE_OR_OPEN_OR_CLOSE,
        FIND_OPEN_OR_EQUALS_OR_CLOSE,
        FIND_QUOTES_OPEN,
        FIND_QUOTES_CLOSE;

    }

    public static class Node
    implements Cloneable {
        private Type type = Type.T_NULL;
        private Node parent;
        private String nodeName;
        private int valInt;
        private long valLong;
        private float valFloat;
        private double valDouble;
        private String valStr;
        private boolean valBool;
        private byte[] valBin;
        public List<Node> nodes = new ArrayList<Node>();

        public Node(String name) {
            if (name == null || name.equals("")) {
                while (this.get(name = "Unnamed_Node_" + Misc.getRandomInt(Integer.MAX_VALUE)) != null) {
                }
            }
            this.nodeName = name;
            this.valBin = new byte[0];
        }

        public Node clone() {
            Node clone = new Node(this.nodeName);
            clone.type = this.type;
            clone.valInt = this.valInt;
            clone.valLong = this.valLong;
            clone.valFloat = this.valFloat;
            clone.valDouble = this.valDouble;
            clone.valStr = this.valStr;
            clone.valBool = this.valBool;
            clone.valBin = Arrays.copyOf(this.valBin, this.valBin.length);
            int iC = this.nodes.size();
            int i = 0;
            while (i < iC) {
                clone.add(this.nodes.get(i).clone());
                ++i;
            }
            return clone;
        }

        public String getName() {
            return this.nodeName;
        }

        public String getAsString() {
            switch (this.type) {
                case T_INT: {
                    return "" + this.valInt;
                }
                case T_LONG: {
                    return "" + this.valLong;
                }
                case T_FLOAT: {
                    return "" + this.valFloat;
                }
                case T_DOUBLE: {
                    return "" + this.valDouble;
                }
                case T_STR: {
                    return this.valStr;
                }
                case T_BOOL: {
                    return "" + (this.valBool ? 1 : 0);
                }
                case T_BIN: {
                    return Misc.base64encode(this.valBin);
                }
            }
            return "";
        }

        public boolean getAsBoolean() {
            switch (this.type) {
                case T_INT: {
                    return this.valInt == 1;
                }
                case T_LONG: {
                    return this.valLong == 1L;
                }
                case T_FLOAT: {
                    return this.valFloat == 0.0f;
                }
                case T_DOUBLE: {
                    return this.valDouble == 1.0;
                }
                case T_STR: {
                    return this.valStr.equals("1");
                }
                case T_BOOL: {
                    return this.valBool;
                }
                case T_BIN: {
                    return this.valBin != null && this.valBin.length > 0 && this.valBin[0] != 0;
                }
            }
            return false;
        }

        public int getAsInt() {
            switch (this.type) {
                case T_INT: {
                    return this.valInt;
                }
                case T_LONG: {
                    return (int)this.valLong;
                }
                case T_FLOAT: {
                    return (int)this.valFloat;
                }
                case T_DOUBLE: {
                    return (int)this.valDouble;
                }
                case T_STR: {
                    return Misc.getAsInt(this.valStr, 0);
                }
                case T_BOOL: {
                    return this.valBool ? 1 : 0;
                }
                case T_BIN: {
                    return Misc.extractInt(this.valBin, 0);
                }
            }
            return 0;
        }

        public long getAsLong() {
            switch (this.type) {
                case T_INT: {
                    return this.valInt;
                }
                case T_LONG: {
                    return this.valLong;
                }
                case T_FLOAT: {
                    return (long)this.valFloat;
                }
                case T_DOUBLE: {
                    return (long)this.valDouble;
                }
                case T_STR: {
                    return Misc.getAsLong(this.valStr, 0L);
                }
                case T_BOOL: {
                    return this.valBool ? 1 : 0;
                }
                case T_BIN: {
                    return Misc.extractLong(this.valBin, 0);
                }
            }
            return 0L;
        }

        public float getAsFloat() {
            switch (this.type) {
                case T_INT: {
                    return this.valInt;
                }
                case T_LONG: {
                    return this.valLong;
                }
                case T_FLOAT: {
                    return this.valFloat;
                }
                case T_DOUBLE: {
                    return (float)this.valDouble;
                }
                case T_STR: {
                    return Misc.getAsFloat(this.valStr, 0.0f);
                }
                case T_BOOL: {
                    return this.valBool ? 1 : 0;
                }
                case T_BIN: {
                    return Misc.extractFloat(this.valBin, 0);
                }
            }
            return 0.0f;
        }

        public double getAsDouble() {
            switch (this.type) {
                case T_INT: {
                    return this.valInt;
                }
                case T_LONG: {
                    return this.valLong;
                }
                case T_FLOAT: {
                    return this.valFloat;
                }
                case T_DOUBLE: {
                    return this.valDouble;
                }
                case T_STR: {
                    return Misc.getAsDouble(this.valStr, 0.0);
                }
                case T_BOOL: {
                    return this.valBool ? 1 : 0;
                }
                case T_BIN: {
                    return Misc.extractDouble(this.valBin, 0);
                }
            }
            return 0.0;
        }

        public byte[] getAsBin() {
            return this.getAsBin(true);
        }

        public byte[] getAsBin(boolean base64) {
            switch (this.type) {
                case T_INT: {
                    return Misc.intToBytes(this.valInt);
                }
                case T_LONG: {
                    return Misc.longToBytes(this.valLong);
                }
                case T_FLOAT: {
                    return Misc.floatToBytes(this.valFloat);
                }
                case T_DOUBLE: {
                    return Misc.doubleToBytes(this.valDouble);
                }
                case T_STR: {
                    return base64 ? Misc.base64decode(this.valStr) : Misc.stringToBytes(this.valStr);
                }
                case T_BOOL: {
                    return Misc.mergeBytes(Misc.buildByte(this.valBool));
                }
                case T_BIN: {
                    return this.valBin;
                }
            }
            return new byte[0];
        }

        public void listTree(String treestr) {
            int iC = this.nodes.size();
            String name = String.valueOf(treestr) + (treestr.equals("") ? "" : ".") + this.getName();
            System.out.println(String.valueOf(name) + " = '" + this.getAsString() + "'");
            int i = 0;
            while (i < iC) {
                this.nodes.get(i).listTree(name);
                ++i;
            }
        }

        public Node get(String nodename) {
            int iC = this.nodes.size();
            int i = 0;
            while (i < iC) {
                if (this.nodes.get(i).getName().equals(nodename)) {
                    return this.nodes.get(i);
                }
                ++i;
            }
            return null;
        }

        public Node get(String nodename, String value) {
            Node node = this.get(nodename);
            if (node == null) {
                Node newnode = new Node(nodename);
                newnode.setValue(value);
                return this.add(newnode);
            }
            return node;
        }

        public Node get(String nodename, boolean value) {
            Node node = this.get(nodename);
            if (node == null) {
                Node newnode = new Node(nodename);
                newnode.setValue(value);
                return this.add(newnode);
            }
            return node;
        }

        public Node get(String nodename, int value) {
            Node node = this.get(nodename);
            if (node == null) {
                Node newnode = new Node(nodename);
                newnode.setValue(value);
                return this.add(newnode);
            }
            return node;
        }

        public Node get(String nodename, long value) {
            Node node = this.get(nodename);
            if (node == null) {
                Node newnode = new Node(nodename);
                newnode.setValue(value);
                return this.add(newnode);
            }
            return node;
        }

        public Node get(String nodename, float value) {
            Node node = this.get(nodename);
            if (node == null) {
                Node newnode = new Node(nodename);
                newnode.setValue(value);
                return this.add(newnode);
            }
            return node;
        }

        public Node get(String nodename, double value) {
            Node node = this.get(nodename);
            if (node == null) {
                Node newnode = new Node(nodename);
                newnode.setValue(value);
                return this.add(newnode);
            }
            return node;
        }

        public Node add(String name) {
            Node node = this.get(name);
            if (node == null) {
                node = new Node(name);
                this.add(node);
            }
            return node;
        }

        public Node add(String name, String value) {
            Node node = this.get(name);
            if (node == null) {
                node = new Node(name);
                this.add(node);
            }
            node.setValue(value);
            return node;
        }

        public Node add(String name, boolean value) {
            Node node = this.get(name);
            if (node == null) {
                node = new Node(name);
                this.add(node);
            }
            node.setValue(value);
            return node;
        }

        public Node add(String name, int value) {
            Node node = this.get(name);
            if (node == null) {
                node = new Node(name);
                this.add(node);
            }
            node.setValue(value);
            return node;
        }

        public Node add(String name, long value) {
            Node node = this.get(name);
            if (node == null) {
                node = new Node(name);
                this.add(node);
            }
            node.setValue(value);
            return node;
        }

        public Node add(String name, float value) {
            Node node = this.get(name);
            if (node == null) {
                node = new Node(name);
                this.add(node);
            }
            node.setValue(value);
            return node;
        }

        public Node add(String name, double value) {
            Node node = this.get(name);
            if (node == null) {
                node = new Node(name);
                this.add(node);
            }
            node.setValue(value);
            return node;
        }

        public Node add(String name, byte[] value) {
            Node node = this.get(name);
            if (node == null) {
                node = new Node(name);
                this.add(node);
            }
            node.setValue(value);
            return node;
        }

        public Node add(Node node) {
            Node temp = this.get(node.getName());
            if (temp == null) {
                node.setParentNode(this);
                this.nodes.add(node);
            } else {
                node = temp;
            }
            return node;
        }

        protected void checkNull(boolean save) {
            switch (this.type) {
                case T_INT: {
                    if (this.valInt != 0) break;
                    this.type = Type.T_NULL;
                    break;
                }
                case T_LONG: {
                    if (this.valLong != 0L) break;
                    this.type = Type.T_NULL;
                    break;
                }
                case T_FLOAT: {
                    if (this.valFloat != 0.0f) break;
                    this.type = Type.T_NULL;
                    break;
                }
                case T_DOUBLE: {
                    if (this.valDouble != 0.0) break;
                    this.type = Type.T_NULL;
                    break;
                }
                case T_STR: {
                    if (!this.valStr.equals("")) break;
                    this.type = Type.T_NULL;
                    break;
                }
                case T_BOOL: {
                    if (this.valBool) break;
                    this.type = Type.T_NULL;
                    break;
                }
                case T_BIN: {
                    if (this.valBin != null && this.valBin.length != 0) break;
                    this.type = Type.T_NULL;
                    break;
                }
            }
        }

        public void setValue(String val) {
            this.setValue(val, false);
        }

        public void setValue(String val, boolean check) {
            this.valStr = val;
            this.type = Type.T_STR;
            if (check) {
                if (val.equals("1") || val.equals("0")) {
                    this.setValue(val.equals("1"));
                } else if (("" + Misc.getAsLong(val)).equals(val)) {
                    if (("" + Misc.getAsInt(val)).equals(val)) {
                        this.setValue(Misc.getAsInt(val));
                    } else {
                        this.setValue(Misc.getAsLong(val));
                    }
                } else if (("" + Misc.getAsDouble(val)).equals(val)) {
                    if (("" + Misc.getAsFloat(val)).equals(val)) {
                        this.setValue(Misc.getAsFloat(val));
                    } else {
                        this.setValue(Misc.getAsDouble(val));
                    }
                }
            }
        }

        public void setValue(boolean val) {
            this.valBool = val;
            this.type = Type.T_BOOL;
        }

        public void setValue(int val) {
            this.valInt = val;
            this.type = Type.T_INT;
        }

        public void setValue(long val) {
            this.valLong = val;
            this.type = Type.T_LONG;
        }

        public void setValue(float val) {
            this.valFloat = val;
            this.type = Type.T_FLOAT;
        }

        public void setValue(double val) {
            this.valDouble = val;
            this.type = Type.T_DOUBLE;
        }

        public void setValue(byte[] val) {
            this.valBin = val;
            this.type = Type.T_BIN;
        }

        public Node getParentNode() {
            return this.parent;
        }

        public void setParentNode(Node newparent) {
            this.parent = newparent;
        }

        public String getFormattedValue() {
            return this.getAsString().replace("\\", "\\\\").replace("'", "\\'");
        }

        public String save(int deep) {
            ++deep;
            String str = this.nodeName;
            if (this.type != Type.T_NULL) {
                str = String.valueOf(str) + " = '" + this.getFormattedValue() + "'";
            } else if (this.nodes.size() == 0) {
                str = String.valueOf(str) + " = ''";
            }
            String deepstr = "";
            String deepstr2 = "";
            int i2 = 0;
            while (i2 < deep) {
                deepstr = String.valueOf(deepstr) + "\t";
                if (i2 > 0) {
                    deepstr2 = String.valueOf(deepstr2) + "\t";
                }
                ++i2;
            }
            int iC = this.nodes.size();
            if (iC > 0) {
                str = String.valueOf(str) + " {\r\n";
                int i = 0;
                while (i < iC) {
                    str = String.valueOf(str) + deepstr + this.nodes.get(i).save(deep);
                    ++i;
                }
                str = String.valueOf(str) + deepstr2 + "}";
            }
            return String.valueOf(str) + "\r\n";
        }

        public void pack(OutputStream out) throws Exception {
            this.checkNull(false);
            boolean[] bools = Misc.initBoolArray(8, false);
            int len = this.nodeName.length();
            if (len > 31) {
                len = 31;
            }
            Misc.writeBitnumber(this.type.intNr(), bools, 0, 3);
            Misc.writeBitnumber(len, bools, 3, 5);
            out.write(Misc.byteToInt(Misc.buildByte(bools)));
            out.write(Misc.stringToBytes(this.nodeName, len));
            switch (this.type) {
                case T_INT: {
                    out.write(Misc.intToBytes(this.valInt));
                    break;
                }
                case T_LONG: {
                    out.write(Misc.longToBytes(this.valLong));
                    break;
                }
                case T_FLOAT: {
                    out.write(Misc.floatToBytes(this.valFloat));
                    break;
                }
                case T_DOUBLE: {
                    out.write(Misc.doubleToBytes(this.valDouble));
                    break;
                }
                case T_STR: {
                    out.write(Misc.intToBytes(this.valStr.length()));
                    out.write(Misc.stringToBytes(this.valStr));
                    break;
                }
                case T_BOOL: {
                    out.write(Misc.intToByte(this.valBool ? 1 : 0));
                    break;
                }
                case T_BIN: {
                    out.write(Misc.intToBytes(this.valBin.length));
                    out.write(this.valBin);
                    break;
                }
            }
            int iC = this.nodes.size();
            out.write(Misc.intToBytes(iC));
            int i = 0;
            while (i < iC) {
                this.nodes.get(i).pack(out);
                ++i;
            }
        }

        public static Node unpack(InputStream in) throws Exception {
            boolean[] bools = Misc.readByte(Misc.intToByte(in.read()));
            int l = Misc.getBitnumber(bools, 3, 5);
            String name = Misc.getString(in, l);
            Node node = new Node(name);
            Type type = Type.byIntNr(Misc.getBitnumber(bools, 0, 3));
            switch (type) {
                case T_INT: {
                    node.setValue(Misc.getInt(in));
                    break;
                }
                case T_LONG: {
                    node.setValue(Misc.getLong(in));
                    break;
                }
                case T_FLOAT: {
                    node.setValue(Misc.getFloat(in));
                    break;
                }
                case T_DOUBLE: {
                    node.setValue(Misc.getDouble(in));
                    break;
                }
                case T_STR: {
                    l = Misc.getInt(in);
                    node.setValue(Misc.getString(in, l));
                    break;
                }
                case T_BOOL: {
                    node.setValue(in.read() == 1);
                    break;
                }
                case T_BIN: {
                    l = Misc.getInt(in);
                    byte[] buf = Misc.read(in, l);
                    node.setValue(buf);
                    break;
                }
            }
            int iC = Misc.getInt(in);
            int i = 0;
            while (i < iC) {
                node.add(Node.unpack(in));
                ++i;
            }
            return node;
        }

        private static enum Type {
            T_NULL,
            T_INT,
            T_LONG,
            T_FLOAT,
            T_DOUBLE,
            T_STR,
            T_BOOL,
            T_BIN;


            public int intNr() {
                switch (this) {
                    case T_INT: {
                        return 1;
                    }
                    case T_LONG: {
                        return 2;
                    }
                    case T_FLOAT: {
                        return 3;
                    }
                    case T_DOUBLE: {
                        return 4;
                    }
                    case T_STR: {
                        return 5;
                    }
                    case T_BOOL: {
                        return 6;
                    }
                    case T_BIN: {
                        return 7;
                    }
                }
                return 0;
            }

            public static Type byIntNr(int nr) {
                switch (nr) {
                    case 1: {
                        return T_INT;
                    }
                    case 2: {
                        return T_LONG;
                    }
                    case 3: {
                        return T_FLOAT;
                    }
                    case 4: {
                        return T_DOUBLE;
                    }
                    case 5: {
                        return T_STR;
                    }
                    case 6: {
                        return T_BOOL;
                    }
                    case 7: {
                        return T_BIN;
                    }
                }
                return T_NULL;
            }
        }
    }
}

