/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Misc {
    private static ActionListener actionListener;
    public static final double oneDegreeInRad = Math.PI / 180;
    private static final String IPSITE = "http://api.champany.de/j/?ip";
    public static final String VERSION = "IoLib v1.3.0";
    private static final char[] ALPHABET;
    private static int[] toInt;

    static {
        ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
        toInt = new int[128];
        int i = 0;
        while (i < ALPHABET.length) {
            Misc.toInt[Misc.ALPHABET[i]] = i;
            ++i;
        }
    }

    private Misc() {
    }

    public static void setLF() {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void doDefaults(Component c, Component base) {
        c.setFont(base.getFont());
        c.setBackground(base.getBackground());
        c.setForeground(base.getForeground());
    }

    public static void invokeAndWait(Runnable run) {
        try {
            SwingUtilities.invokeAndWait(run);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getExternalIP() {
        String ip = Misc.getFirstLine(IPSITE);
        if (ip == null) {
            ip = Misc.getIP();
        }
        return ip;
    }

    public static String getFirstLine(String url) {
        try {
            String line = null;
            Scanner scanner = new Scanner(new URL(url).openStream());
            if (scanner.hasNextLine()) {
                line = scanner.nextLine();
            }
            scanner.close();
            return line;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public static String getUserName() {
        return System.getProperty("user.name");
    }

    public static long getTimeInMilliseconds() {
        return System.currentTimeMillis();
    }

    public static boolean fileExists(String file) {
        return new File(file).exists();
    }

    public static boolean portAvailable(int port) {
        if (port < 0 || port > 65535) {
            System.out.println("Can't check port " + port);
            return false;
        }
        try {
            ServerSocket socket = new ServerSocket(port);
            socket.setReuseAddress(true);
            socket.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static String getFileAsString(String path) {
        InputStream in;
        String str;
        block4: {
            str = "";
            in = Misc.getFileAsInputStream(path);
            if (in != null) break block4;
            System.out.println("Loading error: Could not load file '" + path + "'");
            return "";
        }
        try {
            int size = in.available();
            int i = 0;
            while (i < size) {
                str = String.valueOf(str) + String.valueOf((char)in.read());
                ++i;
            }
            in.close();
        }
        catch (IOException ex) {
            System.out.println("I/O error: file '" + path + "'");
        }
        return str;
    }

    public static InputStream getFileAsInputStream(String path) {
        InputStream in = Misc.class.getResourceAsStream(path);
        if (in == null) {
            in = Misc.getFileAsInputStream2(path);
        } else {
            System.out.println("Loaded '" + path + "' with method #1");
        }
        return in;
    }

    public static InputStream getFileAsInputStream(File file) {
        InputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (in == null) {
            String str = Misc.loadStringFromFile(file.getAbsolutePath());
            if (str != null) {
                in = new ByteArrayInputStream(str.getBytes());
            }
        } else {
            System.out.println("Loaded '" + file.getAbsolutePath() + "' with method #2");
        }
        return in;
    }

    public static InputStream getFileAsInputStream2(String path) {
        InputStream in = null;
        try {
            in = new FileInputStream(path);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (in == null) {
            String str = Misc.loadStringFromFile(path);
            if (str != null) {
                in = new ByteArrayInputStream(str.getBytes());
            }
        } else {
            System.out.println("Loaded '" + path + "' with method #2");
        }
        return in;
    }

    public static byte intToByte(int val) {
        if (val < 0 || val > 255) {
            System.out.println("Warning: Can't convert " + val + " to a byte (must be 0-255)");
            return 0;
        }
        return (byte)val;
    }

    public static int byteToInt(byte val) {
        int intval = val;
        return intval &= 0xFF;
    }

    public static String loadStringFromFile(String path) {
        File file = new File(path);
        String buffer = "";
        if (!file.exists()) {
            return null;
        }
        try {
            FileReader fr = new FileReader(path);
            BufferedReader br = new BufferedReader(fr);
            String str = "";
            while ((str = br.readLine()) != null) {
                buffer = String.valueOf(buffer) + str + "\n";
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("Loaded '" + path + "' with method #3");
        return buffer;
    }

    public static int checkPort(int port, int alternative) {
        return port < 0 || port > 65535 ? alternative : port;
    }

    public static void createDirs(String dirs) {
        File file = new File(dirs);
        file.mkdirs();
    }

    public static double getAngle(double angle1, double angle2) {
        double anglex = Misc.normalizeRotation(angle2 - angle1);
        return anglex;
    }

    public static double rotateStep(double rotation, double target, double step) {
        double an2;
        boolean mode;
        double an1 = Misc.getAngle(rotation, target);
        boolean bl = mode = an1 < (an2 = Misc.getAngle(target, rotation));
        if (an1 < step || an2 < step) {
            step = mode ? an1 : an2;
        }
        return step *= (double)(mode ? 1.0f : -1.0f);
    }

    public static double rotateTo(double rotation, double target, double step) {
        double an1 = Misc.getAngle(rotation, target);
        double an2 = Misc.getAngle(target, rotation);
        rotation = an1 < step || an2 < step ? target : (rotation += (an1 < an2 ? 1.0 : -1.0) * step);
        return rotation;
    }

    public static boolean compareRotationsByDegrees(double rot1, double rot2) {
        int deg2;
        int deg1 = (int)Math.floor(Misc.normalizeRotation(rot1) / Math.PI * 2.0 * 360.0);
        return deg1 == (deg2 = (int)Math.floor(Misc.normalizeRotation(rot2) / Math.PI * 2.0 * 360.0));
    }

    public static double calculateEffectiveness(double is, double max) {
        return Math.sin(1.5707963267948966 * (is / max));
    }

    public static boolean[] initBoolArray(int c, boolean val) {
        boolean[] bool = new boolean[c];
        Arrays.fill(bool, val);
        return bool;
    }

    public static Image mergeImages(Image base, Image over) {
        BufferedImage img = new BufferedImage(base.getWidth(null), base.getWidth(null), 2);
        Graphics g = img.getGraphics();
        g.drawImage(base, 0, 0, null);
        g.drawImage(over, 0, 0, null);
        g.dispose();
        return img;
    }

    public static String trimString(String input, int maxChars) {
        return input.length() > maxChars ? input.substring(0, maxChars) : input;
    }

    public static Image rotateImage(Image src, double rad) {
        if (src != null) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(-rad, src.getWidth(null) / 2, src.getHeight(null) / 2);
            BufferedImage rotatedImage = new BufferedImage(src.getWidth(null), src.getHeight(null), 2);
            Graphics2D g = (Graphics2D)rotatedImage.getGraphics();
            g.setTransform(affineTransform);
            g.drawImage(src, 0, 0, null);
            g.dispose();
            return rotatedImage;
        }
        return null;
    }

    public static Image resize4rotate(Image src) {
        double oldwidth = src.getWidth(null);
        double oldheight = src.getHeight(null);
        double width = oldwidth * Math.sqrt(2.0);
        double height = oldheight * Math.sqrt(2.0);
        BufferedImage img = new BufferedImage((int)Math.round(width), (int)Math.round(height), 2);
        Graphics g = img.getGraphics();
        g.drawImage(src, (int)Math.round((width - oldwidth) / 2.0), (int)Math.round((height - oldheight) / 2.0), null);
        g.dispose();
        return img;
    }

    public static BufferedImage getReplacedColorInstance(Image img, int rgb, int rgb2) {
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        BufferedImage img2 = new BufferedImage(w, h, 2);
        Graphics2D g = img2.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                int i = img2.getRGB(x, y);
                if (i == rgb) {
                    img2.setRGB(x, y, rgb2);
                }
                ++y;
            }
            ++x;
        }
        return img2;
    }

    public static void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public static int searchIntArray(int[] array, int theInt) {
        int len = array.length;
        int i = 0;
        while (i < len) {
            if (array[i] == theInt) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static double positionsToRotation(double x1, double y1, double x2, double y2) {
        if (x1 == x2 && y1 == y2) {
            return 0.0;
        }
        double t = (y2 - y1) / (x2 - x1);
        if (x2 < x1) {
            return Math.PI + Math.atan(t);
        }
        return Math.atan(t);
    }

    public static boolean charIsDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public static int getAsInt(String str) {
        return Misc.getAsInt(str, -1);
    }

    public static int getAsInt(String str, int d) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static short getAsShort(String str) {
        return Misc.getAsShort(str, (short)-1);
    }

    public static short getAsShort(String str, short d) {
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static long getAsLong(String str) {
        return Misc.getAsLong(str, -1L);
    }

    public static long getAsLong(String str, long d) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static float getAsFloat(String str) {
        return Misc.getAsFloat(str, -1.0f);
    }

    public static float getAsFloat(String str, float d) {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static double getAsDouble(String str) {
        return Misc.getAsDouble(str, -1.0);
    }

    public static double getAsDouble(String str, double d) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static byte getAsByte(String str) {
        return Misc.getAsByte(str, (byte)-1);
    }

    public static byte getAsByte(String str, byte d) {
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException e) {
            return d;
        }
    }

    public static boolean compareMsg(byte[] msg, char[] str, int offset) {
        if (msg.length - (str.length + offset) < 0) {
            return false;
        }
        int i = 0;
        while (i < str.length) {
            if ((char)msg[i + offset] != str[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] cutBytes(byte[] bytes, int length, int offset) {
        if (bytes.length < length + offset || offset < 0 || length < 0) {
            return new byte[0];
        }
        byte[] newbytes = new byte[length];
        System.arraycopy(bytes, offset, newbytes, 0, length);
        return newbytes;
    }

    public static void setActionListener(ActionListener newActionListener) {
        actionListener = newActionListener;
    }

    public static ActionListener getActionListener() {
        return actionListener;
    }

    public static boolean isLocalHost(Socket socket) {
        try {
            return socket.getInetAddress().equals(InetAddress.getLocalHost());
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static int getRandomInt(int maxint) {
        return (int)Math.floor(Math.random() * (double)maxint);
    }

    public static boolean getRandomBool() {
        return Misc.getRandomInt(2) == 0;
    }

    public static int extractInt(byte[] bytes, int pos) {
        return Misc.extractInt(bytes, pos, 4);
    }

    public static int extractInt(byte[] bytes, int pos, int len) {
        if (bytes.length < pos + len) {
            System.out.println("FATAL ERROR: extractInt failed (" + bytes.length + ", " + pos + ", " + len + ")");
            return 0;
        }
        int val = 0;
        int c = 0;
        if (len >= 4) {
            val += (0xFF & bytes[pos + c]) << 24;
            ++c;
        }
        if (len >= 3) {
            val += (0xFF & bytes[pos + c]) << 16;
            ++c;
        }
        if (len >= 2) {
            val += (0xFF & bytes[pos + c]) << 8;
            ++c;
        }
        if (len >= 1) {
            val += 0xFF & bytes[pos + c];
            ++c;
        }
        return val;
    }

    public static long extractLong(byte[] bytes, int pos) {
        return Misc.extractLong(bytes, pos, 8);
    }

    public static long extractLong(byte[] bytes, int pos, int len) {
        if (bytes.length < pos + len) {
            System.out.println("FATAL ERROR: extractLong failed (" + bytes.length + ", " + pos + ", " + len + ")");
            return 0L;
        }
        long val = 0L;
        int c = 0;
        if (len >= 8) {
            val += (long)bytes[pos + c] << 56;
            ++c;
        }
        if (len >= 7) {
            val += (long)(bytes[pos + c] & 0xFF) << 48;
            ++c;
        }
        if (len >= 6) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 40;
            ++c;
        }
        if (len >= 5) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 32;
            ++c;
        }
        if (len >= 4) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 24;
            ++c;
        }
        if (len >= 3) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 16;
            ++c;
        }
        if (len >= 2) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 8;
            ++c;
        }
        if (len >= 1) {
            val += (long)(0xFF & bytes[pos + c] & 0xFF) << 0;
            ++c;
        }
        return val;
    }

    public static float extractFloat(byte[] bytes, int pos) {
        return Misc.extractFloat(bytes, pos, 4);
    }

    public static float extractFloat(byte[] bytes, int pos, int len) {
        int v = Misc.extractInt(bytes, pos, len);
        return Float.intBitsToFloat(v);
    }

    public static double extractDouble(byte[] bytes, int pos) {
        return Misc.extractDouble(bytes, pos, 8);
    }

    public static double extractDouble(byte[] bytes, int pos, int len) {
        long v = Misc.extractLong(bytes, pos, len);
        return Double.longBitsToDouble(v);
    }

    public static int convertByteArrayToInt(byte[] bytes) {
        return Misc.extractInt(bytes, 0, bytes.length);
    }

    public static byte[] convertLongToByteArray(long val) {
        byte[] bytes = new byte[]{(byte)(val >>> 56), (byte)(val >>> 48), (byte)(val >>> 40), (byte)(val >>> 32), (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return bytes;
    }

    public static long convertByteArrayToLong(byte[] bytes) {
        if (bytes.length < 8) {
            return 0L;
        }
        return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0);
    }

    public static byte[] insertInBytes(byte[] target, byte[] source, int pos) {
        return Misc.insertInBytes(target, source, pos, source.length);
    }

    public static byte[] insertInBytes(byte[] target, byte[] source, int pos, int len) {
        int tarLen = target.length;
        if (len > source.length) {
            System.out.println("Can't insert! len (" + len + ") > source.length (" + source.length + ")");
            return target;
        }
        if (tarLen < len + pos) {
            System.out.println("Can't insert! (Target: " + tarLen + " Insert: " + len + " Pos: " + pos + ")");
            return target;
        }
        int i = 0;
        while (i < len) {
            target[i + pos] = source[i];
            ++i;
        }
        return target;
    }

    public static byte[] insertInt(byte[] target, int pos, int intValue) {
        int tarLen = target.length;
        if (tarLen < 4 + pos) {
            System.out.println("Can't insert Int! (Target: " + tarLen + " Insert int: " + intValue + " Pos: " + pos + ")");
            return target;
        }
        int i = 0;
        while (i < 4) {
            target[i + pos] = (byte)(intValue >>> 24 - 8 * i);
            ++i;
        }
        return target;
    }

    public static byte[] insertLong(byte[] target, int pos, long longValue) {
        int tarLen = target.length;
        if (tarLen < 8 + pos) {
            System.out.println("Can't insert Long! (Target: " + tarLen + " Insert long: " + longValue + " Pos: " + pos + ")");
            return target;
        }
        int i = 0;
        while (i < 8) {
            target[i + pos] = (byte)(longValue >>> 56 - 8 * i);
            ++i;
        }
        return target;
    }

    public static byte[] stringToBytes(String str) {
        return Misc.stringToBytes(str, str.length());
    }

    public static byte[] stringToBytes(String str, int maxchars) {
        int iC = maxchars;
        int iC2 = str.length();
        byte[] bytes = new byte[maxchars];
        int i = 0;
        while (i < iC) {
            bytes[i] = i < iC2 ? (byte)str.charAt(i) : (byte)0;
            ++i;
        }
        return bytes;
    }

    public static void insertStringInBytes(byte[] bytes, int start, int length, String str) {
        if (length != 0 && (bytes.length <= start || bytes.length < length + start)) {
            System.out.println("Can't insert string in bytes");
            return;
        }
        int strlen = str.length();
        int i = 0;
        while (i < length) {
            bytes[start + i] = Misc.intToByte(strlen > i ? (int)str.charAt(i) : 0);
            ++i;
        }
    }

    public static void drawCenteredString(String s, int offx, int offy, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = offx + (w - fm.stringWidth(s)) / 2;
        int y = offy + (fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2);
        g.drawString(s, x, y);
    }

    public static void drawShadowedCenteredString(String s, int offx, int offy, int w, int h, Graphics g) {
        Color color = g.getColor();
        Color colShadow = new Color(0, 0, 0, color.getAlpha());
        g.setColor(colShadow);
        Misc.drawCenteredString(s, offx + 1, offy + 1, w, h, g);
        g.setColor(color);
        Misc.drawCenteredString(s, offx, offy, w, h, g);
    }

    public static void drawVerticalCenteredString(String s, int x, int offy, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int y = offy + (fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2);
        g.drawString(s, x, y);
    }

    public static int stringLength(String str, Font font, Graphics g) {
        return g.getFontMetrics(font).stringWidth(str);
    }

    public static int stringLength(String str, Graphics g) {
        return g.getFontMetrics().stringWidth(str);
    }

    public static String getString(InputStream in, int maxchars) throws IOException {
        byte[] bytes = new byte[maxchars];
        int i = 0;
        while (i < maxchars) {
            bytes[i] = Misc.intToByte(Misc.read(in));
            ++i;
        }
        return Misc.bytesToString(bytes);
    }

    public static byte[] intToBytes(int v) {
        return Misc.intToBytes(v, 4);
    }

    public static byte[] intToBytes(int v, int nr) {
        return Misc.longToBytes(v, nr);
    }

    public static byte[] longToBytes(long v) {
        return Misc.longToBytes(v, 8);
    }

    public static byte[] longToBytes(long v, int nr) {
        byte[] bytes = new byte[nr];
        int i = 0;
        while (i < nr) {
            bytes[i] = (byte)(v >>> 8 * (nr - i - 1));
            ++i;
        }
        return bytes;
    }

    public static byte[] floatToBytes(float v) {
        return Misc.floatToBytes(v, 4);
    }

    public static byte[] floatToBytes(float v, int nr) {
        int v2 = Float.floatToRawIntBits(v);
        return Misc.intToBytes(v2, nr);
    }

    public static byte[] doubleToBytes(double v) {
        return Misc.doubleToBytes(v, 8);
    }

    public static byte[] doubleToBytes(double v, int nr) {
        long v2 = Double.doubleToRawLongBits(v);
        return Misc.longToBytes(v2, nr);
    }

    public static int getInt(InputStream in) throws IOException {
        return Misc.getInt(in, 4);
    }

    public static int getInt(InputStream in, int max) throws IOException {
        byte[] b = Misc.read(in, max);
        return Misc.extractInt(b, 0, max);
    }

    public static long getLong(InputStream in) throws IOException {
        return Misc.getLong(in, 4);
    }

    public static long getLong(InputStream in, int max) throws IOException {
        byte[] b = Misc.read(in, max);
        return Misc.extractLong(b, 0, max);
    }

    public static float getFloat(InputStream in) throws IOException {
        return Misc.getFloat(in, 4);
    }

    public static float getFloat(InputStream in, int max) throws IOException {
        byte[] b = Misc.read(in, max);
        return Misc.extractFloat(b, 0, max);
    }

    public static double getDouble(InputStream in) throws IOException {
        return Misc.getDouble(in, 4);
    }

    public static double getDouble(InputStream in, int max) throws IOException {
        byte[] b = Misc.read(in, max);
        return Misc.extractDouble(b, 0, max);
    }

    public static int getBitnumber(boolean[] b, int start, int len) {
        return Misc.getBitnumber(b, start, len, true);
    }

    public static int getBitnumber(boolean[] b, int start, int len, boolean l) {
        int n = 0;
        int u = 1;
        int i = 0;
        while (i < len) {
            int d;
            int n2 = d = l ? start + len - 1 - i : start + i;
            if (b[d]) {
                n += u;
            }
            u *= 2;
            ++i;
        }
        return n;
    }

    public static boolean[] writeBitnumber(int num, int length) {
        boolean[] bs = Misc.initBoolArray(length, false);
        Misc.writeBitnumber(num, bs, 0, length);
        return bs;
    }

    public static void writeBitnumber(int num, boolean[] bs, int start, int length) {
        Misc.writeBitnumber(num, bs, start, length, true);
    }

    public static void writeBitnumber(int num, boolean[] bs, int start, int length, boolean l) {
        int i = 0;
        while (i < length) {
            bs[l ? start + length - i - 1 : start + i] = num % 2 == 1;
            num /= 2;
            ++i;
        }
    }

    public static String bytesToString(byte[] bytes) {
        return Misc.getSubString(bytes, 0, bytes.length);
    }

    public static int read(InputStream in) throws IOException {
        int val = in.read();
        if (val == -1) {
            throw new IOException("End of stream reached");
        }
        return val;
    }

    public static int read(InputStream in, byte[] bA) throws IOException {
        int iC = bA.length;
        int read = 0;
        int i = 0;
        while (i < iC) {
            int b = -1;
            b = in.read();
            if (b == -1) break;
            bA[i] = Misc.intToByte(b);
            ++read;
            ++i;
        }
        return read;
    }

    public static byte[] read(InputStream in, int num) throws IOException {
        int iC = num;
        byte[] bytes = new byte[num];
        int read = 0;
        int i = 0;
        while (i < iC) {
            int b = -1;
            b = in.read();
            if (b == -1) break;
            bytes[i] = Misc.intToByte(b);
            ++read;
            ++i;
        }
        if (read != num) {
            throw new IOException("Read " + read + "/" + num + " bytes only (End of stream reached?)");
        }
        return bytes;
    }

    public static byte[] read(InputStream in, int num, byte[] append) throws IOException {
        int oldLen = append.length;
        int iC = oldLen + num;
        byte[] bytes = new byte[iC];
        int read = 0;
        int i = 0;
        while (i < iC) {
            if (i < oldLen) {
                bytes[i] = append[i];
            } else {
                int b = -1;
                b = in.read();
                if (b == -1) break;
                bytes[i] = Misc.intToByte(b);
                ++read;
            }
            ++i;
        }
        if (read != num) {
            throw new IOException("Read " + read + "/" + num + " bytes only");
        }
        return bytes;
    }

    public static String getSubString(byte[] bytes, int start, int length) {
        StringBuilder str = new StringBuilder();
        if (bytes.length > start && length > 0) {
            int i = 0;
            while (i < length) {
                char chr = (char)Misc.byteToInt(bytes[start + i]);
                if (chr == '\u0000') break;
                str.append(chr);
                ++i;
            }
        }
        return str.toString();
    }

    public static byte buildByte(boolean ... bools) {
        return Misc.buildByte(bools, 0, bools.length);
    }

    public static byte buildByte(boolean[] bools, int offset, int length) {
        int bin = 0;
        int i = 0;
        while (i < 8) {
            if (length == i) break;
            if (bools[offset + i]) {
                bin |= 1 << i;
            }
            ++i;
        }
        return (byte)bin;
    }

    public static byte[] buildBytes(boolean[] values, int numBytes) {
        if (numBytes < -1) {
            return new byte[0];
        }
        if (values == null) {
            values = new boolean[]{};
        }
        int numValues = values.length;
        numBytes = numBytes == -1 ? numValues / 8 + (numValues % 8 == 0 ? 0 : 1) : numBytes;
        byte[] bytes = new byte[numBytes];
        int i = 0;
        while (i < numBytes) {
            int bin = 0;
            int i2 = 0;
            while (i2 < 8) {
                int valNr = i * 8 + i2;
                if (numValues > valNr && values[valNr]) {
                    bin |= 1 << i2;
                }
                ++i2;
            }
            bytes[i] = (byte)bin;
            ++i;
        }
        return bytes;
    }

    public static boolean[] readByte(byte b) {
        byte bin = b;
        boolean[] bools = new boolean[8];
        int i = 0;
        while (i < 8) {
            bools[i] = (bin & 1 << i) != 0;
            ++i;
        }
        return bools;
    }

    public static boolean[] readBytes(byte[] bytes) {
        return Misc.readBytes(bytes, 0, bytes.length, -1);
    }

    public static boolean[] readBytes(InputStream in, int numBytes, int numBools) throws IOException {
        if (numBytes < -1) {
            numBytes = 0;
        }
        if (numBools < -1) {
            numBools = 0;
        }
        if (numBytes == -1 && numBools == -1) {
            System.out.println("Error: Can't bydefault numBytes AND numBools !");
            return null;
        }
        if (numBytes == -1) {
            numBytes = numBools / 8 + (numBools % 8 > 0 ? 1 : 0);
        }
        if (numBools == -1) {
            numBools = numBytes * 8;
        }
        byte[] bytes = new byte[numBytes];
        int i = 0;
        while (i < numBytes) {
            bytes[i] = Misc.intToByte(in.read());
            ++i;
        }
        return Misc.readBytes(bytes, 0, numBytes, numBools);
    }

    public static boolean[] readBytes(byte[] bytes, int offset, int length, int numBools) {
        if (numBools < -1) {
            numBools = 0;
        }
        numBools = numBools == -1 ? length * 8 : numBools;
        boolean[] bools = new boolean[numBools];
        int i = 0;
        while (i < length) {
            if (numBools <= i * 8) break;
            boolean[] tempB = Misc.readByte(bytes[i + offset]);
            int i2 = 0;
            while (i2 < 8) {
                if (numBools <= i * 8 + i2) break;
                bools[i * 8 + i2] = tempB[i2];
                ++i2;
            }
            ++i;
        }
        return bools;
    }

    public static byte[] mergeBytes(byte[][] bytesArray) {
        int iC = bytesArray.length;
        int pos = 0;
        int i = 0;
        while (i < iC) {
            pos += bytesArray[i].length;
            ++i;
        }
        byte[] bytes = new byte[pos];
        pos = 0;
        int i2 = 0;
        while (i2 < iC) {
            int c = bytesArray[i2].length;
            int i22 = 0;
            while (i22 < c) {
                bytes[pos] = bytesArray[i2][i22];
                ++pos;
                ++i22;
            }
            ++i2;
        }
        return bytes;
    }

    public static byte[] mergeBytes(List<byte[]> bytesArray) {
        int iC = bytesArray.size();
        int pos = 0;
        int i = 0;
        while (i < iC) {
            pos += bytesArray.get(i).length;
            ++i;
        }
        byte[] bytes = new byte[pos];
        pos = 0;
        int i2 = 0;
        while (i2 < iC) {
            byte[] bA = bytesArray.get(i2);
            int c = bA.length;
            int i22 = 0;
            while (i22 < c) {
                bytes[pos] = bA[i22];
                ++pos;
                ++i22;
            }
            ++i2;
        }
        return bytes;
    }

    public static byte[] mergeBytes(byte[] extraB, byte[][] bytesArray) {
        int exC = extraB.length;
        int iC = bytesArray.length;
        int pos = exC;
        int i = 0;
        while (i < iC) {
            pos += bytesArray[i].length;
            ++i;
        }
        byte[] bytes = new byte[pos];
        int i2 = 0;
        while (i2 < exC) {
            bytes[i2] = extraB[i2];
            ++i2;
        }
        pos = exC;
        i2 = 0;
        while (i2 < iC) {
            int c = bytesArray[i2].length;
            int i22 = 0;
            while (i22 < c) {
                bytes[pos] = bytesArray[i2][i22];
                ++pos;
                ++i22;
            }
            ++i2;
        }
        return bytes;
    }

    public static byte[] mergeBytes(byte[] extraB, List<byte[]> bytesArray) {
        int exC = extraB.length;
        int iC = bytesArray.size();
        int pos = exC;
        int i = 0;
        while (i < iC) {
            pos += bytesArray.get(i).length;
            ++i;
        }
        byte[] bytes = new byte[pos];
        int i2 = 0;
        while (i2 < exC) {
            bytes[i2] = extraB[i2];
            ++i2;
        }
        pos = exC;
        i2 = 0;
        while (i2 < iC) {
            byte[] bA = bytesArray.get(i2);
            int c = bA.length;
            int i22 = 0;
            while (i22 < c) {
                bytes[pos] = bA[i22];
                ++pos;
                ++i22;
            }
            ++i2;
        }
        return bytes;
    }

    public static byte[] mergeBytes(byte b) {
        byte[] bytes = new byte[]{b};
        return bytes;
    }

    public static byte[] mergeBytes(byte b1, byte b2) {
        byte[] temp1 = new byte[1];
        byte[] temp2 = new byte[1];
        temp1[0] = b1;
        temp2[0] = b2;
        return Misc.mergeBytes(temp1, temp2);
    }

    public static byte[] mergeBytes(byte[] temp1, byte b2) {
        byte[] temp2 = new byte[]{b2};
        return Misc.mergeBytes(temp1, temp2);
    }

    public static byte[] mergeBytes(byte b1, byte[] temp2) {
        byte[] temp1 = new byte[]{b1};
        return Misc.mergeBytes(temp1, temp2);
    }

    public static byte[] mergeBytes(byte[] b1, byte[] b2) {
        int iC = b1.length + b2.length;
        byte[] bytes = new byte[iC];
        int i = 0;
        while (i < iC) {
            bytes[i] = i < b1.length ? b1[i] : b2[i - b1.length];
            ++i;
        }
        return bytes;
    }

    public static double normalizeRotation(double rotation) {
        double temp = rotation % (Math.PI * 2);
        return rotation < 0.0 ? Math.PI * 2 + temp : temp;
    }

    public static void dumpToFile(byte[] bytes) {
        Misc.dumpToFile(bytes, "C:/javadump.txt");
    }

    public static void dumpToFile(byte[] bytes, String path) {
        try {
            File f = new File(path);
            f.getParentFile().mkdirs();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));
            int iC = bytes.length;
            int i = 0;
            while (i < iC) {
                ((OutputStream)out).write(bytes[i]);
                ++i;
            }
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static Cursor getHiddenCursor() {
        return Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(16, 16, 2), new Point(0, 0), "invisible");
    }

    public static BufferedImage easyRotate(Image src, int step) {
        step = Math.abs(step) % 4;
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        BufferedImage srcX = new BufferedImage(w, h, 2);
        Graphics g = srcX.getGraphics();
        g.drawImage(src, 0, 0, null);
        g.dispose();
        BufferedImage img = null;
        switch (step) {
            case 0: {
                img = new BufferedImage(w, h, 2);
                int x = 0;
                while (x < w) {
                    int y = 0;
                    while (y < h) {
                        img.setRGB(x, y, srcX.getRGB(x, y));
                        ++y;
                    }
                    ++x;
                }
                break;
            }
            case 1: {
                img = new BufferedImage(h, w, 2);
                int x = 0;
                while (x < w) {
                    int y = 0;
                    while (y < h) {
                        img.setRGB(h - 1 - y, x, srcX.getRGB(x, y));
                        ++y;
                    }
                    ++x;
                }
                break;
            }
            case 2: {
                img = new BufferedImage(w, h, 2);
                int x = 0;
                while (x < w) {
                    int y = 0;
                    while (y < h) {
                        img.setRGB(w - 1 - x, h - 1 - y, srcX.getRGB(x, y));
                        ++y;
                    }
                    ++x;
                }
                break;
            }
            case 3: {
                img = new BufferedImage(h, w, 2);
                int x = 0;
                while (x < w) {
                    int y = 0;
                    while (y < h) {
                        img.setRGB(y, w - 1 - x, srcX.getRGB(x, y));
                        ++y;
                    }
                    ++x;
                }
                break;
            }
        }
        srcX.flush();
        return img;
    }

    public static byte[] readFile(String path) {
        try {
            int readBytes;
            InputStream in = Misc.getFileAsInputStream(path);
            if (in == null) {
                throw new IOException();
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            byte[] bytes = new byte[1024];
            while ((readBytes = in.read(bytes)) > 0) {
                out.write(bytes, 0, readBytes);
            }
            byte[] data = out.toByteArray();
            in.close();
            out.close();
            return data;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean writeFile(String path, byte[] content) {
        try {
            File file = new File(path);
            FileOutputStream out = new FileOutputStream(file);
            out.write(content);
            out.flush();
            out.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static double getDistance(double x1, double y1, double x2, double y2) {
        double dX = x2 - x1;
        double dY = y2 - y1;
        return Math.sqrt(dX * dX + dY * dY);
    }

    public static BufferedImage loadImage(String path) {
        BufferedImage img = null;
        InputStream in = null;
        try {
            in = Misc.getFileAsInputStream(path);
            img = ImageIO.read(in);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    public static BufferedImage[] loadImages(String path, int w, int h) {
        BufferedImage s = Misc.loadImage(path);
        BufferedImage[] imgs = Misc.loadImages(s, w, h);
        s.flush();
        return imgs;
    }

    public static BufferedImage[] loadImages(Image s, int w, int h) {
        BufferedImage[] imgs = new BufferedImage[w * h];
        int sx = s.getWidth(null) / w;
        int sy = s.getHeight(null) / h;
        int x = 0;
        while (x < w) {
            int y = 0;
            while (y < h) {
                BufferedImage i = new BufferedImage(sx, sy, 2);
                Graphics2D g = i.createGraphics();
                g.drawImage(s, 0, 0, sx, sy, sx * x, sy * y, sx * x + sx, sy * y + sy, null);
                g.dispose();
                imgs[y * w + x] = i;
                ++y;
            }
            ++x;
        }
        s.flush();
        return imgs;
    }

    public static BufferedImage[][] splitAndRotate(String imgPath, int sX, int sY) {
        BufferedImage img = Misc.loadImage(imgPath);
        BufferedImage[][] result = Misc.splitAndRotate(img, sX, sY);
        img.flush();
        return result;
    }

    public static BufferedImage[][] splitAndRotate(Image img, int sX, int sY) {
        if (img != null && sX > 0 && sY > 0) {
            BufferedImage[] splitted = Misc.loadImages(img, sX, sY);
            int iC = splitted.length;
            BufferedImage[][] result = new BufferedImage[iC][4];
            int i = 0;
            while (i < iC) {
                int i2 = 0;
                while (i2 < 4) {
                    result[i][i2] = Misc.easyRotate(splitted[i], i2);
                    ++i2;
                }
                splitted[i].flush();
                ++i;
            }
            return result;
        }
        return img == null ? null : new BufferedImage[0][0];
    }

    public static BufferedImage[][] loadImages2(String imgPath, int w, int h) {
        BufferedImage s = Misc.loadImage(imgPath);
        BufferedImage[][] imgs = Misc.loadImages2(s, w, h);
        s.flush();
        return imgs;
    }

    public static BufferedImage[][] loadImages2(Image img, int w, int h) {
        BufferedImage[] imgs = Misc.loadImages(img, w, h);
        BufferedImage[][] imgs2 = new BufferedImage[w][h];
        int i = 0;
        while (i < imgs.length) {
            imgs2[i % w][i / w] = imgs[i];
            ++i;
        }
        return imgs2;
    }

    public static boolean makeScreenshot(Component c, String path) {
        boolean did = true;
        BufferedImage ssImg = new BufferedImage(c.getWidth(), c.getHeight(), 1);
        Graphics2D g = ssImg.createGraphics();
        c.paint(g);
        try {
            Misc.createDirs(path);
            ImageIO.write((RenderedImage)ssImg, "png", new File(String.valueOf(path) + System.currentTimeMillis() + ".png"));
        }
        catch (Exception ex) {
            did = false;
        }
        g.dispose();
        ssImg.flush();
        return did;
    }

    public static String base64encode(byte[] buf) {
        int size = buf.length;
        char[] ar = new char[(size + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < size) {
            byte b0 = buf[i++];
            byte b1 = i < size ? buf[i++] : (byte)0;
            byte b2 = i < size ? buf[i++] : (byte)0;
            int mask = 63;
            ar[a++] = ALPHABET[b0 >> 2 & mask];
            ar[a++] = ALPHABET[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = ALPHABET[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = ALPHABET[b2 & mask];
        }
        switch (size % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    public static byte[] base64decode(String s) {
        int delta = s.endsWith("==") ? 2 : (s.endsWith("=") ? 1 : 0);
        byte[] buffer = new byte[s.length() * 3 / 4 - delta];
        int mask = 255;
        int index = 0;
        int i = 0;
        while (i < s.length()) {
            int c0 = toInt[s.charAt(i)];
            int c1 = toInt[s.charAt(i + 1)];
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c2 = toInt[s.charAt(i + 2)];
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c3 = toInt[s.charAt(i + 3)];
            buffer[index++] = (byte)((c2 << 6 | c3) & mask);
            i += 4;
        }
        return buffer;
    }

    public static String[] loadFileAsStringArray(String path) {
        InputStream in = Misc.getFileAsInputStream(path);
        if (in == null) {
            return new String[0];
        }
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            in.close();
        }
        catch (Exception br) {
            // empty catch block
        }
        String[] strings = new String[lines.size()];
        lines.toArray(strings);
        return strings;
    }

    public static byte[] loadFileAsByteArray(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (Exception e) {
            return null;
        }
        DataInputStream dis = new DataInputStream(fis);
        byte[] bar = new byte[(int)file.length()];
        try {
            dis.readFully(bar);
        }
        catch (IOException e) {
            bar = null;
        }
        try {
            dis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bar;
    }

    public static int checkRange(int num, int min, int max) {
        return num < min ? min : (num > max ? max : num);
    }

    public static int[] range(int end) {
        return Misc.range(0, end);
    }

    public static int[] range(int start, int end) {
        if (++end - start <= 0) {
            return new int[0];
        }
        int[] range = new int[end - start];
        int i = start;
        while (i < end) {
            range[i - start] = i;
            ++i;
        }
        return range;
    }

    public static String[] stringRange(int start, int end, String pre, String post) {
        int num;
        if ((num = ++end - start) <= 0) {
            return new String[0];
        }
        String[] range = new String[num];
        int i = 0;
        while (i < num) {
            range[i] = String.valueOf(pre) + (start + i) + post;
            ++i;
        }
        return range;
    }

    public static InputStream getResource(String path) {
        return Misc.class.getResourceAsStream(path);
    }

    public static String[] intArrayToStringArray(int[] ints) {
        String[] strs = new String[ints.length];
        int i = 0;
        while (i < strs.length) {
            strs[i] = "" + ints[i];
            ++i;
        }
        return strs;
    }

    public static int pow(int v, int c) {
        --c;
        int t = v;
        int i = 0;
        while (i < c) {
            t *= v;
            ++i;
        }
        return t;
    }

    public static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                try {
                    Misc.delete(c);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ++n2;
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Couldn't delete " + f);
        }
    }
}

