/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.server.objects;

import com.iosoft.fgalpha.server.objects.Assault;
import com.iosoft.fgalpha.server.objects.GameObj;
import com.iosoft.fgalpha.server.objects.Player;
import com.iosoft.fgalpha.server.objects.Projectile;
import com.iosoft.fgalpha.server.objects.Shotgun;
import com.iosoft.fgalpha.server.objects.Sniper;
import com.iosoft.fgalpha.server.objects.SoundEmitter;

public abstract class Weapon
extends GameObj {
    protected Player owner;
    protected Player wielder;
    protected int reload;
    protected int ammo;
    protected int delay = this.getDelay();

    public Weapon() {
        this.ammo = this.getAmmo();
    }

    public void spawnbind(Player p) {
        this.owner = p;
        this.wielder = p;
        if (p.extras[2]) {
            this.ammo += this.getBonusAmmo();
        }
    }

    public void onPickup(Player p) {
        this.wielder = p;
        if (this.owner == null) {
            this.owner = this.wielder;
        }
    }

    public void onDrop() {
        this.wielder = null;
        this.exists = false;
    }

    public int getReloadDelay() {
        return 20;
    }

    public boolean isAutomatic() {
        return false;
    }

    public boolean shoot() {
        if (this.delay == 0 && this.reload == 0 && this.ammo > 0) {
            --this.ammo;
            this.delay = this.getDelay();
            if (this.ammo == 0) {
                this.reload = this.getReload();
                new SoundEmitter(this.getReloadSound(), this.getReloadDelay(), this, 500.0f);
            }
            srv.playSoundPos(this.getShotSound(), 0.7f, this.pos.x, this.pos.y, 800.0f);
            double hardDistance = 5.0;
            if (!(this instanceof Assault)) {
                new SoundEmitter(this.getShellSound(), 10, this, 700.0f);
            }
            double spread = this.getSpread();
            if (this.wielder != null && this.wielder.extras[1]) {
                spread = this.getReducedSpread();
            }
            int damage = this.getDamage();
            Player p = this.getHolder();
            if (p != null && p.extras[4]) {
                damage = (int)((double)damage * 1.3);
                if (this instanceof Sniper) {
                    hardDistance += 45.0;
                }
            }
            if (this instanceof Shotgun) {
                int i = 0;
                while (i < 6) {
                    new Projectile(damage, this.pos, this.rotation - spread / 2.0 + Math.random() * spread, 40.0 + Math.random() * 10.0, this, hardDistance);
                    ++i;
                }
            } else {
                new Projectile(damage, this.pos, this.rotation - spread / 2.0 + Math.random() * spread, this instanceof Sniper ? 70.0 : 50.0, this, hardDistance);
            }
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        if (this.owner != null && !this.owner.exists) {
            this.owner = null;
        }
        if (this.wielder != null && !this.wielder.exists) {
            this.wielder = null;
        }
        if (this.delay > 0) {
            --this.delay;
        }
        if (this.wielder != null && this.reload > 0) {
            --this.reload;
            if (this.reload == 0) {
                this.ammo = this.getAmmo() + (this instanceof Assault && this.ammo > 0 ? 1 : 0);
                Player p = this.getHolder();
                if (p != null && p.extras[2]) {
                    this.ammo += this.getBonusAmmo();
                }
            }
            srv.sendToAll(srv.msgSetPlayerData(this.wielder));
        }
    }

    public int getBonusAmmo() {
        return 1;
    }

    public int getShellSound() {
        return 0;
    }

    public int getReloadSound() {
        return 0;
    }

    public int getShotSound() {
        return 0;
    }

    public double getSpread() {
        return 0.1;
    }

    public double getReducedSpread() {
        return 0.0;
    }

    public int getReload() {
        return 50;
    }

    public int getAmmo() {
        return 3;
    }

    public int getDelay() {
        return 3;
    }

    public int getDamage() {
        return 34;
    }

    public abstract int getID();

    public double getSpeed() {
        return 5.0;
    }

    @Override
    public boolean serverside() {
        return true;
    }

    @Override
    public int getObjClassID() {
        return -1;
    }

    public Player getHolder() {
        if (this.wielder != null && this.wielder.exists) {
            return this.wielder;
        }
        if (this.owner != null && this.owner.exists) {
            return this.owner;
        }
        return null;
    }
}

