/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.server.objects;

import com.iosoft.fgalpha.server.objects.Client;
import com.iosoft.fgalpha.server.objects.GameObj;
import com.iosoft.fgalpha.server.objects.Player;
import com.iosoft.fgalpha.server.objects.Weapon;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.Vector2D;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Projectile
extends GameObj {
    Weapon weapon;
    Player shooter;
    boolean hitFlesh = false;
    int damage;
    int team = -1;
    int hitmarkerCount = 0;
    double hardDistanceLeft;
    List<Player> hits = new ArrayList<Player>();

    public Projectile(int damage, Vector2D s, double rotation, double speed, Weapon weapon, double hardDistance) {
        this.pos.x = s.x;
        this.pos.y = s.y;
        this.hardDistanceLeft = hardDistance;
        this.damage = damage;
        this.rotation = rotation;
        this.weapon = weapon;
        this.vel.x = Math.cos(rotation) * speed;
        this.vel.y = Math.sin(rotation) * speed;
        if (weapon != null) {
            this.vel.x += weapon.vel.x;
            this.vel.y += weapon.vel.y;
            Player p = weapon.getHolder();
            if (p != null) {
                this.shooter = p;
                this.team = p.team;
            }
        } else {
            damage = 0;
        }
        srv.sendToAll(srv.msgAddObj(this));
    }

    @Override
    public void tick() {
        this.changedPos = true;
        int iC = Projectile.map.objs.size();
        int steps = (int)Math.ceil(this.vel.getLength());
        if (steps > 0) {
            double dx = this.vel.x / (double)steps;
            double dy = this.vel.y / (double)steps;
            double ddis = Math.sqrt(dx * dx + dy * dy);
            int i = 0;
            while (i < steps) {
                int j = 0;
                while (j < iC) {
                    GameObj o = Projectile.map.objs.get(j);
                    if (o.exists && o instanceof Player && (this.weapon == null || o != this.weapon.wielder)) {
                        Player p = (Player)o;
                        if (!p.dead && this.pos.getDist(p.pos) < 10.0 && !this.hits.contains(p) && (srv.getGamemode() == 0 || srv.getGamemode() == 1 && (srv.getFF() || this.shooter == null || p.team != this.team))) {
                            p.hurt(this.damage, this.pos, this.vel, this);
                            this.hitFlesh = true;
                            srv.playSoundPos(this.getImpactSound(false), 1.0f, this.pos.x, this.pos.y, 400.0f);
                            ++this.hitmarkerCount;
                            if (this.shooter != null && this.shooter.exists && this.shooter instanceof Client) {
                                Client c = (Client)this.shooter;
                                c.send(srv.msgHitmarker(this.hitmarkerCount));
                            }
                            this.hits.add(p);
                        }
                    }
                    ++j;
                }
                boolean ok = map.ok2Go(this.pos.x + dx, this.pos.y + dy, true, null);
                if (ok || this.hardDistanceLeft > 0.0) {
                    this.pos.x += dx;
                    this.pos.y += dy;
                    if (!ok) {
                        this.hardDistanceLeft -= ddis;
                        if (this.hardDistanceLeft < 0.0) {
                            this.hardDistanceLeft = 0.0;
                        }
                    }
                } else {
                    if (!this.hitFlesh) {
                        srv.playSoundPos(this.getImpactSound(true), 1.0f, this.pos.x, this.pos.y, 400.0f);
                    }
                    this.exists = false;
                    return;
                }
                ++i;
            }
        }
    }

    public void addKill(int kills) {
        if (this.weapon != null) {
            if (this.weapon.wielder != null) {
                this.weapon.wielder.kills += kills;
                srv.sendToAll(srv.msgSetPlayerData(this.weapon.wielder));
            } else if (this.weapon.owner != null) {
                this.weapon.owner.kills += kills;
                srv.sendToAll(srv.msgSetPlayerData(this.weapon.owner));
            }
        }
    }

    public int getImpactSound(boolean wall) {
        if (wall) {
            switch (Misc.getRandomInt(4)) {
                case 0: {
                    return 19;
                }
                case 1: {
                    return 20;
                }
                case 2: {
                    return 21;
                }
                case 3: {
                    return 22;
                }
            }
        } else {
            switch (Misc.getRandomInt(4)) {
                case 0: {
                    return 15;
                }
                case 1: {
                    return 16;
                }
                case 2: {
                    return 17;
                }
                case 3: {
                    return 18;
                }
            }
        }
        return 0;
    }

    @Override
    public void allInfo(DataOutputStream dos) throws IOException {
        super.allInfo(dos);
    }

    @Override
    public int getObjClassID() {
        return 2;
    }

    public Player getShooter() {
        return this.shooter;
    }
}

