/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.server.objects;

import com.iosoft.fgalpha.server.FGAServer;
import com.iosoft.fgalpha.server.Map;
import com.iosoft.fgalpha.server.objects.SoundEmitter;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.Vector2D;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class GameObj {
    protected List<SoundEmitter> sounds;
    public static Map map;
    public static FGAServer srv;
    public Vector2D pos;
    public Vector2D vel;
    public double rotation;
    protected boolean exists;
    protected boolean visible;
    protected boolean changedPos;
    public final int id = this.getNewID();

    public GameObj() {
        this.sounds = new ArrayList<SoundEmitter>();
        GameObj.map.objs.add(this);
        this.exists = true;
        this.pos = new Vector2D(0.0, 0.0);
        this.vel = new Vector2D(0.0, 0.0);
        this.visible = true;
        this.changedPos = true;
    }

    public boolean changedPos() {
        return this.changedPos;
    }

    public void resetChangedPos() {
        this.changedPos = false;
    }

    public void tick() {
    }

    public short getRotationForClient() {
        this.rotation = Misc.normalizeRotation(this.rotation);
        return (short)(this.rotation / (Math.PI * 2) * 32767.0);
    }

    public boolean exists() {
        return this.exists;
    }

    public void onRemove() {
        if (!this.serverside()) {
            srv.sendToAll(srv.msgRemoveObj(this));
        }
    }

    public boolean serverside() {
        return false;
    }

    private int getNewID() {
        int i = 0;
        while (map.getObjByID(i) != null) {
            ++i;
        }
        return i;
    }

    public void allInfo(DataOutputStream dos) throws IOException {
        dos.write(this.getObjClassID());
        dos.writeInt(this.id);
        dos.writeFloat((float)this.pos.x);
        dos.writeFloat((float)this.pos.y);
        dos.writeShort(this.getRotationForClient());
        dos.writeByte(Misc.buildByte(this.visible));
    }

    public abstract int getObjClassID();
}

