/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.server;

import com.iosoft.fgalpha.server.FGAServer;
import com.iosoft.fgalpha.server.objects.Client;
import com.iosoft.fgalpha.server.objects.GameObj;
import com.iosoft.fgalpha.server.objects.Medkit;
import com.iosoft.fgalpha.server.objects.Player;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.Vector2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;

public class Map {
    public String name;
    public String uiName;
    public byte[][] map;
    public Spawn[] spawns;
    public Spawn[] teamspawns;
    private Rectangle[] worldCollBox;
    public List<GameObj> objs;
    public List<Player> players = new ArrayList<Player>();
    private int timeToNextMedkit = 25;
    private Medkit medkit;
    public FGAServer srv;

    public Map(String source) throws Exception {
        int j;
        this.objs = new ArrayList<GameObj>();
        String[] sa = Misc.loadFileAsStringArray("/res/server/maps/" + source + ".txt");
        if (sa == null || sa.length == 0) {
            sa = Misc.loadFileAsStringArray("maps/" + source + ".txt");
        }
        this.uiName = sa[1];
        this.name = source;
        int w = Misc.getAsInt(sa[4]);
        int h = Misc.getAsInt(sa[5]);
        this.map = new byte[w][h];
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                char c = sa[8 + y].charAt(x);
                this.map[x][y] = (byte)Misc.getAsInt("" + c);
                ++x;
            }
            ++y;
        }
        int nSpawns = Misc.getAsInt(sa[8 + h + 2]);
        this.spawns = new Spawn[nSpawns];
        int i = 0;
        while (i < nSpawns) {
            String coords = sa[8 + h + 3 + i];
            j = coords.indexOf(44);
            this.spawns[i] = new Spawn(Misc.getAsInt(coords.substring(0, j)), Misc.getAsInt(coords.substring(j + 1)));
            ++i;
        }
        this.teamspawns = new Spawn[2];
        i = 0;
        while (i < this.teamspawns.length) {
            String coords = sa[13 + h + i + nSpawns];
            j = coords.indexOf(44);
            this.teamspawns[i] = new Spawn(Misc.getAsInt(coords.substring(0, j)), Misc.getAsInt(coords.substring(j + 1)));
            ++i;
        }
        ArrayList<Rectangle> collBoxes = new ArrayList<Rectangle>();
        boolean[][] collBoxFilled = new boolean[w][h];
        int y2 = 0;
        while (y2 < h) {
            int x = 0;
            while (x < w) {
                if (!(this.map[x][y2] != 1 && this.map[x][y2] != 2 || collBoxFilled[x][y2])) {
                    int biggestW = 1;
                    int biggestH = 1;
                    int biggest = 1;
                    int size = 1;
                    int wW = 1;
                    int wH = 1;
                    while (true) {
                        if (this.canGetWall(x, y2, wW, wH + 1, collBoxFilled)) {
                            if ((size = wW * ++wH) <= biggest) continue;
                            biggestW = wW;
                            biggestH = wH;
                            continue;
                        }
                        if (!this.canGetWall(x, y2, wW + 1, wH, collBoxFilled)) break;
                        if ((size = ++wW * wH) <= biggest) continue;
                        biggestW = wW;
                        biggestH = wH;
                    }
                    collBoxes.add(new Rectangle(x * 50, y2 * 50, biggestW * 50, biggestH * 50));
                    int jx = 0;
                    while (jx < biggestW) {
                        int jy = 0;
                        while (jy < biggestH) {
                            collBoxFilled[x + jx][y2 + jy] = true;
                            ++jy;
                        }
                        ++jx;
                    }
                }
                ++x;
            }
            ++y2;
        }
        collBoxes.add(new Rectangle(-10, -10, w * 50 + 20, 10));
        collBoxes.add(new Rectangle(-10, h * 50, w * 50 + 20, 10));
        collBoxes.add(new Rectangle(-10, 0, 10, h * 50));
        collBoxes.add(new Rectangle(w * 50, 0, 10, h * 50));
        this.worldCollBox = new Rectangle[collBoxes.size()];
        collBoxes.toArray(this.worldCollBox);
    }

    private boolean canGetWall(int sx, int sy, int w, int h, boolean[][] fill) {
        int x = sx;
        while (x < sx + w) {
            if (x >= this.map.length) {
                return false;
            }
            int y = sy;
            while (y < sy + h) {
                if (y >= this.map[0].length || this.map[x][y] != 1 && this.map[x][y] != 2 || fill[x][y]) {
                    return false;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    public GameObj getObjByID(int id) {
        int iC = this.objs.size();
        int i = 0;
        while (i < iC) {
            GameObj o = this.objs.get(i);
            if (o.id == id) {
                return o;
            }
            ++i;
        }
        return null;
    }

    public void tick() {
        int i = 0;
        while (i < this.objs.size()) {
            this.objs.get(i).resetChangedPos();
            ++i;
        }
        i = 0;
        while (i < this.objs.size()) {
            GameObj obj = this.objs.get(i);
            if (!obj.exists()) {
                obj.onRemove();
                this.objs.remove(i);
                --i;
            } else {
                obj.tick();
                if (!obj.exists()) {
                    obj.onRemove();
                    this.objs.remove(i);
                    --i;
                }
            }
            ++i;
        }
        if (this.medkit != null && !this.medkit.exists()) {
            this.medkit = null;
            this.timeToNextMedkit = 70 + Misc.getRandomInt(50);
        }
        if (this.timeToNextMedkit > 0) {
            --this.timeToNextMedkit;
            if (this.timeToNextMedkit == 0) {
                this.medkit = new Medkit();
            }
        }
    }

    public boolean ok2Go(double x, double y, Shape collBox) {
        return this.ok2Go(x, y, false, collBox);
    }

    public boolean ok2Go(double x, double y, boolean bullet, Shape collBox) {
        if (collBox != null) {
            int iC = this.worldCollBox.length;
            int i = 0;
            while (i < iC) {
                if (collBox.intersects(this.worldCollBox[i])) {
                    return false;
                }
                ++i;
            }
        }
        if (x < 0.0 || y < 0.0 || x > (double)this.map.length * 50.0 || y > (double)this.map[0].length * 50.0) {
            return false;
        }
        byte b = this.map[(int)(x / 50.0)][(int)(y / 50.0)];
        return b == 0 || b == 3 || bullet && b == 2;
    }

    public void randomSpawn(Player p) {
        if (this.srv.getGamemode() == 1) {
            Player pl;
            ArrayList<Player> playerspawns = new ArrayList<Player>();
            int iC = this.objs.size();
            int i = 0;
            while (i < iC) {
                GameObj o = this.objs.get(i);
                if (o instanceof Player && p != (pl = (Player)o) && pl.exists() && pl.isConnected() && !pl.isDead() && pl.getTeam() == p.getTeam()) {
                    playerspawns.add(pl);
                }
                ++i;
            }
            if (playerspawns.size() == 0) {
                int team = p.getTeam();
                if (team < 0) {
                    team = 0;
                } else if (team > 1) {
                    team = 1;
                }
                p.pos.x = (double)this.teamspawns[team].x * 50.0 + 5.0 + Math.random() * 40.0;
                p.pos.y = (double)this.teamspawns[team].y * 50.0 + 5.0 + Math.random() * 40.0;
            } else {
                pl = (Player)playerspawns.get(Misc.getRandomInt(playerspawns.size()));
                p.pos.x = Math.floor(pl.pos.x / 50.0) * 50.0 + 5.0 + Math.random() * 40.0;
                p.pos.y = Math.floor(pl.pos.y / 50.0) * 50.0 + 5.0 + Math.random() * 40.0;
            }
        } else {
            if (this.spawns == null || this.spawns.length == 0) {
                p.pos.x = 0.0;
                p.pos.y = 0.0;
                System.out.println("No spawns -> 0,0");
                return;
            }
            Spawn s = this.spawns[Misc.getRandomInt(this.spawns.length)];
            p.pos.x = (double)s.x * 50.0 + 5.0 + Math.random() * 40.0;
            p.pos.y = (double)s.y * 50.0 + 5.0 + Math.random() * 40.0;
        }
    }

    public int countNonServersided() {
        int n = 0;
        int iC = this.objs.size();
        int i = 0;
        while (i < iC) {
            if (!this.objs.get(i).serverside()) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public int getWeakerTeam(Player pl) {
        int t1 = 0;
        int t2 = 0;
        int iC = this.objs.size();
        int i = 0;
        while (i < iC) {
            Player p;
            GameObj o = this.objs.get(i);
            if (o instanceof Player && pl != (p = (Player)o) && p.exists() && p.isConnected()) {
                if (p.getTeam() == 0) {
                    ++t1;
                } else {
                    ++t2;
                }
            }
            ++i;
        }
        return t1 < t2 ? 0 : (t1 > t2 ? 1 : Misc.getRandomInt(2));
    }

    public boolean isRoad(Vector2D pos) {
        if (pos.x >= 0.0 && pos.y >= 0.0 && pos.x < (double)this.map.length * 50.0 && pos.y < (double)this.map[0].length * 50.0) {
            return this.map[(int)pos.x / 50][(int)pos.y / 50] == 3;
        }
        return false;
    }

    public Player getPlayerByName(Client client, String name2) {
        int iC = this.objs.size();
        int i = 0;
        while (i < iC) {
            Player p;
            GameObj o = this.objs.get(i);
            if (o.exists() && o != client && o instanceof Player && (p = (Player)o).getName().equals(name2)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public Player getPlayerByNr(int nr) {
        int iC = this.objs.size();
        int i = 0;
        while (i < iC) {
            Player p;
            GameObj o = this.objs.get(i);
            if (o.exists() && o instanceof Player && (p = (Player)o).getNr() == nr) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public static class PathNode {
    }

    public class Spawn {
        public int x;
        public int y;

        public Spawn(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

