/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.client.objects;

import com.iosoft.fgalpha.client.objects.ClientObj;
import com.iosoft.fgalpha.client.ui.MediaLib;
import com.iosoftware.helpers.Misc;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.IOException;

public class Player
extends ClientObj {
    public int weapon = 0;
    public int ping;
    public int nr = -1;
    public int kills = 0;
    public int deaths = 0;
    public int assists = 0;
    public int hp = 0;
    public int ammo = 0;
    public int reload = 0;
    public int team = 0;
    public int extra = 0;
    public boolean ai;
    public boolean connected = true;
    public boolean dead = true;
    public boolean me = false;
    public boolean protection = false;
    public boolean[] extras = new boolean[8];
    public String name = "";

    @Override
    public void setPos(double x, double y, double rot) {
        super.setPos(x, y, rot);
        if (this.me) {
            Player.gs.renderAt.x = (int)this.pos.x;
            Player.gs.renderAt.y = (int)this.pos.y;
        }
    }

    public void makeExtra() {
        int e = 255;
        int i = 0;
        while (i < this.extras.length) {
            if (this.extras[i]) {
                e = i;
                break;
            }
            ++i;
        }
        this.extra = e;
    }

    @Override
    public void init(DataInputStream in) throws IOException {
        super.init(in);
        this.nr = Misc.read(in);
        this.name = Misc.getString(in, 16);
        boolean[] bools = Misc.readByte(in.readByte());
        this.dead = bools[0];
        this.connected = bools[1];
        this.ai = bools[2];
        this.protection = bools[3];
        this.team = bools[4] ? 1 : 0;
        this.weapon = Misc.read(in);
        this.extras = Misc.readBytes(in, -1, 8);
        this.makeExtra();
        this.hp = Misc.read(in);
        this.ammo = Misc.read(in);
        this.reload = Misc.read(in);
        this.kills = in.readInt();
        this.assists = in.readInt();
        this.deaths = in.readInt();
        if (this.connected) {
            gs.addChatMsg(255, String.valueOf(this.name) + " has joined the game!");
        }
    }

    @Override
    public void render(Graphics2D g) {
        if (this.connected && !this.dead) {
            int head = this.headByWeapon();
            int body = this.bodyByWeapon();
            int wpn = this.wpnByWeapon();
            if (Player.gs.gamemode == 1) {
                g.drawImage((Image)MediaLib.team[this.team], -25, -25, null);
            }
            if (this.protection) {
                g.setColor(Color.CYAN);
                g.drawOval(-25, -25, 50, 50);
            }
            g.drawImage((Image)MediaLib.objects[body][1], -25, -25, null);
            g.drawImage((Image)MediaLib.objects[wpn][7], -15, -25 + (this.weapon == 1 ? 7 : 0), null);
            g.drawImage((Image)MediaLib.objects[head][0], -25, -25, null);
            g.setFont(MediaLib.fontPlayer);
            g.setColor(Color.BLACK);
            g.rotate(-this.rotation, 0.0, 0.0);
            Misc.drawCenteredString(this.name, -50, -30, 100, 10, g);
        }
    }

    private int headByWeapon() {
        switch (this.weapon) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 2;
            }
        }
        return 4;
    }

    private int bodyByWeapon() {
        switch (this.weapon) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 5;
            }
        }
        return 1;
    }

    private int wpnByWeapon() {
        switch (this.weapon) {
            case 0: {
                return 6;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 8;
            }
        }
        return 4;
    }
}

