/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.client;

import com.iosoft.fgalpha.FightgameAlpha;
import com.iosoft.fgalpha.Protocol;
import com.iosoft.fgalpha.client.DisconnectReason;
import com.iosoft.fgalpha.client.Gamestate;
import com.iosoft.fgalpha.client.objects.ClientObj;
import com.iosoft.fgalpha.client.objects.Player;
import com.iosoft.fgalpha.client.ui.MediaLib;
import com.iosoft.fgalpha.client.ui.UserInterface;
import com.iosoft.fgalpha.server.FGAServer;
import com.iosoftware.helpers.DataHelper;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.Ticker;
import com.iosoftware.helpers.network.Connecter;
import com.iosoftware.helpers.network.Connection;
import com.iosoftware.helpers.network.LocalConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class FGAClient {
    private static final int TIMEOUT_GREETING = 750;
    private static final int TIMEOUT_MSGS = 750;
    private boolean running;
    private String name;
    private int team;
    private int extra;
    private int weapon;
    private final Object lock = FightgameAlpha.lock;
    private final Gamestate gs;
    private ConnectionState connectionState;
    private ClientConnection connection;
    private Connecter connecter;
    private DataHelper dh = new DataHelper();
    private DataOutputStream dos = this.dh.getStream();
    private int timeout;
    private Ticker ticker;
    private static FGAClient inst;

    public static FGAClient get() {
        if (inst == null) {
            inst = new FGAClient();
        }
        return inst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FGAClient() {
        Object object = this.lock;
        synchronized (object) {
            this.gs = new Gamestate(this.lock);
            this.name = Misc.getComputerName();
            this.connectionState = ConnectionState.NOT_CONNECTED;
            this.ticker = new Ticker("Client Ticker", 25L, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = FGAClient.this.lock;
                        synchronized (object) {
                            if (FGAClient.this.running) {
                                FGAClient.this.gs.tick();
                                if (FGAClient.this.connectionState == ConnectionState.WAIT_FOR_GREETING || FGAClient.this.connectionState == ConnectionState.PLAYING) {
                                    FGAClient fGAClient = FGAClient.this;
                                    fGAClient.timeout = fGAClient.timeout - 1;
                                    if (FGAClient.this.timeout <= 0) {
                                        System.out.println("Server timed out");
                                        FGAClient.this.clientDisconnect(DisconnectReason.TIMEOUT);
                                    }
                                    if (FGAClient.this.connectionState == ConnectionState.PLAYING) {
                                        UserInterface.get().drawGame();
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        UserInterface.onError(ex);
                    }
                }
            });
            this.ticker.start(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.lock;
        synchronized (object) {
            this.reinit();
            UserInterface.get().init(this.gs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinit() {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            this.connection = null;
            this.connecter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String name, int weapon, int extra, int team, String ip, int port) {
        Object object = this.lock;
        synchronized (object) {
            FightgameAlpha.get().setJoinOptions(name, weapon, extra, team, ip, port);
            this.name = name;
            this.weapon = weapon;
            this.extra = extra;
            this.team = team;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendLoadout() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionState == ConnectionState.PLAYING) {
                if (this.weapon > 3 || this.weapon < 0) {
                    this.chat("/randomweapon");
                } else {
                    this.chat("/weapon " + this.weapon);
                }
                if (this.extra > 5 || this.extra < 0) {
                    this.chat("/randomextra");
                } else {
                    this.chat("/extra " + this.extra);
                }
                if (this.gs.gamemode == 1 && this.team > 0 && this.gs.me.team != this.team - 1) {
                    this.chat("/changeteam");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalConnection connectToSelf() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                this.gs.reset();
                this.gs.serverLocal = true;
                this.gs.serverIP = Misc.getIP();
                this.gs.serverPort = FGAServer.get().getPort();
                this.gs.serverNodelay = false;
                this.gs.serverVersion = "?";
                UserInterface.get().setConnectionStep(1);
                this.reinit();
                this.running = true;
                this.connectionState = ConnectionState.CONNECTING;
                try {
                    PipedOutputStream out = new PipedOutputStream();
                    PipedInputStream in = new PipedInputStream();
                    LocalConnection locConClient = new LocalConnection(out, in);
                    this.connection = new ClientConnection();
                    this.connection.setBuffered(true);
                    this.connection.setPrefix("Client");
                    PipedOutputStream serverOut = new PipedOutputStream(in);
                    PipedInputStream serverIn = new PipedInputStream(out);
                    this.connection.bind(locConClient);
                    LocalConnection locConServer = new LocalConnection(serverOut, serverIn);
                    this.onConnect();
                    System.out.println("Client returns LocalConnection...");
                    return locConServer;
                }
                catch (Exception ex) {
                    this.clientDisconnect(DisconnectReason.STREAM_PIPE_ERROR);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortConnecting() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                System.out.println("Aborting connection process...");
                this.clientDisconnect(DisconnectReason.CANCELED);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String ip, int port) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                boolean tcpNodelay = true;
                System.out.println("Client: Trying to connect to " + ip + ":" + port + " WITH " + (!tcpNodelay ? "NO " : "") + "nodelay");
                this.gs.reset();
                this.gs.serverLocal = false;
                this.gs.serverIP = ip;
                this.gs.serverPort = port;
                this.gs.serverNodelay = tcpNodelay;
                this.gs.serverVersion = "?";
                UserInterface.get().setConnectionStep(1);
                this.reinit();
                this.running = true;
                this.connectionState = ConnectionState.CONNECTING;
                this.connecter = new Connecter(ip, port, tcpNodelay, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = FGAClient.this.lock;
                        synchronized (object) {
                            System.out.println("Client Connecter returned: " + FGAClient.this.connecter.getState());
                            switch (FGAClient.this.connecter.getState()) {
                                case 2: {
                                    FGAClient.this.connection = new ClientConnection();
                                    FGAClient.this.connection.setBuffered(true);
                                    FGAClient.this.connection.setPrefix("Client");
                                    FGAClient.this.connection.bind(FGAClient.this.connecter.getSocket());
                                    FGAClient.this.onConnect();
                                    break;
                                }
                                case 1: {
                                    FGAClient.this.clientDisconnect(DisconnectReason.UNKNOWN_START_ERROR);
                                    break;
                                }
                                case 3: {
                                    FGAClient.this.clientDisconnect(DisconnectReason.CONNECTION_ERROR);
                                    break;
                                }
                                case 4: {
                                    FGAClient.this.clientDisconnect(DisconnectReason.CONNECTING_FAILED);
                                    break;
                                }
                                case 0: {
                                    FGAClient.this.clientDisconnect(DisconnectReason.UNKNOWN);
                                }
                                case 5: {
                                    FGAClient.this.clientDisconnect(DisconnectReason.CANCELED);
                                }
                            }
                            FGAClient.this.connecter = null;
                        }
                    }
                });
                this.connecter.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(byte[] data) {
        Object object = this.lock;
        synchronized (object) {
            this.connection.send(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onConnect() {
        Object object = this.lock;
        synchronized (object) {
            System.out.println("Client onConnected called!");
            UserInterface.get().setConnectionStep(2);
            this.connectionState = ConnectionState.WAIT_FOR_GREETING;
            this.send(this.msgGreeting());
            this.timeout = 750;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] msgGreeting() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(1);
                this.dos.writeBytes("FGA Client");
                this.dos.write(Misc.stringToBytes("v0.3.0", 10));
                this.dos.write(Misc.stringToBytes(this.name.trim(), 16));
                this.dos.write(this.weapon);
                this.dos.write(this.extra);
                this.dos.write(this.team);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] msgPinganswer() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(2);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] msgChat(String msg) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(3);
                msg = Misc.trimString(msg, 255);
                this.dos.write(msg.length());
                this.dos.write(Misc.stringToBytes(msg));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] msgAction(int key, int action) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(4);
                this.dos.write(key);
                this.dos.write(action);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] msgMouseAction(short x, short y) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(5);
                this.dos.writeShort(x);
                this.dos.writeShort(y);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionState == ConnectionState.PLAYING) {
                this.clientDisconnect(DisconnectReason.QUIT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action(int key, int action) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionState == ConnectionState.PLAYING) {
                this.send(this.msgAction(key, action));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseAction(int x, int y) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionState == ConnectionState.PLAYING) {
                this.send(this.msgMouseAction((short)x, (short)y));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chat(String msg) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionState == ConnectionState.PLAYING) {
                this.send(this.msgChat(msg.trim()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientDisconnect(DisconnectReason reason) {
        Object object = this.lock;
        synchronized (object) {
            System.out.println("clientDisconnect called " + (Object)((Object)reason));
            this.running = false;
            if (this.connectionState == ConnectionState.CONNECTING || this.connectionState == ConnectionState.WAIT_FOR_GREETING || this.connectionState == ConnectionState.PLAYING) {
                System.out.println("Client clientDisconnect executed! " + (Object)((Object)reason));
                this.connectionState = ConnectionState.NOT_CONNECTED;
                if (this.connection != null) {
                    this.connection.disconnect();
                    this.connection = null;
                }
                if (this.connecter != null) {
                    this.connecter.abort();
                    this.connecter = null;
                }
                FGAServer.get().stop();
                UserInterface.get().setDisconnected(reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNetworkError() {
        Object object = this.lock;
        synchronized (object) {
            this.clientDisconnect(DisconnectReason.NETWORK_FAILED);
        }
    }

    private class ClientConnection
    extends Connection {
        private ClientConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onDisconnected() {
            Object object = FGAClient.this.lock;
            synchronized (object) {
                System.out.println("Receiver quits");
                FGAClient.this.clientDisconnect(DisconnectReason.CONNECTION_LOST);
            }
        }

        private boolean checkGreeting() {
            if (FGAClient.this.connectionState == ConnectionState.WAIT_FOR_GREETING) {
                System.out.println("Server sent a message but hasn't greeted yet!");
                FGAClient.this.clientDisconnect(DisconnectReason.ERROR);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void receiving(InputStream pin) throws Exception {
            DataInputStream in = new DataInputStream(pin);
            try {
                int msgType;
                block95: while (true) {
                    msgType = Misc.read(in);
                    switch (msgType) {
                        case 127: {
                            String sVerify = Misc.getString(in, "FGA Server".length());
                            String sVersion = Misc.getString(in, 10);
                            UserInterface.get().setConnectionStep(3);
                            int iPlayers = Misc.read(in);
                            int iUser = Misc.read(in);
                            int iGamemode = Misc.read(in);
                            boolean[] bools = Misc.readByte(in.readByte());
                            int iMapLength = Misc.read(in);
                            String sMapname = Misc.getString(in, iMapLength);
                            if (!MediaLib.loadMap(sMapname)) {
                                FGAClient.this.clientDisconnect(DisconnectReason.NO_MAP);
                                this.loopAndDispose(in);
                            }
                            int iMapLength2 = Misc.read(in);
                            String sMapname2 = Misc.getString(in, iMapLength2);
                            int iC = in.readInt();
                            ClientObj[] objs = new ClientObj[iC];
                            int i = 0;
                            while (i < iC) {
                                objs[i] = ClientObj.create(Misc.read(in), in);
                                ++i;
                            }
                            Object object = FGAClient.this.lock;
                            synchronized (object) {
                                if (FGAClient.this.connectionState != ConnectionState.WAIT_FOR_GREETING) {
                                    System.out.println("Server sent greeting but has greeted already!");
                                    FGAClient.this.clientDisconnect(DisconnectReason.ERROR);
                                    return;
                                }
                                FGAClient.this.timeout = 750;
                                if (!sVerify.equals("FGA Server")) {
                                    System.out.println("Server sent verify '" + sVerify + "' instead of '" + "FGA Server" + "'.");
                                    FGAClient.this.clientDisconnect(DisconnectReason.ERROR);
                                    return;
                                }
                                FGAClient.this.gs.reset();
                                ((FGAClient)FGAClient.this).gs.paused = bools[0];
                                ((FGAClient)FGAClient.this).gs.ready = true;
                                ((FGAClient)FGAClient.this).gs.maxPlayers = iPlayers;
                                ((FGAClient)FGAClient.this).gs.serverVersion = sVersion;
                                ((FGAClient)FGAClient.this).gs.map = sMapname;
                                ((FGAClient)FGAClient.this).gs.mapname = sMapname2;
                                ((FGAClient)FGAClient.this).gs.gamemode = iGamemode;
                                int i2 = 0;
                                while (i2 < iC) {
                                    if (objs[i2] != null) {
                                        ((FGAClient)FGAClient.this).gs.objs.add(objs[i2]);
                                        if (objs[i2] instanceof Player) {
                                            ((FGAClient)FGAClient.this).gs.stats.add((Player)objs[i2]);
                                        }
                                    } else {
                                        System.out.println("WARNING: Client was unable to read object " + i2 + "!");
                                    }
                                    ++i2;
                                }
                                ((FGAClient)FGAClient.this).gs.me = FGAClient.this.gs.getPlayer(iUser);
                                if (((FGAClient)FGAClient.this).gs.me == null) {
                                    System.out.println("Error: Server did not send a player object for us!");
                                    FGAClient.this.clientDisconnect(DisconnectReason.ERROR);
                                    return;
                                }
                                ((FGAClient)FGAClient.this).gs.me.me = true;
                                ((FGAClient)FGAClient.this).gs.renderAt.x = (int)((FGAClient)FGAClient.this).gs.me.pos.x;
                                ((FGAClient)FGAClient.this).gs.renderAt.y = (int)((FGAClient)FGAClient.this).gs.me.pos.y;
                                FGAClient.this.connectionState = ConnectionState.PLAYING;
                                UserInterface.get().setIngame();
                                continue block95;
                            }
                        }
                        case 128: {
                            Object sVerify = FGAClient.this.lock;
                            synchronized (sVerify) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                FGAClient.this.timeout = 750;
                                this.send(FGAClient.this.msgPinganswer());
                                continue block95;
                            }
                        }
                        case 129: {
                            int iUser = Misc.read(in);
                            short iPing = in.readShort();
                            Object iPlayers = FGAClient.this.lock;
                            synchronized (iPlayers) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                Player s = FGAClient.this.gs.getPlayer(iUser);
                                if (s != null) {
                                    s.ping = iPing;
                                } else {
                                    System.out.println("WARNING: Ping received, but player " + iUser + " doesn't exist!");
                                }
                                continue block95;
                            }
                        }
                        case 141: {
                            Player p;
                            ClientObj o = ClientObj.create(Misc.read(in), in);
                            Object iPing = FGAClient.this.lock;
                            synchronized (iPing) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                ClientObj o2 = FGAClient.this.gs.getObjByID(o.id);
                                if (o2 != null) {
                                    ((FGAClient)FGAClient.this).gs.objs.remove(o2);
                                    if (o2 instanceof Player) {
                                        p = (Player)o2;
                                        ((FGAClient)FGAClient.this).gs.laggers.remove(p);
                                        ((FGAClient)FGAClient.this).gs.stats.remove(p);
                                    }
                                }
                                ((FGAClient)FGAClient.this).gs.objs.add(o);
                                if (o instanceof Player) {
                                    ((FGAClient)FGAClient.this).gs.stats.add((Player)o);
                                }
                                continue block95;
                            }
                        }
                        case 131: {
                            int iSlot = Misc.read(in);
                            int iReason = Misc.read(in);
                            String sVer = iReason == 6 ? Misc.getString(in, 10) : "";
                            Object p = FGAClient.this.lock;
                            synchronized (p) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                Player p2 = FGAClient.this.gs.getPlayer(iSlot);
                                if (p2 != null) {
                                    ((FGAClient)FGAClient.this).gs.laggers.remove(p2);
                                    ((FGAClient)FGAClient.this).gs.stats.remove(p2);
                                    ((FGAClient)FGAClient.this).gs.objs.remove(p2);
                                    String name = "Client " + p2.nr;
                                    name = p2.name;
                                    FGAClient.this.gs.addChatMsg(255, Protocol.RemoveReason.makeMessage(iReason, name, sVer));
                                } else {
                                    System.out.println("Warning: Cannot remove player " + iSlot);
                                }
                                continue block95;
                            }
                        }
                        case 146: {
                            Player p;
                            int iSlot = Misc.read(in);
                            String sName = Misc.getString(in, 16);
                            Object sVer = FGAClient.this.lock;
                            synchronized (sVer) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                p = FGAClient.this.gs.getPlayer(iSlot);
                                if (p != null) {
                                    p.name = sName;
                                } else {
                                    System.out.println("Warning: Cannot rename player " + iSlot);
                                }
                                continue block95;
                            }
                        }
                        case 135: {
                            int iID = in.readInt();
                            int iSlot = Misc.read(in);
                            String sIP = Misc.getString(in, 16);
                            Object p = FGAClient.this.lock;
                            synchronized (p) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                Player p3 = new Player();
                                p3.id = iID;
                                p3.nr = iSlot;
                                p3.name = sIP;
                                p3.connected = false;
                                ((FGAClient)FGAClient.this).gs.objs.add(p3);
                                ((FGAClient)FGAClient.this).gs.stats.add(p3);
                                FGAClient.this.gs.addChatMsg(255, "A player is connecting...");
                                continue block95;
                            }
                        }
                        case 140: {
                            int iID = in.readInt();
                            Object iSlot = FGAClient.this.lock;
                            synchronized (iSlot) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                FGAClient.this.gs.removeEntity(iID);
                                continue block95;
                            }
                        }
                        case 130: {
                            int iUser = Misc.read(in);
                            boolean[] bools = Misc.readByte(in.readByte());
                            int iHP = Misc.read(in);
                            int iAmmo = Misc.read(in);
                            int iReload = Misc.read(in);
                            int iKills = in.readInt();
                            int iAssists = in.readInt();
                            int iDeaths = in.readInt();
                            Object iMapLength2 = FGAClient.this.lock;
                            synchronized (iMapLength2) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                Player p = FGAClient.this.gs.getPlayer(iUser);
                                if (p != null) {
                                    p.ammo = iAmmo;
                                    p.reload = iReload;
                                    p.hp = iHP;
                                    p.kills = iKills;
                                    p.assists = iAssists;
                                    p.deaths = iDeaths;
                                    p.dead = bools[0];
                                    p.protection = bools[1];
                                    FGAClient.this.gs.sortStats();
                                } else {
                                    System.out.println("WARNING: Stats received, but player " + iUser + " doesn't exist!");
                                }
                                continue block95;
                            }
                        }
                        case 139: {
                            int iUser = Misc.read(in);
                            int iWeapon = Misc.read(in);
                            boolean[] baExtras = Misc.readBytes(in, -1, 8);
                            int iTeam = Misc.read(in);
                            Object iReload = FGAClient.this.lock;
                            synchronized (iReload) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                Player s = FGAClient.this.gs.getPlayer(iUser);
                                if (s != null) {
                                    s.weapon = iWeapon;
                                    s.extras = baExtras;
                                    s.makeExtra();
                                    s.team = iTeam;
                                } else {
                                    System.out.println("WARNING: Playerdata2 received, but player " + iUser + " doesn't exist!");
                                }
                                continue block95;
                            }
                        }
                        case 134: {
                            int iID = in.readInt();
                            double dX = in.readFloat();
                            double dY = in.readFloat();
                            double dRot = ClientObj.makeRotation(in.readShort());
                            Object object = FGAClient.this.lock;
                            synchronized (object) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                FGAClient.this.gs.setPos(iID, dX, dY, dRot);
                                continue block95;
                            }
                        }
                        case 138: {
                            int iType = Misc.read(in);
                            int iNum = Misc.read(in);
                            int iVolume = Misc.read(in);
                            int iBalance = 127;
                            double fX = 0.0;
                            double fY = 0.0;
                            float fRad = 0.0f;
                            switch (iType) {
                                case 0: {
                                    iBalance = Misc.read(in);
                                    break;
                                }
                                case 1: {
                                    fX = in.readFloat();
                                    fY = in.readFloat();
                                    fRad = in.readFloat();
                                }
                            }
                            Object object = FGAClient.this.lock;
                            synchronized (object) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                float fBal = ((float)iBalance - 127.0f) / 127.0f;
                                float fVol = (float)iVolume / 255.0f;
                                switch (iType) {
                                    case 1: {
                                        fBal = (float)((fX -= (double)((FGAClient)FGAClient.this).gs.renderAt.x) / 300.0);
                                        fVol = (float)((1.0 - Misc.getDistance(0.0, 0.0, fX, fY -= (double)((FGAClient)FGAClient.this).gs.renderAt.y) / (double)fRad) * (double)fVol);
                                    }
                                }
                                MediaLib.playSound(iNum, fVol, fBal);
                                continue block95;
                            }
                        }
                        case 144: {
                            int iStrength = Misc.read(in);
                            Object iNum = FGAClient.this.lock;
                            synchronized (iNum) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                FGAClient.this.gs.doHitmarker(iStrength);
                                continue block95;
                            }
                        }
                        case 143: {
                            int iPl1 = Misc.read(in);
                            int iPl2 = Misc.read(in);
                            int iPl3 = Misc.read(in);
                            int iWpn = Misc.read(in);
                            Object object = FGAClient.this.lock;
                            synchronized (object) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                FGAClient.this.gs.addKillfeed(iPl1, iPl2, iPl3, iWpn);
                                continue block95;
                            }
                        }
                        case 142: {
                            int iSender = Misc.read(in);
                            int iChars = Misc.read(in);
                            String sMsg = Misc.getString(in, iChars);
                            Object object = FGAClient.this.lock;
                            synchronized (object) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                FGAClient.this.gs.addChatMsg(iSender, sMsg);
                                MediaLib.playSound(24);
                                continue block95;
                            }
                        }
                        case 145: {
                            int iMisc = Misc.read(in);
                            Object iChars = FGAClient.this.lock;
                            synchronized (iChars) {
                                if (this.checkGreeting()) {
                                    return;
                                }
                                switch (iMisc) {
                                    case 0: {
                                        ((FGAClient)FGAClient.this).gs.paused = false;
                                        break;
                                    }
                                    case 1: {
                                        ((FGAClient)FGAClient.this).gs.paused = true;
                                    }
                                }
                                continue block95;
                            }
                        }
                        case 132: {
                            int iReason = Misc.read(in);
                            String sVersion = Misc.getString(in, 10);
                            Object sMsg = FGAClient.this.lock;
                            synchronized (sMsg) {
                                ((FGAClient)FGAClient.this).gs.serverVersion = sVersion;
                                FGAClient.this.clientDisconnect(DisconnectReason.getReasonByDisconnectMessage(iReason));
                                return;
                            }
                        }
                        case 136: {
                            Player p;
                            int iLagger = Misc.read(in);
                            Object object = FGAClient.this.lock;
                            synchronized (object) {
                                p = FGAClient.this.gs.getPlayer(iLagger);
                                if (p != null) {
                                    ((FGAClient)FGAClient.this).gs.laggers.add(p);
                                } else {
                                    System.out.println("Warning: Server sent lagger " + iLagger + " but there is no such player!");
                                }
                                continue block95;
                            }
                        }
                        case 137: {
                            Player p;
                            int iLagger = Misc.read(in);
                            Object object = FGAClient.this.lock;
                            synchronized (object) {
                                p = FGAClient.this.gs.getPlayer(iLagger);
                                if (p != null) {
                                    ((FGAClient)FGAClient.this).gs.laggers.remove(p);
                                } else {
                                    System.out.println("Warning: Server sent laggerend " + iLagger + " but there is no such player!");
                                }
                            }
                        }
                        continue block95;
                        case 133: {
                            Object object = FGAClient.this.lock;
                            synchronized (object) {
                                FGAClient.this.clientDisconnect(DisconnectReason.FULL);
                                return;
                            }
                        }
                    }
                    break;
                }
                System.out.println("Server sent strange message: " + msgType);
                FGAClient.this.clientDisconnect(DisconnectReason.ERROR);
                return;
            }
            catch (Exception ex) {
                if (!(ex.getMessage().equals("End of stream reached") || ex.getMessage().equals("Stream closed") || ex.getMessage().equals("Connection reset") || ex.getMessage().equals("socket closed"))) {
                    FightgameAlpha.get().addToErrorLog("Client disconnect", ex);
                }
                ex.printStackTrace();
                throw ex;
            }
        }
    }

    static enum ConnectionState {
        NOT_CONNECTED,
        CONNECTING,
        WAIT_FOR_GREETING,
        PLAYING,
        DISCONNECTING;

    }
}

