/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.client;

public enum DisconnectReason {
    CONNECTING_FAILED,
    CONNECTION_LOST,
    CONNECTION_ERROR,
    QUIT,
    KICKED,
    BANNED,
    FULL,
    TIMEOUT,
    ERROR,
    VERSION,
    NETWORK_FAILED,
    UNKNOWN_START_ERROR,
    UNKNOWN,
    CANCELED,
    STREAM_PIPE_ERROR,
    RECONNECT,
    NO_MAP;


    public String getAsText(String serverversion) {
        switch (this) {
            case CONNECTING_FAILED: {
                return "Connecting failed!";
            }
            case CONNECTION_ERROR: {
                return "Cannot connect to this server!";
            }
            case CONNECTION_LOST: {
                return "Connection lost!";
            }
            case QUIT: {
                return "You quit the game!";
            }
            case KICKED: {
                return "You got kicked!";
            }
            case BANNED: {
                return "You got banned!";
            }
            case FULL: {
                return "The server is full!";
            }
            case TIMEOUT: {
                return "Server timeout!";
            }
            case ERROR: {
                return "Protocol error!";
            }
            case VERSION: {
                return "Server version differs (" + serverversion + ")!";
            }
            case NETWORK_FAILED: {
                return "Starting failed: Port in use!";
            }
            case CANCELED: {
                return "User cancelled the connecting!";
            }
            case UNKNOWN_START_ERROR: {
                return "Unknown start error occured!";
            }
            case STREAM_PIPE_ERROR: {
                return "Error starting the piped streams!";
            }
            case NO_MAP: {
                return "Map file could not be found!";
            }
        }
        return this.toString();
    }

    public static DisconnectReason getReasonByDisconnectMessage(int reason) {
        switch (reason) {
            case 0: {
                return KICKED;
            }
            case 1: {
                return BANNED;
            }
            case 2: {
                return VERSION;
            }
        }
        return UNKNOWN;
    }
}

