/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha;

import com.iosoft.fgalpha.client.FGAClient;
import com.iosoft.fgalpha.server.FGAServer;
import com.iosoftware.helpers.GCThread;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.PropDB;
import com.iosoftware.helpers.network.LocalConnection;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class FightgameAlpha {
    public static final String VERSION = "v0.3.0";
    public static final String OFFICIAL_SERVER_IP_SITE = "http://para-welt.com/main/ayce/fgalpha/serverip.txt";
    public static final String OFFICIAL_UPDATE_SITE = "http://para-welt.com/main/ayce/fgalpha/update.txt";
    public static final String OFFICIAL_SITE = "http://para-welt.com/main/ayce/fgalpha/";
    public static final String SETTINGS_PATH = String.valueOf(System.getenv("APPDATA")) + "/IoSoftware/FightgameAlpha/";
    private static final long TIME_UPDATE_CHECK = 86400000L;
    public static final int DEFAULT_PORT = 2738;
    private static FightgameAlpha inst;
    public static final Object lock;
    private PropDB settings;
    private PropDB.Node root;
    private String name;
    private String map;
    private String ip;
    private String rconPassword;
    private long lastUpdateCheck;
    private int port;
    private int hostPort;
    private int weapon;
    private int extra;
    private int team;
    private int players;
    private int gamemode;
    private int bots;
    private boolean network;
    private boolean ff;
    private boolean dedicated;
    private boolean updateCheckEnabled;
    private boolean laggerStop;
    private String[] maps;

    static {
        lock = new Object();
    }

    public static void main(String[] args) {
        GCThread.startGCThread(1000L);
        inst = new FightgameAlpha();
        inst.init();
    }

    public static FightgameAlpha get() {
        return inst;
    }

    private FightgameAlpha() {
        this.initSettings();
        this.loadMaps();
    }

    private void init() {
        FGAServer.get().init();
        FGAClient.get().init();
    }

    public static boolean isCompatible(String version) {
        return version.equals(VERSION);
    }

    public void startServerAndConnect(boolean network, int hostPort, int players, String map, int gamemode, boolean ff, int bots, boolean dedicated) {
        this.setHostOptions(map, network, hostPort, ff, gamemode, players, bots, dedicated);
        FGAServer.get().start(network, hostPort, players, map, gamemode, ff, false, bots, dedicated);
        if (!dedicated) {
            LocalConnection c = FGAClient.get().connectToSelf();
            FGAServer.get().connectLocal(c);
        }
    }

    public boolean getFriendlyFire() {
        return this.ff;
    }

    public boolean getDedicated() {
        return this.dedicated;
    }

    public String getName() {
        return this.name;
    }

    public String getRconPassword() {
        return this.rconPassword;
    }

    public int getWeapon() {
        return this.weapon;
    }

    public int getExtra() {
        return this.extra;
    }

    public int getTeam() {
        return this.team;
    }

    public boolean shouldCheckForUpdates() {
        return this.updateCheckEnabled && this.lastUpdateCheck + 86400000L < System.currentTimeMillis();
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public int getBots() {
        return this.bots;
    }

    public int getPlayers() {
        return this.players;
    }

    public boolean getNetwork() {
        return this.network;
    }

    public boolean getLaggerstop() {
        return this.laggerStop;
    }

    public String getMap() {
        return this.map;
    }

    public String getIP() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public int getHostPort() {
        return this.hostPort;
    }

    public void setHostOptions(String map, boolean network, int hostPort, boolean ff, int gamemode, int players, int bots, boolean dedicated) {
        this.root.get("map").setValue(map);
        this.root.get("network").setValue(network);
        this.root.get("hostPort").setValue(hostPort);
        this.root.get("friendlyfire").setValue(ff);
        this.root.get("gamemode").setValue(gamemode);
        this.root.get("players").setValue(players);
        this.root.get("bots").setValue(bots);
        this.root.get("dedicated").setValue(dedicated);
        this.readSettings();
        this.saveSettings();
    }

    public void onUpdateChecked() {
        this.root.get("lastUpdateCheck").setValue(System.currentTimeMillis());
        this.readSettings();
        this.saveSettings();
    }

    public void setJoinOptions(String name, int weapon, int extra, int team, String ip, int port) {
        this.root.get("name").setValue(name);
        this.root.get("weapon").setValue(weapon);
        this.root.get("extra").setValue(extra);
        this.root.get("team").setValue(team);
        this.root.get("ip").setValue(ip);
        this.root.get("port").setValue(port);
        this.readSettings();
        this.saveSettings();
    }

    public void setExtendedOptions(boolean laggerStop, String rconPassword) {
        this.root.get("laggerStop").setValue(laggerStop);
        this.root.get("rconPassword").setValue(rconPassword);
        this.readSettings();
        this.saveSettings();
    }

    public void readSettings() {
        this.name = Misc.trimString(this.root.get("name", Misc.getUserName()).getAsString().trim(), 16);
        this.weapon = Misc.checkRange(this.root.get("weapon", 0).getAsInt(), 0, 3);
        this.extra = Misc.checkRange(this.root.get("extra", 0).getAsInt(), 0, 6);
        this.team = Misc.checkRange(this.root.get("team", 0).getAsInt(), 0, 2);
        this.ip = this.root.get("ip", "127.0.0.1").getAsString();
        this.port = Misc.checkRange(this.root.get("port", 2738).getAsInt(), 0, 65535);
        this.lastUpdateCheck = this.root.get("lastUpdateCheck", 0).getAsLong();
        this.updateCheckEnabled = this.root.get("updateEnabled", true).getAsBoolean();
        this.map = this.root.get("map", "testmap").getAsString();
        this.network = this.root.get("network", true).getAsBoolean();
        this.hostPort = Misc.checkRange(this.root.get("hostPort", 2738).getAsInt(), 0, 65535);
        this.ff = this.root.get("friendlyfire", false).getAsBoolean();
        this.gamemode = Misc.checkRange(this.root.get("gamemode", 0).getAsInt(), 0, 1);
        this.players = Misc.checkRange(this.root.get("players", 5).getAsInt(), 1, 255);
        this.bots = Misc.checkRange(this.root.get("bots", 2).getAsInt(), 0, 254);
        this.dedicated = this.root.get("dedicated", false).getAsBoolean();
        this.laggerStop = this.root.get("laggerStop", false).getAsBoolean();
        this.rconPassword = this.root.get("rconPassword", "").getAsString();
    }

    private void initSettings() {
        Misc.createDirs(String.valueOf(SETTINGS_PATH) + "screenshots/");
        this.settings = new PropDB();
        if (!this.settings.load(String.valueOf(SETTINGS_PATH) + "settings.dat")) {
            this.settings.clear();
        }
        this.root = this.settings.getRoot();
        this.readSettings();
        this.saveSettings();
    }

    private void loadMaps() {
        this.maps = Misc.loadFileAsStringArray("/res/server/maplist.txt");
        ArrayList<String> maplist = new ArrayList<String>();
        int i = 0;
        while (i < this.maps.length) {
            maplist.add(this.maps[i]);
            ++i;
        }
        File mapsDir = new File("maps");
        if (mapsDir.exists() && mapsDir.isDirectory()) {
            System.out.println("Usermap directory exists! Loading usermaps...");
            String[] usermapsRaw = mapsDir.list();
            int i2 = 0;
            while (i2 < usermapsRaw.length) {
                String raw = usermapsRaw[i2];
                if (raw.length() > 4 && raw.endsWith(".txt") && Misc.fileExists("maps/" + (raw = raw.substring(0, raw.length() - 4)) + ".png")) {
                    maplist.add(raw);
                    System.out.println("Map '" + raw + "' appears to be valid. Adding to list...");
                }
                ++i2;
            }
        } else {
            System.out.println("No usermap directory found!");
        }
        this.maps = new String[maplist.size()];
        maplist.toArray(this.maps);
    }

    public void saveSettings() {
        this.settings.save();
    }

    public String[] getWeapons() {
        String[] sa = new String[]{"Assault", "Shotgun", "Sniper", "Semiauto", "Random"};
        return sa;
    }

    public String[] getExtras() {
        String[] sa = new String[]{"Resistance", "Aiming", "Extended Mags", "Scout", "Damager", "Sprinter", "Random"};
        return sa;
    }

    public String[] getTeams() {
        String[] sa = new String[]{"Auto-Assign", "Red", "Blue"};
        return sa;
    }

    public String[] getGamemodes() {
        String[] sa = new String[]{"FFA", "Teams"};
        return sa;
    }

    public String[] getMaps() {
        return this.maps;
    }

    public int getMapAsChoice() {
        int i = 0;
        while (i < this.maps.length) {
            if (this.maps[i].equals(this.map)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public void addToErrorLog(String title, Exception ex) {
        File file = new File(String.valueOf(SETTINGS_PATH) + "errorlog.txt");
        try {
            FileWriter fw = new FileWriter(file, true);
            PrintWriter pw = new PrintWriter(fw);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            pw.println(dateFormat.format(date));
            pw.println("FGA v0.3.0");
            pw.println(title);
            ex.printStackTrace(pw);
            pw.println();
            pw.println();
            try {
                pw.flush();
            }
            catch (Exception e) {
                ex.printStackTrace();
            }
            try {
                pw.close();
            }
            catch (Exception e) {
                ex.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

