/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.ui;

import com.iosoftware.helpers.Misc;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;

public class GameText
extends JTextField {
    private GameText inst = this;
    private MyKeyListener listener;
    private static final long serialVersionUID = 1L;
    private boolean mode;
    private String name;
    private int maxChars;

    public GameText(int x, int y, int width, int height, String text, String name, Component base) {
        this(x, y, width, height, text, name, null, null, base);
    }

    public GameText(int x, int y, int width, int height, String text, String name) {
        this(x, y, width, height, text, name, null, null);
    }

    public GameText(int x, int y, int width, int height, String text, String name, Font font) {
        this(x, y, width, height, text, name, font, null);
    }

    public GameText(int x, int y, int width, int height, String text, String name, Font font, KeyListener kl) {
        this(x, y, width, height, text, name, font, kl, null);
    }

    public GameText(int x, int y, int width, int height, String text, String name, Font font, KeyListener kl, Component base) {
        if (base != null) {
            Misc.doDefaults(this, base);
        }
        this.maxChars = -1;
        if (font != null) {
            this.setFont(font);
        }
        if (kl != null) {
            this.addKeyListener(kl);
        }
        this.setMode(false);
        this.setHorizontalAlignment(2);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setDocument(new DefaultStyledDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                if (GameText.this.maxChars > -1 && this.getLength() + str.length() > GameText.this.maxChars) {
                    if (this.getLength() > GameText.this.maxChars) {
                        this.remove(GameText.this.maxChars, this.getLength() - GameText.this.maxChars);
                        str = "";
                    } else {
                        str = Misc.trimString(str, GameText.this.maxChars - this.getLength());
                    }
                }
                super.insertString(offset, str, a);
            }
        });
        this.setText(text);
        this.setIDName(name);
        this.setBounds(x, y, width, height);
    }

    @Override
    protected void paintComponent(Graphics gFake) {
        Graphics2D g = (Graphics2D)gFake;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
    }

    public void setMaxChars(int maxChars) {
        this.maxChars = maxChars;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setIDName(String name) {
        this.name = name;
    }

    public String getIDName() {
        return this.name;
    }

    public void setMode(boolean mode) {
        this.mode = mode;
        if (this.listener != null) {
            this.removeKeyListener(this.listener);
        }
        if (mode) {
            this.listener = new MyKeyListener();
            this.addKeyListener(this.listener);
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (GameText.this.mode) {
                Misc.getActionListener().actionPerformed(new ActionEvent(GameText.this.inst, 1001, "click5"));
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

