/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.ui;

import com.iosoftware.helpers.Misc;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class GameCheckbox
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String name;
    private boolean checked;
    private boolean enabled = true;
    private ActionListener[] als;
    private static final Color COLOR_DISABLED_BG = new Color(200, 200, 200);
    private static final Color COLOR_DISABLED_MARKER = new Color(100, 100, 100);

    public GameCheckbox(int x, int y, int width, int height, boolean checked, String name) {
        this.setBounds(x, y, width, height);
        this.als = new ActionListener[0];
        this.setIDName(name);
        ActionListener actionListener = Misc.getActionListener();
        if (actionListener != null) {
            this.addActionListener(actionListener);
        }
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setLayout(null);
        this.addMouseListener(new MouseListener());
        this.checked = checked;
        this.setBackground(Color.WHITE);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        this.repaint();
    }

    public void setIDName(String name) {
        this.name = name;
    }

    public String getIDName() {
        return this.name;
    }

    public void addActionListener(ActionListener al) {
        int iC = this.als.length;
        ActionListener[] temp = new ActionListener[iC + 1];
        int i = 0;
        while (i < iC) {
            temp[i] = this.als[i];
            ++i;
        }
        temp[iC] = al;
        this.als = temp;
    }

    public void sendEvt() {
        this.doClick(false);
    }

    public void doClick(boolean sound) {
        int iC = this.als.length;
        int i = 0;
        while (i < iC) {
            this.als[i].actionPerformed(new ActionEvent(this, 1001, sound ? "click3" : "nosound"));
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int disX = width / 4;
        int disY = height / 4;
        g.setColor(this.enabled ? Color.WHITE : COLOR_DISABLED_BG);
        g.fillRect(0, 0, width, height);
        if (this.checked) {
            g.setColor(this.enabled ? Color.BLACK : COLOR_DISABLED_MARKER);
            g.fillRect(disX, disY, width - 2 * disX, height - 2 * disY);
        }
    }

    private class MouseListener
    implements java.awt.event.MouseListener {
        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (GameCheckbox.this.enabled) {
                GameCheckbox.this.checked = !GameCheckbox.this.checked;
                GameCheckbox.this.repaint();
                GameCheckbox.this.doClick(true);
            }
        }
    }
}

