/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class Listener {
    private int port = -1;
    private ListenerWorker lastListener;
    private boolean running = false;
    private boolean nodelay = false;
    private boolean reuse = false;
    private boolean reuseSet = false;
    private final Object lock = new Object();

    public void setTcpNodelay(boolean value) {
        this.nodelay = value;
    }

    public void setReuse(boolean value) {
        this.reuse = value;
        this.reuseSet = true;
    }

    public void unsetReuse() {
        this.reuseSet = false;
    }

    public void setPort(int value) {
        this.port = value;
    }

    public boolean getTcpNodelay() {
        return this.nodelay;
    }

    public boolean getReuse() {
        return this.reuse;
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.lock;
        synchronized (object) {
            block7: {
                if (this.running) break block7;
                ServerSocket server = null;
                try {
                    server = new ServerSocket();
                    if (this.reuseSet) {
                        server.setReuseAddress(this.reuse);
                    }
                    server.bind(new InetSocketAddress(this.port));
                }
                catch (Exception ex) {
                    server = null;
                }
                if (server == null) break block7;
                this.running = true;
                this.lastListener = new ListenerWorker(server, this.nodelay);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
            if (this.lastListener != null) {
                this.lastListener.stopServer();
            }
        }
    }

    protected abstract void onConnect(Socket var1);

    private class ListenerWorker
    extends Thread {
        private ServerSocket server;
        private boolean nodelay;
        private boolean running;
        private Object lock = new Object();

        public ListenerWorker(ServerSocket server, boolean nodelay) {
            this.setName("Server Listener");
            this.server = server;
            this.nodelay = nodelay;
            this.running = true;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.running) {
                        break;
                    }
                }
                try {
                    Socket socket = this.server.accept();
                    object = this.lock;
                    synchronized (object) {
                        if (this.running) {
                            socket.setTcpNoDelay(this.nodelay);
                            Listener.this.onConnect(socket);
                        } else {
                            try {
                                socket.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
            this.stopServer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopServer() {
            Object object = this.lock;
            synchronized (object) {
                this.running = false;
                try {
                    this.server.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

