/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.audio;

import com.iosoftware.helpers.audio.SmallLoop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class SmallSound {
    private List<Runnable> closeListeners;
    private Object lock = new Object();
    private byte[] data;
    private boolean destroyed = false;

    public static SmallSound load(String path) {
        try {
            InputStream in = SmallLoop.class.getResourceAsStream(path);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataInputStream dis = new DataInputStream(in);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = dis.read(buffer)) >= 0) {
                baos.write(buffer, 0, read);
            }
            dis.close();
            byte[] audio = baos.toByteArray();
            return new SmallSound(audio);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private SmallSound(byte[] data) {
        this.closeListeners = new ArrayList<Runnable>();
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable r) {
        Object object = this.lock;
        synchronized (object) {
            this.closeListeners.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.lock;
        synchronized (object) {
            return this.destroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.destroyed = true;
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public void play() {
        this.play(1.0f, 0.0f);
    }

    public void play(float volume, float balance) {
        if (volume < 0.0f) {
            volume = 0.0f;
        } else if (volume > 1.0f) {
            volume = 1.0f;
        }
        if (balance < -1.0f) {
            balance = -1.0f;
        } else if (balance > 1.0f) {
            balance = 1.0f;
        }
        if (volume > 0.0f) {
            new PlayerThread(volume, balance);
        }
    }

    private class PlayerThread
    extends Thread {
        private float volume;
        private float balance;

        public PlayerThread(float volume, float balance) {
            this.volume = volume;
            this.balance = balance;
            this.setName("PlayerThread");
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SmallSound.this.lock;
            synchronized (object) {
                try {
                    final Clip clip = AudioSystem.getClip();
                    clip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(SmallSound.this.data)));
                    clip.addLineListener(new LineListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void update(LineEvent e) {
                            if (e.getType() == LineEvent.Type.STOP) {
                                try {
                                    clip.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Object object = SmallSound.this.lock;
                                synchronized (object) {
                                    int i = 0;
                                    while (i < SmallSound.this.closeListeners.size()) {
                                        ((Runnable)SmallSound.this.closeListeners.get(i)).run();
                                        ++i;
                                    }
                                }
                            }
                        }
                    });
                    if (this.volume != 1.0f || this.balance != 0.0f) {
                        try {
                            FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                            float dB = (float)(Math.log(this.volume) / Math.log(10.0) * 20.0);
                            gainControl.setValue(dB);
                            if (clip.getFormat().getChannels() != 1) {
                                FloatControl balanceControl = (FloatControl)clip.getControl(FloatControl.Type.BALANCE);
                                balanceControl.setValue(this.balance);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    clip.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

