/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.audio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

public class SmallLoop {
    private Clip clip;
    private List<Runnable> closeListeners;
    private Object lock = new Object();
    private float balance = 0.0f;
    private float volume = 1.0f;
    private boolean muted = false;

    public static SmallLoop load(String path) {
        try {
            InputStream in = SmallLoop.class.getResourceAsStream(path);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataInputStream dis = new DataInputStream(in);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = dis.read(buffer)) >= 0) {
                baos.write(buffer, 0, read);
            }
            dis.close();
            byte[] audio = baos.toByteArray();
            Clip clip = AudioSystem.getClip();
            clip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(audio)));
            return new SmallLoop(clip);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private SmallLoop(Clip clip) {
        this.closeListeners = new ArrayList<Runnable>();
        this.clip = clip;
        clip.addLineListener(new LineListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update(LineEvent e) {
                if (e.getType() == LineEvent.Type.STOP) {
                    Object object = SmallLoop.this.lock;
                    synchronized (object) {
                        int i = 0;
                        while (i < SmallLoop.this.closeListeners.size()) {
                            ((Runnable)SmallLoop.this.closeListeners.get(i)).run();
                            ++i;
                        }
                    }
                }
            }
        });
        this.checkMuted();
        this.checkVolume();
        this.checkBalance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Runnable r) {
        Object object = this.lock;
        synchronized (object) {
            this.closeListeners.add(r);
        }
    }

    public void setVolume(float volume) {
        if (volume < 0.0f) {
            volume = 0.0f;
        } else if (volume > 1.0f) {
            volume = 1.0f;
        }
        this.volume = volume;
        this.checkVolume();
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
        this.checkMuted();
    }

    public void setBalance(float balance) {
        if (balance < -1.0f) {
            balance = -1.0f;
        } else if (balance > 1.0f) {
            balance = 1.0f;
        }
        this.balance = balance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBalance() {
        Object object = this.lock;
        synchronized (object) {
            if (this.clip != null) {
                try {
                    FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.BALANCE);
                    gainControl.setValue(this.balance);
                    BooleanControl muteControl = (BooleanControl)this.clip.getControl(BooleanControl.Type.MUTE);
                    muteControl.setValue(true);
                    muteControl.setValue(false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVolume() {
        Object object = this.lock;
        synchronized (object) {
            if (this.clip != null) {
                try {
                    FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                    float dB = (float)(Math.log(this.volume) / Math.log(10.0) * 20.0);
                    gainControl.setValue(dB);
                    BooleanControl muteControl = (BooleanControl)this.clip.getControl(BooleanControl.Type.MUTE);
                    if (!this.muted) {
                        muteControl.setValue(true);
                        muteControl.setValue(false);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMuted() {
        Object object = this.lock;
        synchronized (object) {
            if (this.clip != null) {
                try {
                    BooleanControl muteControl = (BooleanControl)this.clip.getControl(BooleanControl.Type.MUTE);
                    muteControl.setValue(this.muted);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.clip != null) {
                this.clip.loop(-1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.clip != null) {
                this.clip.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.clip != null) {
                this.clip.stop();
                this.clip.flush();
                this.clip.close();
                this.clip = null;
            }
        }
    }
}

