/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers.audio;

import com.iosoftware.helpers.Misc;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioPlayer {
    private static String soundDir = "/";

    public static void setSoundDir(String dir) {
        soundDir = dir;
    }

    public static Clips load(String name, int count, boolean loopChannel) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataInputStream dis = new DataInputStream(Misc.getFileAsInputStream(String.valueOf(soundDir) + name));
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = dis.read(buffer)) >= 0) {
                baos.write(buffer, 0, read);
            }
            dis.close();
            byte[] data = baos.toByteArray();
            System.out.println("Sound '" + soundDir + name + "' succesfully loaded.");
            return new Clips(data, count, loopChannel);
        }
        catch (Exception ex) {
            System.out.println("Sound '" + soundDir + name + "' could not be loaded.");
            return null;
        }
    }

    public static void init() {
    }

    public static class Clips {
        public Clip[] clips;
        public Clip loopClip;
        private byte[] buffer;
        private int p;
        private int count;

        public Clips(byte[] buffer, int count, boolean loopChannel) throws LineUnavailableException, IOException, UnsupportedAudioFileException {
            if (buffer == null) {
                return;
            }
            this.buffer = buffer;
            this.clips = new Clip[count];
            this.count = count;
            int i = 0;
            while (i < count) {
                this.clips[i] = AudioSystem.getClip();
                this.clips[i].open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(buffer)));
                ++i;
            }
            if (loopChannel) {
                this.loopClip = AudioSystem.getClip();
                this.loopClip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(buffer)));
            }
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void play2() {
            if (this.clips == null) {
                return;
            }
            Clip clip = this.clips[this.p];
            synchronized (clip) {
                this.clips[this.p].stop();
                if (this.clips[this.p].isRunning()) {
                    System.out.println("lol!");
                }
                this.clips[this.p].setFramePosition(0);
                this.clips[this.p].start();
            }
        }

        private void toNext() {
            ++this.p;
            if (this.p >= this.count) {
                this.p = 0;
            }
        }

        public boolean isLooping() {
            if (this.loopClip != null) {
                return this.loopClip.isActive();
            }
            return false;
        }

        public void stopLoop() {
            this.loopClip.stop();
            this.loopClip.setFramePosition(0);
        }

        public void play() {
            this.play2();
            this.toNext();
        }

        public void playLoop() {
            this.playLoop(-1);
        }

        public void playLoop(int times) {
            if (this.loopClip != null) {
                this.loopClip.loop(times);
            }
        }

        public void stop() {
            this.clips[this.p].stop();
        }
    }

    public static class Playlist {
        public static final int DEFAULT = 0;
        public static final int RANDOM = 1;
        private List<Clip> clips;
        private List<Clip> playlist;
        private int id = 0;
        private int type = 0;
        private boolean played = false;
        private boolean repeat = false;
        private boolean running = false;
        private Object lockList = new Object();
        private Object lockType = new Object();

        public Playlist() {
            this.clips = new ArrayList<Clip>();
            this.playlist = new ArrayList<Clip>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setType(int type) {
            Object object = this.lockType;
            synchronized (object) {
                this.type = type;
            }
        }

        public void setRepeat(boolean repeat) {
            this.repeat = repeat;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addClip(Clips newclip) {
            if (newclip != null) {
                Object object = this.lockList;
                synchronized (object) {
                    try {
                        Clip clip = AudioSystem.getClip();
                        clip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(newclip.getBuffer())));
                        this.clips.add(clip);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }

        public void play() {
            if (this.running) {
                return;
            }
            this.running = true;
            this.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restart() {
            Object object = this.lockList;
            synchronized (object) {
                this.stop();
                this.playlist.clear();
                this.play();
            }
        }

        public void stop() {
            if (!this.running) {
                return;
            }
            this.running = false;
            this.stopClip();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopClip() {
            Object object = this.lockList;
            synchronized (object) {
                if (this.playlist.size() > 0) {
                    this.playlist.get(0).stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void next() {
            Object object = this.lockList;
            synchronized (object) {
                if (!this.played || this.repeat && this.running) {
                    if (this.playlist.size() > 0) {
                        this.playlist.get(0).stop();
                        this.playlist.get(0).setFramePosition(0);
                        this.playlist.remove(0);
                    }
                    if (this.playlist.size() == 0) {
                        if (this.clips.size() > 0) {
                            this.played = true;
                            int iC = this.clips.size();
                            int i = 0;
                            while (i < iC) {
                                this.playlist.add(this.clips.get(i));
                                ++i;
                            }
                            Object object2 = this.lockType;
                            synchronized (object2) {
                                if (this.type == 1) {
                                    Playlist.randomizeClips(this.playlist);
                                }
                            }
                        } else {
                            this.running = false;
                        }
                    }
                    if (this.playlist.size() > 0) {
                        ++this.id;
                        this.playlist.get(0).start();
                        new SwitchThread(Math.round(this.playlist.get(0).getMicrosecondLength() / 1000L));
                    }
                }
            }
        }

        public static void randomizeClips(List<Clip> clips) {
            ArrayList<Clip> temp = new ArrayList<Clip>();
            int iC = clips.size();
            int i = 0;
            while (i < iC) {
                temp.add((int)Math.floor(Math.random() * (double)(temp.size() + 1)), clips.remove(0));
                ++i;
            }
            i = 0;
            while (i < iC) {
                clips.add((Clip)temp.remove(0));
                ++i;
            }
        }

        protected void finalize() throws Throwable {
            this.stop();
            super.finalize();
        }

        private class SwitchThread
        extends Thread {
            private int verify;
            private int length;

            public SwitchThread(int length) {
                this.setName("AudioPlayer Playlist Thread");
                this.length = length;
                this.verify = Playlist.this.id;
                this.start();
            }

            @Override
            public void run() {
                Misc.sleep(this.length);
                if (Playlist.this.id == this.verify && Playlist.this.running) {
                    Playlist.this.next();
                }
            }
        }
    }
}

