/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers;

import com.iosoftware.helpers.Misc;

public class Ticker {
    private final String name;
    private final long tps;
    private final Runnable runner;
    private Worker lastWorker;
    private final Object lock = new Object();

    public Ticker(String name, long tps, Runnable runner) {
        this.name = name;
        this.tps = tps;
        this.runner = runner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean compensate) {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastWorker == null && this.runner != null) {
                this.lastWorker = new Worker(compensate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastWorker != null) {
                this.lastWorker.running = false;
                this.lastWorker = null;
            }
        }
    }

    private class Worker
    extends Thread {
        private boolean running = true;
        private final boolean compensate;

        public Worker(boolean compensate) {
            this.compensate = compensate;
            this.setName(Ticker.this.name == null ? "Ticker" : Ticker.this.name);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                long shouldTime = 1000000000L / Ticker.this.tps;
                if (this.compensate) {
                    long startTime = System.nanoTime();
                    long ticks = 0L;
                    long lastTime = shouldTime;
                    while (true) {
                        long sleepTime;
                        ++ticks;
                        Object object = Ticker.this.lock;
                        synchronized (object) {
                            if (!this.running) {
                                break block12;
                            }
                        }
                        Ticker.this.runner.run();
                        lastTime = sleepTime = (ticks * shouldTime - (System.nanoTime() - startTime) + lastTime) / 2L;
                        if ((sleepTime /= 1000000L) <= 0L) continue;
                        Misc.sleep(sleepTime);
                    }
                }
                long startTime = System.nanoTime();
                while (true) {
                    Object object = Ticker.this.lock;
                    synchronized (object) {
                        if (!this.running) {
                            break;
                        }
                    }
                    Ticker.this.runner.run();
                    long sleepTime = Math.round((double)(shouldTime - (System.nanoTime() - startTime)) / 1000000.0);
                    if (sleepTime > 0L) {
                        Misc.sleep(sleepTime);
                    }
                    startTime = System.nanoTime();
                }
            }
        }
    }
}

