/*
 * Decompiled with CFR 0.152.
 */
package com.iosoftware.helpers;

import com.iosoftware.helpers.Misc;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class IoSaveFile {
    private static final String STARTSTRING = "IoChunkSaveFile";
    private final int CURRENT_VERSION = 0;
    private boolean debug;
    private Chunk root;

    public IoSaveFile() {
        this.reset();
        this.setDebug(false);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void load(File file) throws Throwable {
        Throwable ex = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        FilterInputStream dis = null;
        try {
            fis = new FileInputStream(file);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            String checkString = Misc.getString(dis, STARTSTRING.length());
            if (checkString.equals(STARTSTRING)) {
                boolean zipped = ((DataInputStream)dis).readBoolean();
                int version = ((DataInputStream)dis).readInt();
                if (version > 0) {
                    System.out.println("WARNING: This save file has been saved with a LATER version of this program! Loading might be impossible!");
                }
                if (zipped) {
                    ZipInputStream zis = new ZipInputStream(bis);
                    zis.getNextEntry();
                    DataInputStream dis2 = new DataInputStream(zis);
                    Throwable t = null;
                    try {
                        this.root.load(dis2);
                    }
                    catch (Throwable ta) {
                        t = ta;
                    }
                    try {
                        dis2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (t != null) {
                        throw t;
                    }
                } else {
                    this.root.load((DataInputStream)dis);
                }
            } else {
                throw new IOException("File must start with 'IoChunkSaveFile', but starts with '" + checkString + "'");
            }
            this.update();
        }
        catch (Throwable excp) {
            ex = excp;
        }
        try {
            if (dis != null) {
                dis.close();
            } else if (bis != null) {
                bis.close();
            } else if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void save(File file, boolean zipped) throws Throwable {
        DataOutputStream dos;
        BufferedOutputStream bos;
        FileOutputStream fos;
        Throwable ex;
        block18: {
            ex = null;
            fos = null;
            bos = null;
            dos = null;
            try {
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                dos = new DataOutputStream(bos);
                dos.write(Misc.stringToBytes(STARTSTRING));
                dos.writeBoolean(zipped);
                dos.writeInt(0);
                if (zipped) {
                    dos.flush();
                    ZipOutputStream zos = new ZipOutputStream(bos);
                    zos.setMethod(8);
                    zos.putNextEntry(new ZipEntry(""));
                    DataOutputStream dos2 = new DataOutputStream(zos);
                    Throwable t = null;
                    try {
                        this.root.save(dos2);
                    }
                    catch (Throwable ta) {
                        t = ta;
                    }
                    zos.closeEntry();
                    try {
                        dos2.flush();
                        dos2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        zos.flush();
                        zos.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (t != null) {
                        throw t;
                    }
                    break block18;
                }
                this.root.save(dos);
            }
            catch (Throwable excp) {
                ex = excp;
            }
        }
        try {
            if (dos != null) {
                dos.flush();
                dos.close();
            } else if (bos != null) {
                bos.flush();
                bos.close();
            } else if (fos != null) {
                fos.flush();
                fos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ex != null) {
            throw ex;
        }
    }

    public Chunk getRoot() {
        return this.root;
    }

    public void reset() {
        this.root = new Chunk(null, "Root", 0);
    }

    private void update() {
        this.root.fullLength = this.root.calculateFullLength();
    }

    public class Chunk {
        public static final int HEADER_SIZE = 18;
        private String fourCC;
        private short version;
        private byte[] data;
        private byte[] fourCCBytes;
        private Chunk[] subChunks;
        private Chunk parent;
        private int allSubChunks;
        private int fullLength;

        private Chunk(Chunk parent) {
            this.parent = parent;
        }

        private Chunk(Chunk parent, String fourCC, int version) {
            this(parent);
            this.setFourCC(fourCC);
            this.version = (short)version;
            this.subChunks = new Chunk[0];
            this.data = new byte[0];
        }

        public void setFourCC(String fourCC) {
            byte[] fccb = Misc.stringToBytes(fourCC);
            if (fccb.length != 4) {
                System.out.println("Error: The CC '" + fourCC + "' has " + fourCC.length() + " characters instead of  4");
                return;
            }
            this.fourCCBytes = fccb;
            this.fourCC = fourCC;
        }

        public void setVersion(int version) {
            this.version = (short)version;
        }

        public Chunk getParent() {
            return this.parent;
        }

        public int getSize() {
            return this.data.length;
        }

        public int getSizeFull() {
            return this.fullLength;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
            IoSaveFile.this.update();
        }

        public String getFourCC() {
            return this.fourCC;
        }

        public short getVersion() {
            return this.version;
        }

        public ChunkReader getReader() {
            return new ChunkReader(this);
        }

        public ChunkWriter getWriter() {
            return new ChunkWriter(this);
        }

        public Chunk createSubChunk(String fourCC, int version) {
            byte[] fccb = Misc.stringToBytes(fourCC);
            if (fccb.length != 4) {
                System.out.println("Error: The CC '" + fourCC + "' has " + fourCC.length() + " characters instead of  4");
                return null;
            }
            Chunk chunk = new Chunk(this, fourCC, version);
            Chunk[] old = this.subChunks;
            this.subChunks = new Chunk[old.length + 1];
            int i = 0;
            while (i < old.length) {
                this.subChunks[i] = old[i];
                ++i;
            }
            this.subChunks[this.subChunks.length - 1] = chunk;
            IoSaveFile.this.update();
            return chunk;
        }

        public void removeSubChunk(int idx) {
            if (idx < 0 || idx >= this.subChunks.length) {
                return;
            }
            Chunk[] old = this.subChunks;
            this.subChunks = new Chunk[old.length - 1];
            int i = 0;
            while (i < this.subChunks.length) {
                this.subChunks[i] = old[i < idx ? i : i + 1];
                ++i;
            }
            IoSaveFile.this.update();
        }

        public void swapChunks(int i1, int i2) {
            if (i1 == i2 || i1 < 0 || i2 < 0 || i1 >= this.subChunks.length || i2 >= this.subChunks.length) {
                return;
            }
            Chunk c = this.subChunks[i1];
            this.subChunks[i1] = this.subChunks[i2];
            this.subChunks[i2] = c;
        }

        public int getNumSubChunks() {
            return this.subChunks.length;
        }

        public int getNumSubChunksAll() {
            return this.allSubChunks;
        }

        public Chunk getChunk(int idx) {
            if (idx >= 0 && idx < this.subChunks.length) {
                return this.subChunks[idx];
            }
            return null;
        }

        public int getIndexOf(Chunk c) {
            int i = 0;
            while (i < this.subChunks.length) {
                if (c == this.subChunks[i]) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Chunk getSubChunk(String fourCC) {
            int i = 0;
            while (i < this.subChunks.length) {
                Chunk sc = this.subChunks[i];
                if (sc.getFourCC().equals(fourCC)) {
                    return sc;
                }
                ++i;
            }
            return null;
        }

        public void removeSubChunk(Chunk c) {
            this.removeSubChunk(this.getIndexOf(c));
        }

        public void clear() {
            this.subChunks = new Chunk[0];
            IoSaveFile.this.update();
        }

        private int calculateFullLength() {
            this.allSubChunks = this.subChunks.length;
            this.fullLength = this.data.length;
            int i = 0;
            while (i < this.subChunks.length) {
                this.fullLength += 18;
                this.fullLength += this.subChunks[i].calculateFullLength();
                this.allSubChunks += this.subChunks[i].allSubChunks;
                ++i;
            }
            return this.fullLength;
        }

        private void load(DataInputStream in) throws Throwable {
            this.fourCCBytes = new byte[4];
            in.readFully(this.fourCCBytes);
            this.fourCC = Misc.bytesToString(this.fourCCBytes);
            this.version = in.readShort();
            this.data = new byte[in.readInt()];
            this.fullLength = in.readInt();
            this.subChunks = new Chunk[in.readInt()];
            in.readFully(this.data);
            int i = 0;
            while (i < this.subChunks.length) {
                this.subChunks[i] = new Chunk(this);
                this.subChunks[i].load(in);
                ++i;
            }
        }

        private void save(DataOutputStream out) throws Throwable {
            out.write(this.fourCCBytes);
            out.writeShort(this.version);
            out.writeInt(this.data.length);
            out.writeInt(this.fullLength);
            out.writeInt(this.subChunks.length);
            out.write(this.data);
            int i = 0;
            while (i < this.subChunks.length) {
                this.subChunks[i].save(out);
                ++i;
            }
        }
    }

    public class ChunkReader {
        private Chunk chunk;
        private ByteArrayInputStream bais;
        private DataInputStream dis;

        private ChunkReader(Chunk chunk) {
            this.chunk = chunk;
            this.bais = new ByteArrayInputStream(chunk.data);
            this.dis = new DataInputStream(this.bais);
        }

        public int readInt() throws IOException {
            return this.dis.readInt();
        }

        public long readLong() throws IOException {
            return this.dis.readLong();
        }

        public boolean readBoolean() throws IOException {
            return this.dis.readBoolean();
        }

        public int read() throws IOException {
            return this.dis.read();
        }

        public byte readByte() throws IOException {
            return this.dis.readByte();
        }

        public short readShort() throws IOException {
            return this.dis.readShort();
        }

        public boolean[] readBools() throws IOException {
            return Misc.readByte(this.readByte());
        }

        public String readString1() throws IOException {
            return Misc.getString(this.dis, this.dis.read());
        }

        public void skip(int bytes) throws IOException {
            this.dis.skipBytes(bytes);
        }

        public void close() {
            int left = this.bais.available();
            if (IoSaveFile.this.debug && left > 0) {
                System.out.println("Reader of " + this.chunk.fourCC + " had " + left + " bytes left!");
            }
            try {
                this.dis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.bais.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class ChunkWriter {
        private Chunk chunk;
        private ByteArrayOutputStream baos;
        private DataOutputStream dos;

        private ChunkWriter(Chunk chunk) {
            this.chunk = chunk;
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
        }

        public void writeInt(int val) throws IOException {
            this.dos.writeInt(val);
        }

        public void writeLong(long val) throws IOException {
            this.dos.writeLong(val);
        }

        public void writeShort(int val) throws IOException {
            this.dos.writeShort(val);
        }

        public void writeFloat(float val) throws IOException {
            this.dos.writeFloat(val);
        }

        public void writeDouble(double val) throws IOException {
            this.dos.writeDouble(val);
        }

        public void write(int val) throws IOException {
            this.dos.write(val);
        }

        public void writeBoolean(boolean val) throws IOException {
            this.dos.writeBoolean(val);
        }

        public void writeBools(boolean ... vals) throws IOException {
            this.dos.writeByte(Misc.buildByte(vals));
        }

        public void writeByte(byte val) throws IOException {
            this.dos.writeByte(val);
        }

        public void writeString1(String str) throws IOException {
            this.dos.write(str.length());
            this.dos.write(Misc.stringToBytes(str));
        }

        public void fillBytes(int bytes) throws IOException {
            this.dos.write(new byte[bytes]);
        }

        public void close() {
            try {
                this.dos.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.dos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.chunk.data = this.baos.toByteArray();
            IoSaveFile.this.update();
        }
    }
}

