/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.server.objects;

import com.iosoft.fgalpha.server.FGAServer;
import com.iosoft.fgalpha.server.objects.GameObj;
import com.iosoftware.helpers.Vector2D;

public class SoundEmitter
extends GameObj {
    private int time;
    private int sound;
    private float radius = 300.0f;
    private float volume = 1.0f;
    private float balance = 0.0f;
    private int type;

    public SoundEmitter(int sound, int ticks, GameObj base, float radius) {
        this(sound, ticks, base.pos, radius);
    }

    public SoundEmitter(int sound, int ticks, Vector2D base, float radius) {
        this(1, sound, ticks);
        this.pos.x = base.x;
        this.pos.y = base.y;
        this.radius = radius;
    }

    public SoundEmitter(int type, int sound, int ticks) {
        this.type = type;
        this.sound = sound;
        this.time = ticks;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void setBalance(float balance) {
        this.balance = balance;
    }

    @Override
    public void tick() {
        --this.time;
        if (this.time < 0) {
            FGAServer.get().sendToAll(FGAServer.get().msgSound(this.type, this.sound, this.volume, this.balance, (float)this.pos.x, (float)this.pos.y, this.radius));
            this.exists = false;
        }
    }

    @Override
    public boolean serverside() {
        return true;
    }

    @Override
    public int getObjClassID() {
        return -1;
    }
}

