/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.server.objects;

import com.iosoft.fgalpha.server.objects.AI;
import com.iosoft.fgalpha.server.objects.Assault;
import com.iosoft.fgalpha.server.objects.Client;
import com.iosoft.fgalpha.server.objects.GameObj;
import com.iosoft.fgalpha.server.objects.MK14;
import com.iosoft.fgalpha.server.objects.Projectile;
import com.iosoft.fgalpha.server.objects.Shotgun;
import com.iosoft.fgalpha.server.objects.Sniper;
import com.iosoft.fgalpha.server.objects.SoundEmitter;
import com.iosoft.fgalpha.server.objects.Weapon;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.Vector2D;
import java.awt.geom.Rectangle2D;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Player
extends GameObj {
    public static final int ACTION_UP = 0;
    public static final int ACTION_DOWN = 1;
    public static final int ACTION_LEFT = 2;
    public static final int ACTION_RIGHT = 3;
    public static final int ACTION_SHOOT = 4;
    public static final int ACTION_RELOAD = 5;
    public static final int ACTION_PAUSE = 6;
    protected Weapon weapon;
    protected int myWeapon;
    protected int myExtra;
    protected int maxhp;
    protected int nr;
    protected int respawn;
    protected int hp;
    protected int kills;
    protected int assists;
    protected int deaths;
    protected int protection;
    protected int team;
    protected int weapontype;
    protected Player lastShotBy;
    protected Player supportShotBy;
    protected Vector2D tar;
    protected boolean dead;
    protected boolean connected;
    protected boolean notShot;
    protected boolean[] keys;
    protected boolean[] extras;
    protected String name;
    protected Rectangle2D.Double collisionBox = new Rectangle2D.Double(0.0, 0.0, 9.0, 9.0);

    public Player(int nr) {
        Player.map.players.add(this);
        this.extras = new boolean[8];
        this.resetExtras();
        this.maxhp = 100;
        this.team = srv.getGamemode() == 1 ? map.getWeakerTeam(this) : -1;
        this.hp = 0;
        this.kills = 0;
        this.assists = 0;
        this.deaths = 0;
        this.connected = true;
        this.myExtra = -1;
        this.myWeapon = -1;
        this.name = "";
        this.dead = true;
        this.respawn = 0;
        this.nr = nr;
        this.tar = new Vector2D(0.0, 0.0);
        this.keys = new boolean[10];
        this.resetKeys();
    }

    public void resetExtras() {
        int i = 0;
        while (i < this.extras.length) {
            this.extras[i] = false;
            ++i;
        }
    }

    @Override
    public void onRemove() {
        super.onRemove();
        Player.map.players.remove(this);
        if (this.weapon != null) {
            this.weapon.onDrop();
        }
    }

    protected void resetKeys() {
        int i = 0;
        while (i < this.keys.length) {
            this.keys[i] = false;
            ++i;
        }
    }

    protected void makeCollBox() {
        this.collisionBox.x = this.pos.x - this.collisionBox.width / 2.0;
        this.collisionBox.y = this.pos.y - this.collisionBox.height / 2.0;
    }

    protected boolean setColBox(double x, double y) {
        this.makeCollBox();
        this.collisionBox.x += x;
        this.collisionBox.y += y;
        return true;
    }

    @Override
    public void tick() {
        this.changedPos = true;
        this.validateShooters();
        this.makeCollBox();
        if (!this.connected) {
            return;
        }
        if (!this.keys[4]) {
            this.notShot = true;
        }
        if (this.dead) {
            --this.respawn;
            if (this.respawn <= 0) {
                this.respawn();
            }
        } else {
            int steps;
            if (this.protection > 0) {
                --this.protection;
                if (this.protection == 0) {
                    srv.sendToAll(srv.msgSetPlayerData(this));
                }
            }
            this.vel.x = 0.0;
            this.vel.y = 0.0;
            if (this.keys[0]) {
                this.vel.y -= 1.0;
            }
            if (this.keys[1]) {
                this.vel.y += 1.0;
            }
            if (this.keys[2]) {
                this.vel.x -= 1.0;
            }
            if (this.keys[3]) {
                this.vel.x += 1.0;
            }
            this.vel.normalizeSelf();
            this.vel.mulSelf(this.weapon == null ? 7.0 : this.weapon.getSpeed());
            if (this.extras[5]) {
                this.vel.mulSelf(1.3);
            }
            if (map.isRoad(this.pos)) {
                this.vel.mulSelf(1.2);
            }
            if ((steps = (int)Math.ceil(this.vel.getLength())) > 0) {
                double dx = this.vel.x / (double)steps;
                double dy = this.vel.y / (double)steps;
                int i = 0;
                while (i < steps) {
                    if (this.setColBox(dx, dy) && map.ok2Go(this.pos.x + dx, this.pos.y + dy, this.collisionBox)) {
                        this.pos.x += dx;
                        this.pos.y += dy;
                    } else if (this.setColBox(0.0, dy) && map.ok2Go(this.pos.x, this.pos.y + dy, this.collisionBox)) {
                        this.pos.y += dy;
                    } else if (this.setColBox(dx, 0.0) && map.ok2Go(this.pos.x + dx, this.pos.y, this.collisionBox)) {
                        this.pos.x += dx;
                    }
                    this.makeCollBox();
                    ++i;
                }
            }
            this.makeCollBox();
            if (this.weapon != null) {
                if (this.keys[5] && this.weapon.reload == 0 && this.weapon.ammo < this.weapon.getAmmo() + (this.extras[2] ? this.weapon.getBonusAmmo() : 0)) {
                    new SoundEmitter(this.weapon.getReloadSound(), 7, this, 300.0f);
                    this.weapon.reload = this.weapon.getReload() - (this.weapon.ammo > 0 ? 20 : 0);
                }
                this.weapon.pos.put(this.pos);
                this.weapon.vel.put(this.vel);
                this.weapon.rotation = this.rotation;
                if (this.keys[4] && (this.weapon != null && this.weapon.isAutomatic() || this.notShot)) {
                    this.notShot = false;
                    if (this.weapon.shoot()) {
                        srv.sendToAll(srv.msgSetPlayerData(this));
                    }
                }
            }
        }
    }

    public int getRelativeHealth() {
        return (int)((double)this.hp / (double)this.maxhp * 100.0);
    }

    public int getNr() {
        return this.nr;
    }

    protected void respawn() {
        this.resetExtras();
        int extra = this.myExtra == -1 ? Misc.getRandomInt(6) : this.myExtra;
        this.extras[extra] = true;
        this.weapontype = this.myWeapon == -1 ? Misc.getRandomInt(4) : this.myWeapon;
        this.maxhp = extra == 0 ? 150 : 100;
        this.hp = this.maxhp;
        this.lastShotBy = null;
        this.supportShotBy = null;
        this.protection = 75;
        this.dead = false;
        this.weapon = this.createMyWeapon();
        this.weapon.spawnbind(this);
        map.randomSpawn(this);
        this.rotation = Math.PI * 2 * Math.random();
        srv.sendToAll(srv.msgSetPos(this));
        srv.sendToAll(srv.msgSetPlayerData2(this));
        srv.sendToAll(srv.msgSetPlayerData(this));
        this.changedPos = true;
    }

    public void validateShooters() {
        if (this.lastShotBy != null && !this.lastShotBy.exists) {
            this.lastShotBy = null;
        }
        if (this.supportShotBy != null && !this.supportShotBy.exists) {
            this.supportShotBy = null;
        }
        if (this.lastShotBy == null && this.supportShotBy != null) {
            this.lastShotBy = this.supportShotBy;
        }
        if (this.lastShotBy == this.supportShotBy) {
            this.supportShotBy = null;
        }
    }

    public int getWeaponType() {
        if (this.weapon == null) {
            return 255;
        }
        return this.weapon.getID();
    }

    public void hurt(int dmg, Vector2D pos, Vector2D vel, Projectile source) {
        if (!this.connected || this.dead || this.protection > 0) {
            return;
        }
        this.validateShooters();
        int weaponID = 255;
        int attackerNr = 255;
        int supportNr = 255;
        Weapon attackWeapon = null;
        if (source != null) {
            attackWeapon = source.weapon;
        }
        if (attackWeapon != null) {
            weaponID = attackWeapon.getID();
            Player shooter = source.getShooter();
            if (shooter != null && this.lastShotBy != shooter) {
                this.supportShotBy = this.lastShotBy;
                this.lastShotBy = shooter;
            }
        }
        this.validateShooters();
        if (this.lastShotBy != null) {
            attackerNr = this.lastShotBy.nr;
        }
        if (this.supportShotBy != null) {
            supportNr = this.supportShotBy.nr;
        }
        this.vel.addSelf(vel);
        this.hp -= dmg;
        if (this.hp <= 0) {
            this.hp = 0;
            ++this.deaths;
            if (this.lastShotBy != null) {
                this.lastShotBy.kills = this.lastShotBy.kills + (srv.getGamemode() == 1 && this.team == this.lastShotBy.team ? -2 : 1);
            }
            if (this.supportShotBy != null && (srv.getGamemode() == 0 || this.team != this.supportShotBy.team)) {
                ++this.supportShotBy.assists;
            }
            if (this.weapon != null) {
                this.weapon.onDrop();
            }
            this.dead = true;
            this.respawn = 50;
            int i = 0;
            while (i < this.sounds.size()) {
                SoundEmitter s = (SoundEmitter)this.sounds.get(i);
                Player.map.objs.remove(s);
                ++i;
            }
            this.sounds.clear();
            srv.sendToAll(srv.msgKillfeed(attackerNr, supportNr, this.nr, weaponID));
        }
        srv.sendToAll(srv.msgSetPlayerData(this));
        if (this.supportShotBy != null) {
            srv.sendToAll(srv.msgSetPlayerData(this.supportShotBy));
        }
    }

    void doAction(int key, int action) {
        boolean down;
        boolean bl = down = action == 1;
        if (key == 0) {
            this.keys[0] = down;
        }
        if (key == 1) {
            this.keys[1] = down;
        }
        if (key == 2) {
            this.keys[2] = down;
        }
        if (key == 3) {
            this.keys[3] = down;
        }
        if (key == 4) {
            this.keys[4] = down;
        }
        if (key == 5) {
            this.keys[5] = down;
        }
        if (key == 6) {
            Client c;
            if (!this.keys[6] && down && this instanceof Client && (c = (Client)this).isAdmin()) {
                srv.togglePause();
            }
            this.keys[6] = down;
        }
    }

    void setMousePos(int x, int y) {
        this.tar.x = x;
        this.tar.y = y;
    }

    private Weapon createMyWeapon() {
        switch (this.weapontype) {
            case 0: {
                return new Assault();
            }
            case 1: {
                return new Shotgun();
            }
            case 2: {
                return new Sniper();
            }
            case 3: {
                return new MK14();
            }
        }
        return null;
    }

    @Override
    public void allInfo(DataOutputStream dos) throws IOException {
        super.allInfo(dos);
        dos.write(this.nr);
        dos.write(Misc.stringToBytes(this.name, 16));
        boolean[] blArray = new boolean[5];
        blArray[0] = this.dead;
        blArray[1] = this.connected;
        blArray[2] = this instanceof AI;
        boolean bl = blArray[3] = this.protection > 0;
        blArray[4] = this.team == -1 ? false : this.team == 1;
        dos.writeByte(Misc.buildByte(blArray));
        dos.write(this.getWeaponType());
        dos.write(this.getExtrasAsBytes());
        dos.write(this.getRelativeHealth());
        dos.write(this.getAmmo());
        dos.write(this.getReload());
        dos.writeInt(this.kills);
        dos.writeInt(this.assists);
        dos.writeInt(this.deaths);
    }

    @Override
    public int getObjClassID() {
        return 1;
    }

    public int getKills() {
        return this.kills;
    }

    public int getAssists() {
        return this.assists;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public int getTeam() {
        return this.team;
    }

    public int getProtection() {
        return this.protection;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void setTeam(int team) {
        this.team = team;
    }

    public void setMyWeapon(int weapon) {
        this.myWeapon = weapon;
    }

    public void setMyExtra(int extra) {
        this.myExtra = extra;
    }

    public void kill() {
        this.protection = 0;
        try {
            this.hurt(10000, Vector2D.zero, Vector2D.zero, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getAmmo() {
        if (this.weapon != null) {
            return this.weapon.ammo;
        }
        return 0;
    }

    public int getReload() {
        if (this.weapon != null) {
            if (this.weapon.reload > 255) {
                return 255;
            }
            return this.weapon.reload;
        }
        return 0;
    }

    public byte[] getExtrasAsBytes() {
        return Misc.buildBytes(this.extras, 1);
    }

    public String getIP() {
        return "";
    }

    public String getVersion() {
        return "v0.3.0";
    }

    public void kick(boolean banned) {
        this.exists = false;
        srv.removePlayer(this.nr, banned ? Client.DisconnectReason.BAN : Client.DisconnectReason.KICK, this.getVersion());
    }
}

