/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.server.objects;

import com.iosoft.fgalpha.FightgameAlpha;
import com.iosoft.fgalpha.client.ui.UserInterface;
import com.iosoft.fgalpha.server.FGAServer;
import com.iosoft.fgalpha.server.objects.Player;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.network.Connection;
import com.iosoftware.helpers.network.LocalConnection;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.Socket;

public class Client
extends Player {
    private static final int TIMEOUT_GREETING = 750;
    private static final int TIMEOUT_MSGS = 750;
    private static final int TIMEOUT_REMOVE = 25;
    private static final int TIME_NEXT_REQUEST = 25;
    private boolean needsTime;
    private boolean admin;
    private boolean pingSent;
    private boolean local;
    private ServerClientConnection connection;
    private ConnectionState connectionState;
    private int timeout;
    private int ping;
    private int nextPing;
    private long pingTime;
    private String ip;
    private String version;
    protected Object lock;

    private Client getClient() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client(Socket socket, int nr) {
        this(nr);
        Object object = this.lock;
        synchronized (object) {
            this.connection.bind(socket);
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client(LocalConnection localConnection, int nr) {
        this(nr);
        Object object = this.lock;
        synchronized (object) {
            this.connection.bind(localConnection);
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Client(int nr) {
        super(nr);
        Object object = this.lock = FGAServer.getLock();
        synchronized (object) {
            this.connected = false;
            this.nr = nr;
            this.local = false;
            this.needsTime = false;
            this.admin = false;
            this.pingSent = false;
            this.ping = -1;
            this.pingTime = -1L;
            this.nextPing = 0;
            this.version = "?";
            this.connectionState = ConnectionState.WAIT_FOR_GREETING;
            this.connection = new ServerClientConnection();
            this.connection.setBuffered(true);
            this.connection.setPrefix("Server");
        }
    }

    @Override
    public String getIP() {
        return this.ip;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = this.lock;
        synchronized (object) {
            this.pingTime = -1L;
            this.ping = -1;
            this.timeout = 750;
            if (this.connection.isLocal()) {
                this.admin = true;
                this.local = true;
            }
            try {
                this.ip = this.connection.getInetAddress().getHostAddress();
            }
            catch (Exception e) {
                this.ip = "?";
            }
            this.name = this.ip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaying() {
        Object object = this.lock;
        synchronized (object) {
            return this.exists && this.connectionState == ConnectionState.PLAYING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(byte[] data) {
        Object object = this.lock;
        synchronized (object) {
            this.connection.send(data);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.rotation = Misc.positionsToRotation(0.0, 0.0, this.tar.x, this.tar.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientTick() {
        Object object = this.lock;
        synchronized (object) {
            this.checkTimeout();
            if (this.connectionState == ConnectionState.PLAYING) {
                this.needsTime = !this.checkPing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.needsTime;
        }
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTimeout() {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                --this.timeout;
                if (this.timeout > 0) break block6;
                if (this.connectionState == ConnectionState.DISCONNECTING) {
                    this.connection.disconnect();
                    this.exists = false;
                } else {
                    this.clientDisconnect(DisconnectReason.TIMEOUT);
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPing() {
        Object object = this.lock;
        synchronized (object) {
            block6: {
                block5: {
                    if (this.nextPing <= 0) break block5;
                    --this.nextPing;
                    return true;
                }
                if (!this.pingSent) break block6;
                return false;
            }
            this.pingTime = System.nanoTime();
            this.pingSent = true;
            this.nextPing = 25;
            this.connection.send(FGAServer.get().msgPingrequest());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getPing() {
        Object object = this.lock;
        synchronized (object) {
            return (short)(this.ping > Short.MAX_VALUE ? Short.MAX_VALUE : this.ping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kick(boolean banned) {
        Object object = this.lock;
        synchronized (object) {
            this.clientDisconnect(banned ? DisconnectReason.BAN : DisconnectReason.KICK);
        }
    }

    @Override
    public void onRemove() {
        super.onRemove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientDisconnect(DisconnectReason reason) {
        Object object = this.lock;
        synchronized (object) {
            if (this.connectionState != ConnectionState.DISCONNECTING) {
                this.connectionState = ConnectionState.DISCONNECTING;
                if (reason == DisconnectReason.SERVERSTOP) {
                    this.connection.disconnect();
                    this.exists = false;
                    this.timeout = 0;
                } else {
                    if (Client.srv.dedicated) {
                        UserInterface.get().addChat("Client " + this.nr + " " + this.connection.getInetAddress().getHostAddress() + " disconnected!");
                    }
                    srv.removePlayer(this.nr, reason, this.getVersion());
                    if (reason.notifyClient()) {
                        this.timeout = 25;
                        this.send(srv.msgDisconnect(reason));
                    } else {
                        this.connection.disconnect();
                        this.exists = false;
                        this.timeout = 0;
                    }
                }
            } else {
                this.connection.disconnect();
                this.exists = false;
                this.timeout = 0;
            }
        }
    }

    public String makeNameValid(String name) {
        if (name == null || name.equals("")) {
            try {
                name = this.connection.getInetAddress().getHostName();
            }
            catch (Exception ex) {
                name = "[unknown]";
            }
        }
        if (map.getPlayerByName(this, name) != null) {
            String tn;
            int i = 0;
            while (map.getPlayerByName(this, tn = Misc.trimString(++i + name, 16)) != null) {
            }
            return tn;
        }
        return name;
    }

    @Override
    public boolean serverside() {
        return this.connectionState == ConnectionState.DISCONNECTING;
    }

    private static enum ConnectionState {
        WAIT_FOR_GREETING,
        PLAYING,
        DISCONNECTING;

    }

    public static enum DisconnectReason {
        KICK,
        BAN,
        PROTOCOL_ERROR,
        TIMEOUT,
        LEFT,
        CONNECTION_LOST,
        WRONG_VERSION,
        SERVERSTOP;


        public int getRemoveReason() {
            switch (this) {
                case KICK: {
                    return 0;
                }
                case BAN: {
                    return 1;
                }
                case PROTOCOL_ERROR: {
                    return 2;
                }
                case TIMEOUT: {
                    return 3;
                }
                case LEFT: {
                    return 4;
                }
                case CONNECTION_LOST: {
                    return 5;
                }
                case WRONG_VERSION: {
                    return 6;
                }
            }
            return 255;
        }

        public boolean notifyClient() {
            return this == KICK || this == BAN || this == WRONG_VERSION;
        }

        public int whyIKickYou() {
            switch (this) {
                case KICK: {
                    return 0;
                }
                case BAN: {
                    return 1;
                }
                case WRONG_VERSION: {
                    return 2;
                }
            }
            return 255;
        }
    }

    private class ServerClientConnection
    extends Connection {
        private ServerClientConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onDisconnected() {
            Object object = Client.this.lock;
            synchronized (object) {
                System.out.println("Server: Client disconnect");
                Client.this.clientDisconnect(DisconnectReason.CONNECTION_LOST);
            }
        }

        private boolean checkGreeting() {
            if (Client.this.connectionState == ConnectionState.WAIT_FOR_GREETING) {
                System.out.println("Client " + Client.this.nr + " sent a message but hasn't greeted yet!");
                Client.this.clientDisconnect(DisconnectReason.PROTOCOL_ERROR);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void receiving(InputStream pin) throws Exception {
            int msgType;
            DataInputStream in = new DataInputStream(pin);
            block23: while (true) {
                msgType = in.read();
                switch (msgType) {
                    case 1: {
                        String sVerify = Misc.getString(in, "FGA Client".length());
                        String sVersion = Misc.getString(in, 10);
                        String sName = Misc.getString(in, 16);
                        int iWeapon = Misc.read(in);
                        int iExtra = Misc.read(in);
                        int iTeam = Misc.read(in);
                        Object object = Client.this.lock;
                        synchronized (object) {
                            Client.this.connected = true;
                            if (Client.this.connectionState != ConnectionState.WAIT_FOR_GREETING) {
                                System.out.println("Client " + Client.this.nr + " sent greeting but has greeted already!");
                                Client.this.clientDisconnect(DisconnectReason.PROTOCOL_ERROR);
                                return;
                            }
                            Client.this.timeout = 750;
                            if (!sVerify.equals("FGA Client")) {
                                System.out.println("Client " + Client.this.nr + " sent verify '" + sVerify + "' instead of '" + "FGA Client" + "'.");
                                Client.this.clientDisconnect(DisconnectReason.PROTOCOL_ERROR);
                                return;
                            }
                            Client.this.version = sVersion;
                            if (!FightgameAlpha.isCompatible(sVersion)) {
                                System.out.println(String.valueOf(Client.this.name) + " (" + Client.this.nr + ") has an incompatible version (" + sVersion + ").");
                                Client.this.clientDisconnect(DisconnectReason.WRONG_VERSION);
                                this.loopAndDispose(in);
                                return;
                            }
                            Client.this.myWeapon = iWeapon;
                            if (Client.this.myWeapon > 3) {
                                Client.this.myWeapon = -1;
                            }
                            Client.this.myExtra = iExtra;
                            if (Client.this.myExtra > 5) {
                                Client.this.myExtra = -1;
                            }
                            Client.this.team = iTeam;
                            --Client.this.team;
                            if (Client.this.team < 0 || Client.this.team > 1) {
                                Client.this.team = map.getWeakerTeam(Client.this.getClient());
                            }
                            Client.this.name = Client.this.makeNameValid(sName.trim());
                            this.send(srv.msgGreeting(Client.this.getClient()));
                            srv.sendToAll(srv.msgAddObj(Client.this.getClient()));
                            Client.this.connectionState = ConnectionState.PLAYING;
                            if (Client.this.local) {
                                srv.networkMayNowStart();
                            }
                            if (Client.srv.dedicated) {
                                UserInterface.get().addChat("Client " + Client.this.nr + " " + this.getInetAddress().getHostAddress() + " connected! (" + Client.this.name + ")");
                            }
                            continue block23;
                        }
                    }
                    case 2: {
                        Object object = Client.this.lock;
                        synchronized (object) {
                            if (this.checkGreeting()) {
                                return;
                            }
                            Client.this.timeout = 750;
                            if (!Client.this.pingSent) {
                                System.out.println("Client " + Client.this.nr + " sent pinganswer without previous request. Kick!");
                                Client.this.clientDisconnect(DisconnectReason.PROTOCOL_ERROR);
                                return;
                            }
                            Client.this.ping = (int)((System.nanoTime() - Client.this.pingTime) / 1000000L);
                            Client.this.pingSent = false;
                            Client.this.nextPing = 25;
                            srv.sendToAll(srv.msgPing(Client.this.getClient()));
                            continue block23;
                        }
                    }
                    case 3: {
                        int iLength = in.read();
                        String sMsg = Misc.getString(in, iLength);
                        Object object = Client.this.lock;
                        synchronized (object) {
                            if (this.checkGreeting()) {
                                return;
                            }
                            if ((sMsg = sMsg.trim()).length() > 0) {
                                srv.processChat(Client.this.getClient(), sMsg);
                            }
                            continue block23;
                        }
                    }
                    case 4: {
                        int key = Misc.read(in);
                        int action = Misc.read(in);
                        Object object = Client.this.lock;
                        synchronized (object) {
                            if (this.checkGreeting()) {
                                return;
                            }
                            Client.this.doAction(key, action);
                            continue block23;
                        }
                    }
                    case 5: {
                        short x = in.readShort();
                        short y = in.readShort();
                        Object object = Client.this.lock;
                        synchronized (object) {
                            if (this.checkGreeting()) {
                                return;
                            }
                            Client.this.setMousePos(x, y);
                        }
                    }
                    continue block23;
                    case -1: {
                        Client.this.clientDisconnect(DisconnectReason.CONNECTION_LOST);
                        return;
                    }
                }
                break;
            }
            System.out.println("Server received strange message: " + msgType);
            Client.this.clientDisconnect(DisconnectReason.PROTOCOL_ERROR);
        }
    }
}

