/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.server.objects;

import com.iosoft.fgalpha.server.Map;
import com.iosoft.fgalpha.server.objects.GameObj;
import com.iosoft.fgalpha.server.objects.MK14;
import com.iosoft.fgalpha.server.objects.Player;
import com.iosoft.fgalpha.server.objects.Sniper;
import com.iosoftware.helpers.Misc;
import java.util.ArrayList;
import java.util.List;

public class AI
extends Player {
    protected int next;
    protected int nextShoot;
    protected double tarRot;
    protected List<Map.PathNode> path = new ArrayList<Map.PathNode>();
    protected Player target;
    private static List<String> aiNameList = new ArrayList<String>();

    static {
        AI.reinitNames();
    }

    public AI(int nr) {
        super(nr);
        this.pos.x = Math.random() * 100.0;
        this.pos.y = Math.random() * 100.0;
        this.name = this.getRandomAiName();
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.dead) {
            this.rotation += Misc.rotateStep(this.rotation, this.tarRot, 0.1);
            if (this.next > 0) {
                --this.next;
                if (this.next == 0) {
                    this.resetKeys();
                    if (!this.isValidTarget(this.target) || Misc.getRandomInt(3) == 0) {
                        this.target = this.getNewTarget();
                    }
                    this.next = 25 + Misc.getRandomInt(50);
                    if (this.target == null) {
                        this.tarRot = Math.random() * Math.PI * 2.0;
                    }
                    if (Misc.getRandomBool()) {
                        if (Misc.getRandomBool()) {
                            this.doAction(0, 1);
                        } else {
                            this.doAction(1, 1);
                        }
                    }
                    if (Misc.getRandomBool()) {
                        if (Misc.getRandomBool()) {
                            this.doAction(2, 1);
                        } else {
                            this.doAction(3, 1);
                        }
                    }
                }
            }
            if (this.target != null) {
                this.tarRot = Misc.positionsToRotation(this.pos.x, this.pos.y, this.target.pos.x, this.target.pos.y);
            }
            if (this.nextShoot > 0) {
                --this.nextShoot;
                if (this.nextShoot == 0) {
                    this.doAction(4, 0);
                }
            }
            if (this.weapon instanceof MK14) {
                this.doAction(4, Misc.getRandomInt(2));
            } else if (this.target != null && Misc.getRandomInt(50) == 0 || this.weapon instanceof Sniper && Misc.getRandomInt(40) == 0 || this.target == null && Misc.getRandomInt(100) == 0) {
                this.nextShoot = 10 + Misc.getRandomInt(50);
                this.doAction(4, 1);
            }
        }
    }

    @Override
    protected void respawn() {
        super.respawn();
        this.resetKeys();
        this.path.clear();
        this.next = 25;
        this.tarRot = this.rotation;
    }

    protected Player getNewTarget() {
        ArrayList<Player> pls = new ArrayList<Player>();
        int iC = AI.map.objs.size();
        int i = 0;
        while (i < iC) {
            Player p;
            GameObj o = AI.map.objs.get(i);
            if (o instanceof Player && this.isValidTarget(p = (Player)o)) {
                pls.add(p);
            }
            ++i;
        }
        if (pls.size() == 0) {
            return null;
        }
        return (Player)pls.get(Misc.getRandomInt(pls.size()));
    }

    protected boolean isValidTarget(Player p) {
        return p != null && p != this && p.connected && !p.dead && (this.team == -1 || p.team != this.team) && p.protection == 0 && p.pos.getDist(this.pos) < 400.0;
    }

    public static void reinitNames() {
        aiNameList.clear();
        aiNameList.add("G\u00fcnther");
        aiNameList.add("Thorsten");
        aiNameList.add("Reinhard");
        aiNameList.add("Winfried");
        aiNameList.add("Piet");
        aiNameList.add("Theodor");
        aiNameList.add("Rudolf");
        aiNameList.add("Sepp");
        aiNameList.add("Kasimir");
        aiNameList.add("Gudrun");
        aiNameList.add("Lukas");
        aiNameList.add("Thomas");
        aiNameList.add("Quentin");
        aiNameList.add("Samuel");
        aiNameList.add("Wilhelm");
        aiNameList.add("Rosalinde");
        aiNameList.add("Siegmund");
        aiNameList.add("Horst");
        aiNameList.add("Kurt");
        aiNameList.add("Udo");
        aiNameList.add("Hildegard");
        aiNameList.add("Peter");
        aiNameList.add("Hans");
        aiNameList.add("J\u00f6rg");
        aiNameList.add("Norbert");
        aiNameList.add("Hagen");
    }

    private String getRandomAiName() {
        int c = aiNameList.size();
        if (c == 0) {
            return "AI" + this.nr;
        }
        return aiNameList.remove(Misc.getRandomInt(c));
    }
}

