/*
 * Decompiled with CFR 0.152.
 */
package com.iosoft.fgalpha.server;

import com.iosoft.fgalpha.FightgameAlpha;
import com.iosoft.fgalpha.client.FGAClient;
import com.iosoft.fgalpha.client.ui.UserInterface;
import com.iosoft.fgalpha.server.DedicatedInfo;
import com.iosoft.fgalpha.server.Map;
import com.iosoft.fgalpha.server.objects.AI;
import com.iosoft.fgalpha.server.objects.Client;
import com.iosoft.fgalpha.server.objects.GameObj;
import com.iosoft.fgalpha.server.objects.Player;
import com.iosoftware.helpers.DataHelper;
import com.iosoftware.helpers.Misc;
import com.iosoftware.helpers.Ticker;
import com.iosoftware.helpers.network.Connection;
import com.iosoftware.helpers.network.Listener;
import com.iosoftware.helpers.network.LocalConnection;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class FGAServer {
    private GameServerListener serverListener;
    private DataHelper dh = new DataHelper();
    private DataOutputStream dos = this.dh.getStream();
    private int port;
    private int maxClients;
    private int dediTick = 25;
    private int gamemode;
    private boolean running;
    private boolean network;
    private boolean friendlyfire;
    public boolean dedicated;
    public boolean paused;
    public boolean laggerStop;
    public Client[] clients;
    private Object lock = new Object();
    private Ticker ticker;
    private Map map;
    private String rconPassword;
    private long startTime;
    private List<Client> needsTime = new ArrayList<Client>();
    private List<Client> neededTime = new ArrayList<Client>();
    private static FGAServer inst;

    public static FGAServer get() {
        if (inst == null) {
            inst = new FGAServer();
        }
        return inst;
    }

    public static Object getLock() {
        return FGAServer.inst.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FGAServer() {
        Object object = this.lock;
        synchronized (object) {
            this.ticker = new Ticker("Server Ticker", 25L, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = FGAServer.this.lock;
                        synchronized (object) {
                            FGAServer.this.neededTime.clear();
                            FGAServer.this.neededTime.addAll(FGAServer.this.needsTime);
                            FGAServer.this.needsTime.clear();
                            if (FGAServer.this.running) {
                                Player p;
                                int i = 0;
                                while (i < FGAServer.this.clients.length) {
                                    Client c = FGAServer.this.clients[i];
                                    if (c != null) {
                                        c.clientTick();
                                        if (!c.exists()) {
                                            FGAServer.this.clients[i] = null;
                                        } else if (c.needsTime()) {
                                            FGAServer.this.needsTime.add(c);
                                        }
                                    }
                                    ++i;
                                }
                                int iC = FGAServer.this.neededTime.size();
                                int i2 = 0;
                                while (i2 < iC) {
                                    p = (Player)FGAServer.this.neededTime.get(i2);
                                    if (FGAServer.this.needsTime.indexOf(p) == -1) {
                                        FGAServer.this.sendToAll(FGAServer.this.msgLaggerend(p.getNr()));
                                        FGAServer.this.neededTime.remove(i2);
                                        --i2;
                                        --iC;
                                    }
                                    ++i2;
                                }
                                iC = FGAServer.this.needsTime.size();
                                i2 = 0;
                                while (i2 < iC) {
                                    p = (Player)FGAServer.this.needsTime.get(i2);
                                    if (FGAServer.this.neededTime.indexOf(p) == -1) {
                                        FGAServer.this.sendToAll(FGAServer.this.msgLagger(p.getNr()));
                                    }
                                    ++i2;
                                }
                                if (!(FGAServer.this.paused || FGAServer.this.laggerStop && FGAServer.this.needsTime.size() != 0)) {
                                    FGAServer.this.map.tick();
                                    int i3 = 0;
                                    while (i3 < FGAServer.this.clients.length) {
                                        Client c = FGAServer.this.clients[i3];
                                        if (c != null && c.isPlaying()) {
                                            c.send(FGAServer.this.msgTick(c));
                                        }
                                        ++i3;
                                    }
                                }
                                FGAServer fGAServer = FGAServer.this;
                                fGAServer.dediTick = fGAServer.dediTick - 1;
                                if (FGAServer.this.dediTick <= 0) {
                                    FGAServer.this.dediTick = 25;
                                    if (FGAServer.this.dedicated) {
                                        UserInterface.get().setDedicatedInfo(FGAServer.this.getDedicatedInfo());
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        UserInterface.onError(ex);
                    }
                }
            });
            this.serverListener = new GameServerListener();
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                this.running = false;
                this.port = 2738;
                this.serverListener.setTcpNodelay(true);
                this.serverListener.setReuse(true);
                this.serverListener.setPort(this.port);
                this.needsTime.clear();
                this.neededTime.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                this.serverListener.stop();
                this.ticker.stop();
                this.running = false;
                int i = 0;
                while (i < this.clients.length) {
                    Client c = this.clients[i];
                    if (c != null) {
                        c.clientDisconnect(Client.DisconnectReason.SERVERSTOP);
                        c = null;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean network, int port, int maxClients, String map, int gamemode, boolean friendlyfire, boolean tcpNodelay, int numBots, boolean dedicated) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.running) {
                this.gamemode = gamemode;
                this.friendlyfire = friendlyfire;
                this.startTime = System.nanoTime();
                AI.reinitNames();
                GameObj.srv = this;
                try {
                    this.map = new Map(map);
                    this.map.srv = this;
                    GameObj.map = this.map;
                    System.out.println("Map loaded!");
                }
                catch (Exception ex) {
                    System.out.println("Error while loading map. Server not started!");
                    System.exit(-1);
                }
                this.init();
                this.paused = false;
                this.rconPassword = dedicated ? FightgameAlpha.get().getRconPassword() : "";
                this.laggerStop = FightgameAlpha.get().getLaggerstop();
                this.ticker.start(true);
                this.running = true;
                this.port = port;
                this.network = network;
                if (maxClients <= 0) {
                    maxClients = 1;
                }
                if (maxClients > 255) {
                    maxClients = 255;
                }
                this.maxClients = maxClients;
                if (numBots < 0) {
                    numBots = 0;
                }
                if (numBots + maxClients > 255) {
                    numBots = 255 - maxClients;
                }
                this.serverListener.setPort(port);
                this.clients = new Client[maxClients];
                int i = 0;
                while (i < numBots) {
                    this.addBot(null, this.map.getWeakerTeam(null));
                    ++i;
                }
                this.dedicated = dedicated;
                if (dedicated) {
                    this.networkMayNowStart();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void networkMayNowStart() {
        Object object = this.lock;
        synchronized (object) {
            if (this.running && this.network) {
                if (!this.serverListener.start()) {
                    System.out.println("Server Listener could not be started!");
                    FGAClient.get().onNetworkError();
                    this.stop();
                } else {
                    System.out.println("Server Listener running on port " + this.port + ", nodelay=true");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGamemode() {
        Object object = this.lock;
        synchronized (object) {
            return this.gamemode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFF() {
        Object object = this.lock;
        synchronized (object) {
            return this.friendlyfire;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectLocal(LocalConnection localConnection) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                System.out.println("Client returned LocalConnection...");
                if (localConnection != null) {
                    Client c;
                    this.clients[0] = c = new Client(localConnection, 0);
                }
            }
        }
    }

    public void sendToAll(byte[] data) {
        int i = 0;
        while (i < this.clients.length) {
            Client c = this.clients[i];
            if (c != null && c.isPlaying()) {
                c.send(data);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DedicatedInfo getDedicatedInfo() {
        Object object = this.lock;
        synchronized (object) {
            DedicatedInfo info = new DedicatedInfo();
            info.gamemode = this.gamemode;
            info.mapname = this.map.name;
            info.time = (System.nanoTime() - this.startTime) / 1000000000L;
            info.numObjs = this.map.objs.size();
            info.maxPlayers = this.clients.length;
            ArrayList<DedicatedInfo.Player> pls = new ArrayList<DedicatedInfo.Player>();
            int iC = this.map.objs.size();
            int numHumans = 0;
            int i = 0;
            while (i < iC) {
                GameObj o = this.map.objs.get(i);
                if (o instanceof Player) {
                    Player p = (Player)o;
                    DedicatedInfo.Player pl = new DedicatedInfo.Player();
                    pls.add(pl);
                    pl.nr = p.getNr();
                    pl.name = p.isConnected() ? p.getName() : null;
                    pl.deaths = p.getDeaths();
                    pl.kills = p.getKills();
                    if (p instanceof Client) {
                        Client c = (Client)p;
                        pl.admin = c.isAdmin();
                        pl.version = c.getVersion();
                        pl.ping = c.getPing();
                        pl.ip = c.getIP();
                        ++numHumans;
                    }
                }
                ++i;
            }
            int num = pls.size();
            info.numHumans = numHumans;
            info.players = new DedicatedInfo.Player[num];
            pls.toArray(info.players);
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.lock;
        synchronized (object) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMap() {
        Object object = this.lock;
        synchronized (object) {
            return this.map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgGreeting(Client c) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(127);
                this.dos.writeBytes("FGA Server");
                this.dos.write(Misc.stringToBytes("v0.3.0", 10));
                this.dos.write(this.maxClients);
                this.dos.write(c.getNr());
                this.dos.write(this.gamemode);
                this.dos.writeByte(Misc.buildByte(this.paused));
                String mapname = Misc.trimString(this.map.name, 255);
                this.dos.write(mapname.length());
                this.dos.write(Misc.stringToBytes(mapname, mapname.length()));
                String mapname2 = Misc.trimString(this.map.uiName, 255);
                this.dos.write(mapname2.length());
                this.dos.write(Misc.stringToBytes(mapname2, mapname2.length()));
                int iC = this.map.objs.size();
                this.dos.writeInt(this.map.countNonServersided());
                int i = 0;
                while (i < iC) {
                    GameObj o = this.map.objs.get(i);
                    if (!o.serverside()) {
                        o.allInfo(this.dos);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgSetPos(GameObj obj) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(134);
                this.dos.writeInt(obj.id);
                this.dos.writeFloat((float)obj.pos.x);
                this.dos.writeFloat((float)obj.pos.y);
                this.dos.writeShort(obj.getRotationForClient());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgRemoveObj(GameObj o) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(140);
                this.dos.writeInt(o.id);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgKillfeed(int killer, int supportKiller, int victim, int weapon) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(143);
                this.dos.write(killer);
                this.dos.write(supportKiller);
                this.dos.write(victim);
                this.dos.write(weapon);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgChat(int pl, String msg) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(142);
                this.dos.write(pl);
                msg = Misc.trimString(msg, 40);
                this.dos.write(msg.length());
                this.dos.write(Misc.stringToBytes(msg));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgSetPlayerData(Player p) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(130);
                this.dos.write(p.getNr());
                this.dos.writeByte(Misc.buildByte(p.isDead(), p.getProtection() > 0));
                this.dos.write(p.getRelativeHealth());
                this.dos.write(p.getAmmo());
                this.dos.write(p.getReload());
                this.dos.writeInt(p.getKills());
                this.dos.writeInt(p.getAssists());
                this.dos.writeInt(p.getDeaths());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgSetPlayerData2(Player p) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(139);
                this.dos.write(p.getNr());
                this.dos.write(p.getWeaponType());
                this.dos.write(p.getExtrasAsBytes());
                this.dos.write(p.getTeam() < 0 ? 0 : p.getTeam());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgTick(Client client) {
        Object object = this.lock;
        synchronized (object) {
            try {
                int iC = this.map.objs.size();
                int i = 0;
                while (i < iC) {
                    GameObj o = this.map.objs.get(i);
                    if (!o.serverside() && o.changedPos()) {
                        this.dos.write(this.msgSetPos(o));
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgRemovePlayer(int nr, Client.DisconnectReason reason, String version) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(131);
                this.dos.write(nr);
                this.dos.write(reason.getRemoveReason());
                if (reason.getRemoveReason() == 6) {
                    this.dos.write(Misc.stringToBytes(version, 10));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgSound(int type, int sound, float volume, float balance, float x, float y, float radius) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(138);
                this.dos.write(type);
                this.dos.write(sound);
                this.dos.write(FGAServer.makeVolume(volume));
                switch (type) {
                    case 0: {
                        this.dos.write(FGAServer.makeBalance(balance));
                        break;
                    }
                    case 1: {
                        this.dos.writeFloat(x);
                        this.dos.writeFloat(y);
                        this.dos.writeFloat(radius);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgHitmarker(int strength) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(144);
                this.dos.write(strength);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgAddObj(GameObj o) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(141);
                o.allInfo(this.dos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgConnecting(Player p) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(135);
                this.dos.writeInt(p.id);
                this.dos.write(p.getNr());
                this.dos.write(Misc.stringToBytes(p.getIP(), 16));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgLagger(int nr) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(136);
                this.dos.write(nr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgMisc(int misc) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(145);
                this.dos.write(misc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgLaggerend(int nr) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(137);
                this.dos.write(nr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgSetName(Player p) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(146);
                this.dos.write(p.getNr());
                this.dos.write(Misc.stringToBytes(p.getName(), 16));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgPingrequest() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(128);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgPing(Client c) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(129);
                this.dos.write(c.getNr());
                this.dos.writeShort(c.getPing());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgDisconnect(Client.DisconnectReason reason) {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(132);
                this.dos.write(reason.whyIKickYou());
                this.dos.write(Misc.stringToBytes("v0.3.0", 10));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] msgServerIsFull() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.dos.write(133);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.dh.doIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFreeSlot() {
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while (i < this.clients.length) {
                if (this.clients[i] == null) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(int nr, Client.DisconnectReason reason, String version) {
        Object object = this.lock;
        synchronized (object) {
            if (this.clients.length > nr) {
                this.clients[nr] = null;
            }
            this.sendToAll(this.msgRemovePlayer(nr, reason, version));
        }
    }

    public void playSound(int sound, Player to) {
        this.playSound(sound, 1.0f, 0.0f, to);
    }

    public void playSound(int sound, float volume, float balance, Player to) {
        byte[] msg = this.msgSound(0, sound, volume, balance, 0.0f, 0.0f, 0.0f);
        this.doSending(msg, to);
    }

    public void playSoundPos(int sound, float volume, double x, double y, float radius) {
        this.sendToAll(this.msgSound(1, sound, volume, 0.0f, (float)x, (float)y, radius));
    }

    public void doSending(byte[] msg, Player to) {
        if (to == null) {
            this.sendToAll(msg);
        } else if (to instanceof Client) {
            ((Client)to).send(msg);
        }
    }

    private static int makeVolume(float volume) {
        int vol = (int)(volume * 255.0f);
        if (vol < 0) {
            vol = 0;
        } else if (vol >= 255) {
            vol = 255;
        }
        return vol;
    }

    private static int makeBalance(float balance) {
        int bal = (int)(127.0f + balance * 128.0f);
        if (bal < 0) {
            bal = 0;
        } else if (bal >= 255) {
            bal = 255;
        }
        return bal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChat(Client client, String sMsg) {
        Object object = this.lock;
        synchronized (object) {
            if (this.dedicated) {
                UserInterface.get().addChat(String.valueOf(client == null ? "(console)" : client.getName()) + ": " + sMsg);
            }
            boolean command = false;
            if (client != null) {
                if (sMsg.startsWith("/weapon ")) {
                    command = true;
                    int wpn = Misc.getAsInt(sMsg.substring(8));
                    if (wpn < 0) {
                        wpn = 0;
                    } else if (wpn > 3) {
                        wpn = 3;
                    }
                    client.setMyWeapon(wpn);
                } else if (sMsg.startsWith("/randomweapon")) {
                    command = true;
                    client.setMyWeapon(-1);
                } else if (sMsg.startsWith("/extra ")) {
                    command = true;
                    int xtra = Misc.getAsInt(sMsg.substring(7));
                    if (xtra < 0) {
                        xtra = 0;
                    } else if (xtra > 5) {
                        xtra = 5;
                    }
                    client.setMyExtra(xtra);
                } else if (sMsg.startsWith("/randomextra")) {
                    command = true;
                    client.setMyExtra(-1);
                } else if (sMsg.startsWith("/kill")) {
                    command = true;
                    client.kill();
                } else if (sMsg.startsWith("/changeteam")) {
                    command = true;
                    client.kill();
                    client.setTeam(client.getTeam() == 0 ? 1 : 0);
                } else if (sMsg.startsWith("/rcon ")) {
                    command = true;
                    String checkPW = sMsg.substring(6).trim();
                    if (!this.rconPassword.equals("") && checkPW.equals(this.rconPassword)) {
                        client.setAdmin(true);
                        client.send(this.msgChat(255, "RconAuth success: You are now op!"));
                    } else {
                        client.send(this.msgChat(255, "RconAuth failed: Wrong password!"));
                    }
                }
            }
            if (!command && client == null || client.isAdmin()) {
                if (sMsg.startsWith("/status")) {
                    command = true;
                    if (client != null) {
                        client.send(this.msgChat(255, "Status:"));
                    } else {
                        UserInterface.get().addChat("Status:");
                    }
                    int iC = this.map.players.size();
                    int i = 0;
                    while (i < iC) {
                        Player p = this.map.players.get(i);
                        if (client != null) {
                            client.send(this.msgChat(255, String.valueOf(p.getName()) + " - " + p.getNr() + " - " + p.getIP()));
                        } else {
                            UserInterface.get().addChat(String.valueOf(p.getName()) + " - " + p.getNr() + " - " + p.getIP());
                        }
                        ++i;
                    }
                } else if (sMsg.startsWith("/kick ")) {
                    command = true;
                    int nr = Misc.getAsInt(sMsg.substring(6));
                    Player p = this.map.getPlayerByNr(nr);
                    if (p != null) {
                        p.kick(false);
                    } else if (client != null) {
                        client.send(this.msgChat(255, "Player " + nr + " is not valid!"));
                    } else {
                        UserInterface.get().addChat("Player " + nr + " is not valid!");
                    }
                } else if (sMsg.startsWith("/addbot ")) {
                    command = true;
                    int team = Misc.getAsInt(sMsg.substring(8));
                    if (team > 1) {
                        team = 1;
                    } else if (team < 0) {
                        team = 0;
                    }
                    this.addBot(client, team);
                } else if (sMsg.startsWith("/addbot")) {
                    command = true;
                    this.addBot(client, this.map.getWeakerTeam(null));
                } else if (sMsg.startsWith("/setrcon")) {
                    command = true;
                    String newPW = "";
                    if (sMsg.startsWith("/setrcon ")) {
                        newPW = sMsg.substring(9).trim();
                    }
                    this.rconPassword = newPW;
                    if (client != null) {
                        client.send(this.msgChat(255, this.rconPassword.equals("") ? "RconAuth has been UNSET!" : "RconAuth changed to '" + this.rconPassword + "'"));
                    } else {
                        UserInterface.get().addChat(this.rconPassword.equals("") ? "RconAuth has been UNSET!" : "RconAuth changed to '" + this.rconPassword + "'");
                    }
                    FightgameAlpha.get().setExtendedOptions(this.laggerStop, this.rconPassword);
                } else if (sMsg.startsWith("/laggerstop ")) {
                    command = true;
                    this.laggerStop = sMsg.substring(12).equals("1");
                    if (client != null) {
                        client.send(this.msgChat(255, "Pause for laggers: " + this.laggerStop));
                    } else {
                        UserInterface.get().addChat("Pause for laggers: " + this.laggerStop);
                    }
                    FightgameAlpha.get().setExtendedOptions(this.laggerStop, this.rconPassword);
                } else if (sMsg.startsWith("/op ")) {
                    command = true;
                    int nr = Misc.getAsInt(sMsg.substring(4));
                    if (nr >= 0 && nr < this.clients.length && this.clients[nr] != null) {
                        Client c = this.clients[nr];
                        if (!c.isAdmin()) {
                            c.setAdmin(true);
                            c.send(this.msgChat(255, "You are an admin now!"));
                            if (client != null) {
                                client.send(this.msgChat(255, String.valueOf(c.getNr()) + " got opped!"));
                            }
                        } else if (client != null) {
                            client.send(this.msgChat(255, String.valueOf(c.getNr()) + " is already opped!"));
                        }
                    } else if (client != null) {
                        client.send(this.msgChat(255, "Client " + nr + " is not valid!"));
                    }
                }
            }
            if (!command) {
                this.sendToAll(this.msgChat(client == null ? 255 : client.getNr(), sMsg));
            }
        }
    }

    private void addBot(Client invoker, int team) {
        int newnr = this.clients.length;
        while (this.map.getPlayerByNr(newnr) != null) {
            if (newnr == 254) {
                if (invoker != null) {
                    invoker.send(this.msgChat(255, "Could not add bot, server is full!"));
                }
                return;
            }
            ++newnr;
        }
        AI bot = new AI(newnr);
        bot.setTeam(team);
        this.sendToAll(this.msgAddObj(bot));
    }

    public void togglePause() {
        this.setPause(!this.paused);
    }

    public void setPause(boolean pause) {
        this.paused = pause;
        this.sendToAll(this.msgMisc(this.paused ? 1 : 0));
    }

    private class GameServerListener
    extends Listener {
        private Connection isFullSlot;
        boolean success;

        private GameServerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onConnect(Socket socket) {
            this.success = false;
            Object object = FGAServer.this.lock;
            synchronized (object) {
                int freeSlot;
                System.out.println("Client " + socket.getInetAddress().getHostAddress() + " is connecting...");
                if (FGAServer.this.dedicated) {
                    UserInterface.get().addChat("Client " + socket.getInetAddress().getHostAddress() + " is connecting...");
                }
                if ((freeSlot = FGAServer.this.getFreeSlot()) > -1) {
                    FGAServer.this.clients[freeSlot] = new Client(socket, freeSlot);
                    this.success = true;
                    FGAServer.this.sendToAll(FGAServer.this.msgConnecting(FGAServer.this.clients[freeSlot]));
                } else {
                    this.isFullSlot = new Connection();
                    this.isFullSlot.bind(socket);
                    this.isFullSlot.send(FGAServer.this.msgServerIsFull());
                }
            }
            if (!this.success) {
                Misc.sleep(1000L);
                this.isFullSlot.disconnect();
                this.isFullSlot = null;
            }
        }
    }
}

